/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** CashflowType */
public class CashflowType {
  StringUtil util = new StringUtil();

  @JsonProperty("name")
  private String name;

  @JsonProperty("total")
  private Double total;

  @JsonProperty("accounts")
  private List<CashflowAccount> accounts = new ArrayList<CashflowAccount>();

  /**
   * Name of the activity
   *
   * @param name String
   * @return CashflowType
   */
  public CashflowType name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Name of the activity
   *
   * @return name
   */
  @ApiModelProperty(value = "Name of the activity")
  /**
   * Name of the activity
   *
   * @return name String
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the activity
   *
   * @param name String
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Total value of the activity
   *
   * @param total Double
   * @return CashflowType
   */
  public CashflowType total(Double total) {
    this.total = total;
    return this;
  }

  /**
   * Total value of the activity
   *
   * @return total
   */
  @ApiModelProperty(value = "Total value of the activity")
  /**
   * Total value of the activity
   *
   * @return total Double
   */
  public Double getTotal() {
    return total;
  }

  /**
   * Total value of the activity
   *
   * @param total Double
   */
  public void setTotal(Double total) {
    this.total = total;
  }

  /**
   * List of the accounts in this activity
   *
   * @param accounts List&lt;CashflowAccount&gt;
   * @return CashflowType
   */
  public CashflowType accounts(List<CashflowAccount> accounts) {
    this.accounts = accounts;
    return this;
  }

  /**
   * List of the accounts in this activity
   *
   * @param accountsItem CashflowAccount
   * @return CashflowType
   */
  public CashflowType addAccountsItem(CashflowAccount accountsItem) {
    if (this.accounts == null) {
      this.accounts = new ArrayList<CashflowAccount>();
    }
    this.accounts.add(accountsItem);
    return this;
  }

  /**
   * List of the accounts in this activity
   *
   * @return accounts
   */
  @ApiModelProperty(value = "List of the accounts in this activity")
  /**
   * List of the accounts in this activity
   *
   * @return accounts List<CashflowAccount>
   */
  public List<CashflowAccount> getAccounts() {
    return accounts;
  }

  /**
   * List of the accounts in this activity
   *
   * @param accounts List&lt;CashflowAccount&gt;
   */
  public void setAccounts(List<CashflowAccount> accounts) {
    this.accounts = accounts;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CashflowType cashflowType = (CashflowType) o;
    return Objects.equals(this.name, cashflowType.name)
        && Objects.equals(this.total, cashflowType.total)
        && Objects.equals(this.accounts, cashflowType.accounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, total, accounts);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CashflowType {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    accounts: ").append(toIndentedString(accounts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
