/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** ContactResponse */
public class ContactResponse {
  StringUtil util = new StringUtil();

  @JsonProperty("contactId")
  private UUID contactId;

  @JsonProperty("contactName")
  private String contactName;

  /**
   * Xero Identifier of contact
   *
   * @param contactId UUID
   * @return ContactResponse
   */
  public ContactResponse contactId(UUID contactId) {
    this.contactId = contactId;
    return this;
  }

  /**
   * Xero Identifier of contact
   *
   * @return contactId
   */
  @ApiModelProperty(value = "Xero Identifier of contact")
  /**
   * Xero Identifier of contact
   *
   * @return contactId UUID
   */
  public UUID getContactId() {
    return contactId;
  }

  /**
   * Xero Identifier of contact
   *
   * @param contactId UUID
   */
  public void setContactId(UUID contactId) {
    this.contactId = contactId;
  }

  /**
   * Full name of contact/organisation
   *
   * @param contactName String
   * @return ContactResponse
   */
  public ContactResponse contactName(String contactName) {
    this.contactName = contactName;
    return this;
  }

  /**
   * Full name of contact/organisation
   *
   * @return contactName
   */
  @ApiModelProperty(value = "Full name of contact/organisation")
  /**
   * Full name of contact/organisation
   *
   * @return contactName String
   */
  public String getContactName() {
    return contactName;
  }

  /**
   * Full name of contact/organisation
   *
   * @param contactName String
   */
  public void setContactName(String contactName) {
    this.contactName = contactName;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ContactResponse contactResponse = (ContactResponse) o;
    return Objects.equals(this.contactId, contactResponse.contactId)
        && Objects.equals(this.contactName, contactResponse.contactName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contactId, contactName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ContactResponse {\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    contactName: ").append(toIndentedString(contactName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
