/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** ContactTotalOther */
public class ContactTotalOther {
  StringUtil util = new StringUtil();

  @JsonProperty("totalOutstandingAged")
  private Double totalOutstandingAged;

  @JsonProperty("totalVoided")
  private Double totalVoided;

  @JsonProperty("totalCredited")
  private Double totalCredited;

  @JsonProperty("transactionCount")
  private Integer transactionCount;

  /**
   * Total outstanding invoice value for the contact within the period where the invoices are more
   * than 90 days old
   *
   * @param totalOutstandingAged Double
   * @return ContactTotalOther
   */
  public ContactTotalOther totalOutstandingAged(Double totalOutstandingAged) {
    this.totalOutstandingAged = totalOutstandingAged;
    return this;
  }

  /**
   * Total outstanding invoice value for the contact within the period where the invoices are more
   * than 90 days old
   *
   * @return totalOutstandingAged
   */
  @ApiModelProperty(
      value =
          "Total outstanding invoice value for the contact within the period where the invoices are"
              + " more than 90 days old")
  /**
   * Total outstanding invoice value for the contact within the period where the invoices are more
   * than 90 days old
   *
   * @return totalOutstandingAged Double
   */
  public Double getTotalOutstandingAged() {
    return totalOutstandingAged;
  }

  /**
   * Total outstanding invoice value for the contact within the period where the invoices are more
   * than 90 days old
   *
   * @param totalOutstandingAged Double
   */
  public void setTotalOutstandingAged(Double totalOutstandingAged) {
    this.totalOutstandingAged = totalOutstandingAged;
  }

  /**
   * Total voided value for the contact.
   *
   * @param totalVoided Double
   * @return ContactTotalOther
   */
  public ContactTotalOther totalVoided(Double totalVoided) {
    this.totalVoided = totalVoided;
    return this;
  }

  /**
   * Total voided value for the contact.
   *
   * @return totalVoided
   */
  @ApiModelProperty(value = "Total voided value for the contact.")
  /**
   * Total voided value for the contact.
   *
   * @return totalVoided Double
   */
  public Double getTotalVoided() {
    return totalVoided;
  }

  /**
   * Total voided value for the contact.
   *
   * @param totalVoided Double
   */
  public void setTotalVoided(Double totalVoided) {
    this.totalVoided = totalVoided;
  }

  /**
   * Total credited value for the contact.
   *
   * @param totalCredited Double
   * @return ContactTotalOther
   */
  public ContactTotalOther totalCredited(Double totalCredited) {
    this.totalCredited = totalCredited;
    return this;
  }

  /**
   * Total credited value for the contact.
   *
   * @return totalCredited
   */
  @ApiModelProperty(value = "Total credited value for the contact.")
  /**
   * Total credited value for the contact.
   *
   * @return totalCredited Double
   */
  public Double getTotalCredited() {
    return totalCredited;
  }

  /**
   * Total credited value for the contact.
   *
   * @param totalCredited Double
   */
  public void setTotalCredited(Double totalCredited) {
    this.totalCredited = totalCredited;
  }

  /**
   * Number of transactions for the contact.
   *
   * @param transactionCount Integer
   * @return ContactTotalOther
   */
  public ContactTotalOther transactionCount(Integer transactionCount) {
    this.transactionCount = transactionCount;
    return this;
  }

  /**
   * Number of transactions for the contact.
   *
   * @return transactionCount
   */
  @ApiModelProperty(value = "Number of transactions for the contact.")
  /**
   * Number of transactions for the contact.
   *
   * @return transactionCount Integer
   */
  public Integer getTransactionCount() {
    return transactionCount;
  }

  /**
   * Number of transactions for the contact.
   *
   * @param transactionCount Integer
   */
  public void setTransactionCount(Integer transactionCount) {
    this.transactionCount = transactionCount;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ContactTotalOther contactTotalOther = (ContactTotalOther) o;
    return Objects.equals(this.totalOutstandingAged, contactTotalOther.totalOutstandingAged)
        && Objects.equals(this.totalVoided, contactTotalOther.totalVoided)
        && Objects.equals(this.totalCredited, contactTotalOther.totalCredited)
        && Objects.equals(this.transactionCount, contactTotalOther.transactionCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalOutstandingAged, totalVoided, totalCredited, transactionCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ContactTotalOther {\n");
    sb.append("    totalOutstandingAged: ")
        .append(toIndentedString(totalOutstandingAged))
        .append("\n");
    sb.append("    totalVoided: ").append(toIndentedString(totalVoided)).append("\n");
    sb.append("    totalCredited: ").append(toIndentedString(totalCredited)).append("\n");
    sb.append("    transactionCount: ").append(toIndentedString(transactionCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
