/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.LocalDate;

/** IncomeByContactResponse */
public class IncomeByContactResponse {
  StringUtil util = new StringUtil();

  @JsonProperty("startDate")
  private LocalDate startDate;

  @JsonProperty("endDate")
  private LocalDate endDate;

  @JsonProperty("total")
  private Double total;

  @JsonProperty("totalDetail")
  private TotalDetail totalDetail;

  @JsonProperty("totalOther")
  private TotalOther totalOther;

  @JsonProperty("contacts")
  private List<ContactDetail> contacts = new ArrayList<ContactDetail>();

  @JsonProperty("manualJournals")
  private ManualJournalTotal manualJournals;

  /**
   * Start date of the report
   *
   * @param startDate LocalDate
   * @return IncomeByContactResponse
   */
  public IncomeByContactResponse startDate(LocalDate startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Start date of the report
   *
   * @return startDate
   */
  @ApiModelProperty(value = "Start date of the report")
  /**
   * Start date of the report
   *
   * @return startDate LocalDate
   */
  public LocalDate getStartDate() {
    return startDate;
  }

  /**
   * Start date of the report
   *
   * @param startDate LocalDate
   */
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  /**
   * End date of the report
   *
   * @param endDate LocalDate
   * @return IncomeByContactResponse
   */
  public IncomeByContactResponse endDate(LocalDate endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * End date of the report
   *
   * @return endDate
   */
  @ApiModelProperty(value = "End date of the report")
  /**
   * End date of the report
   *
   * @return endDate LocalDate
   */
  public LocalDate getEndDate() {
    return endDate;
  }

  /**
   * End date of the report
   *
   * @param endDate LocalDate
   */
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }

  /**
   * Total value
   *
   * @param total Double
   * @return IncomeByContactResponse
   */
  public IncomeByContactResponse total(Double total) {
    this.total = total;
    return this;
  }

  /**
   * Total value
   *
   * @return total
   */
  @ApiModelProperty(value = "Total value")
  /**
   * Total value
   *
   * @return total Double
   */
  public Double getTotal() {
    return total;
  }

  /**
   * Total value
   *
   * @param total Double
   */
  public void setTotal(Double total) {
    this.total = total;
  }

  /**
   * totalDetail
   *
   * @param totalDetail TotalDetail
   * @return IncomeByContactResponse
   */
  public IncomeByContactResponse totalDetail(TotalDetail totalDetail) {
    this.totalDetail = totalDetail;
    return this;
  }

  /**
   * Get totalDetail
   *
   * @return totalDetail
   */
  @ApiModelProperty(value = "")
  /**
   * totalDetail
   *
   * @return totalDetail TotalDetail
   */
  public TotalDetail getTotalDetail() {
    return totalDetail;
  }

  /**
   * totalDetail
   *
   * @param totalDetail TotalDetail
   */
  public void setTotalDetail(TotalDetail totalDetail) {
    this.totalDetail = totalDetail;
  }

  /**
   * totalOther
   *
   * @param totalOther TotalOther
   * @return IncomeByContactResponse
   */
  public IncomeByContactResponse totalOther(TotalOther totalOther) {
    this.totalOther = totalOther;
    return this;
  }

  /**
   * Get totalOther
   *
   * @return totalOther
   */
  @ApiModelProperty(value = "")
  /**
   * totalOther
   *
   * @return totalOther TotalOther
   */
  public TotalOther getTotalOther() {
    return totalOther;
  }

  /**
   * totalOther
   *
   * @param totalOther TotalOther
   */
  public void setTotalOther(TotalOther totalOther) {
    this.totalOther = totalOther;
  }

  /**
   * contacts
   *
   * @param contacts List&lt;ContactDetail&gt;
   * @return IncomeByContactResponse
   */
  public IncomeByContactResponse contacts(List<ContactDetail> contacts) {
    this.contacts = contacts;
    return this;
  }

  /**
   * contacts
   *
   * @param contactsItem ContactDetail
   * @return IncomeByContactResponse
   */
  public IncomeByContactResponse addContactsItem(ContactDetail contactsItem) {
    if (this.contacts == null) {
      this.contacts = new ArrayList<ContactDetail>();
    }
    this.contacts.add(contactsItem);
    return this;
  }

  /**
   * Get contacts
   *
   * @return contacts
   */
  @ApiModelProperty(value = "")
  /**
   * contacts
   *
   * @return contacts List<ContactDetail>
   */
  public List<ContactDetail> getContacts() {
    return contacts;
  }

  /**
   * contacts
   *
   * @param contacts List&lt;ContactDetail&gt;
   */
  public void setContacts(List<ContactDetail> contacts) {
    this.contacts = contacts;
  }

  /**
   * manualJournals
   *
   * @param manualJournals ManualJournalTotal
   * @return IncomeByContactResponse
   */
  public IncomeByContactResponse manualJournals(ManualJournalTotal manualJournals) {
    this.manualJournals = manualJournals;
    return this;
  }

  /**
   * Get manualJournals
   *
   * @return manualJournals
   */
  @ApiModelProperty(value = "")
  /**
   * manualJournals
   *
   * @return manualJournals ManualJournalTotal
   */
  public ManualJournalTotal getManualJournals() {
    return manualJournals;
  }

  /**
   * manualJournals
   *
   * @param manualJournals ManualJournalTotal
   */
  public void setManualJournals(ManualJournalTotal manualJournals) {
    this.manualJournals = manualJournals;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncomeByContactResponse incomeByContactResponse = (IncomeByContactResponse) o;
    return Objects.equals(this.startDate, incomeByContactResponse.startDate)
        && Objects.equals(this.endDate, incomeByContactResponse.endDate)
        && Objects.equals(this.total, incomeByContactResponse.total)
        && Objects.equals(this.totalDetail, incomeByContactResponse.totalDetail)
        && Objects.equals(this.totalOther, incomeByContactResponse.totalOther)
        && Objects.equals(this.contacts, incomeByContactResponse.contacts)
        && Objects.equals(this.manualJournals, incomeByContactResponse.manualJournals);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        startDate, endDate, total, totalDetail, totalOther, contacts, manualJournals);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncomeByContactResponse {\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    totalDetail: ").append(toIndentedString(totalDetail)).append("\n");
    sb.append("    totalOther: ").append(toIndentedString(totalOther)).append("\n");
    sb.append("    contacts: ").append(toIndentedString(contacts)).append("\n");
    sb.append("    manualJournals: ").append(toIndentedString(manualJournals)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
