/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** LineItemResponse */
public class LineItemResponse {
  StringUtil util = new StringUtil();

  @JsonProperty("accountId")
  private UUID accountId;

  @JsonProperty("reportingCode")
  private String reportingCode;

  @JsonProperty("lineAmount")
  private Double lineAmount;

  @JsonProperty("accountType")
  private String accountType;

  /**
   * Xero Identifier of account
   *
   * @param accountId UUID
   * @return LineItemResponse
   */
  public LineItemResponse accountId(UUID accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Xero Identifier of account
   *
   * @return accountId
   */
  @ApiModelProperty(value = "Xero Identifier of account")
  /**
   * Xero Identifier of account
   *
   * @return accountId UUID
   */
  public UUID getAccountId() {
    return accountId;
  }

  /**
   * Xero Identifier of account
   *
   * @param accountId UUID
   */
  public void setAccountId(UUID accountId) {
    this.accountId = accountId;
  }

  /**
   * Shown if set
   *
   * @param reportingCode String
   * @return LineItemResponse
   */
  public LineItemResponse reportingCode(String reportingCode) {
    this.reportingCode = reportingCode;
    return this;
  }

  /**
   * Shown if set
   *
   * @return reportingCode
   */
  @ApiModelProperty(value = "Shown if set")
  /**
   * Shown if set
   *
   * @return reportingCode String
   */
  public String getReportingCode() {
    return reportingCode;
  }

  /**
   * Shown if set
   *
   * @param reportingCode String
   */
  public void setReportingCode(String reportingCode) {
    this.reportingCode = reportingCode;
  }

  /**
   * Amount of line item
   *
   * @param lineAmount Double
   * @return LineItemResponse
   */
  public LineItemResponse lineAmount(Double lineAmount) {
    this.lineAmount = lineAmount;
    return this;
  }

  /**
   * Amount of line item
   *
   * @return lineAmount
   */
  @ApiModelProperty(value = "Amount of line item")
  /**
   * Amount of line item
   *
   * @return lineAmount Double
   */
  public Double getLineAmount() {
    return lineAmount;
  }

  /**
   * Amount of line item
   *
   * @param lineAmount Double
   */
  public void setLineAmount(Double lineAmount) {
    this.lineAmount = lineAmount;
  }

  /**
   * Account type
   *
   * @param accountType String
   * @return LineItemResponse
   */
  public LineItemResponse accountType(String accountType) {
    this.accountType = accountType;
    return this;
  }

  /**
   * Account type
   *
   * @return accountType
   */
  @ApiModelProperty(value = "Account type")
  /**
   * Account type
   *
   * @return accountType String
   */
  public String getAccountType() {
    return accountType;
  }

  /**
   * Account type
   *
   * @param accountType String
   */
  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LineItemResponse lineItemResponse = (LineItemResponse) o;
    return Objects.equals(this.accountId, lineItemResponse.accountId)
        && Objects.equals(this.reportingCode, lineItemResponse.reportingCode)
        && Objects.equals(this.lineAmount, lineItemResponse.lineAmount)
        && Objects.equals(this.accountType, lineItemResponse.accountType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, reportingCode, lineAmount, accountType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LineItemResponse {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    reportingCode: ").append(toIndentedString(reportingCode)).append("\n");
    sb.append("    lineAmount: ").append(toIndentedString(lineAmount)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
