/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

/** LockHistoryResponse */
public class LockHistoryResponse {
  StringUtil util = new StringUtil();

  @JsonProperty("organisationId")
  private UUID organisationId;

  @JsonProperty("endDate")
  private LocalDate endDate;

  @JsonProperty("lockDates")
  private List<LockHistoryModel> lockDates = new ArrayList<LockHistoryModel>();

  /**
   * The requested Organisation to which the data pertains
   *
   * @param organisationId UUID
   * @return LockHistoryResponse
   */
  public LockHistoryResponse organisationId(UUID organisationId) {
    this.organisationId = organisationId;
    return this;
  }

  /**
   * The requested Organisation to which the data pertains
   *
   * @return organisationId
   */
  @ApiModelProperty(value = "The requested Organisation to which the data pertains")
  /**
   * The requested Organisation to which the data pertains
   *
   * @return organisationId UUID
   */
  public UUID getOrganisationId() {
    return organisationId;
  }

  /**
   * The requested Organisation to which the data pertains
   *
   * @param organisationId UUID
   */
  public void setOrganisationId(UUID organisationId) {
    this.organisationId = organisationId;
  }

  /**
   * The end date of the report
   *
   * @param endDate LocalDate
   * @return LockHistoryResponse
   */
  public LockHistoryResponse endDate(LocalDate endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * The end date of the report
   *
   * @return endDate
   */
  @ApiModelProperty(value = "The end date of the report")
  /**
   * The end date of the report
   *
   * @return endDate LocalDate
   */
  public LocalDate getEndDate() {
    return endDate;
  }

  /**
   * The end date of the report
   *
   * @param endDate LocalDate
   */
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }

  /**
   * lockDates
   *
   * @param lockDates List&lt;LockHistoryModel&gt;
   * @return LockHistoryResponse
   */
  public LockHistoryResponse lockDates(List<LockHistoryModel> lockDates) {
    this.lockDates = lockDates;
    return this;
  }

  /**
   * lockDates
   *
   * @param lockDatesItem LockHistoryModel
   * @return LockHistoryResponse
   */
  public LockHistoryResponse addLockDatesItem(LockHistoryModel lockDatesItem) {
    if (this.lockDates == null) {
      this.lockDates = new ArrayList<LockHistoryModel>();
    }
    this.lockDates.add(lockDatesItem);
    return this;
  }

  /**
   * Get lockDates
   *
   * @return lockDates
   */
  @ApiModelProperty(value = "")
  /**
   * lockDates
   *
   * @return lockDates List<LockHistoryModel>
   */
  public List<LockHistoryModel> getLockDates() {
    return lockDates;
  }

  /**
   * lockDates
   *
   * @param lockDates List&lt;LockHistoryModel&gt;
   */
  public void setLockDates(List<LockHistoryModel> lockDates) {
    this.lockDates = lockDates;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LockHistoryResponse lockHistoryResponse = (LockHistoryResponse) o;
    return Objects.equals(this.organisationId, lockHistoryResponse.organisationId)
        && Objects.equals(this.endDate, lockHistoryResponse.endDate)
        && Objects.equals(this.lockDates, lockHistoryResponse.lockDates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(organisationId, endDate, lockDates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LockHistoryResponse {\n");
    sb.append("    organisationId: ").append(toIndentedString(organisationId)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    lockDates: ").append(toIndentedString(lockDates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
