/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

/** ReportHistoryResponse */
public class ReportHistoryResponse {
  StringUtil util = new StringUtil();

  @JsonProperty("organisationId")
  private UUID organisationId;

  @JsonProperty("endDate")
  private LocalDate endDate;

  @JsonProperty("reports")
  private List<ReportHistoryModel> reports = new ArrayList<ReportHistoryModel>();

  /**
   * The requested Organisation to which the data pertains
   *
   * @param organisationId UUID
   * @return ReportHistoryResponse
   */
  public ReportHistoryResponse organisationId(UUID organisationId) {
    this.organisationId = organisationId;
    return this;
  }

  /**
   * The requested Organisation to which the data pertains
   *
   * @return organisationId
   */
  @ApiModelProperty(value = "The requested Organisation to which the data pertains")
  /**
   * The requested Organisation to which the data pertains
   *
   * @return organisationId UUID
   */
  public UUID getOrganisationId() {
    return organisationId;
  }

  /**
   * The requested Organisation to which the data pertains
   *
   * @param organisationId UUID
   */
  public void setOrganisationId(UUID organisationId) {
    this.organisationId = organisationId;
  }

  /**
   * The end date of the report
   *
   * @param endDate LocalDate
   * @return ReportHistoryResponse
   */
  public ReportHistoryResponse endDate(LocalDate endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * The end date of the report
   *
   * @return endDate
   */
  @ApiModelProperty(value = "The end date of the report")
  /**
   * The end date of the report
   *
   * @return endDate LocalDate
   */
  public LocalDate getEndDate() {
    return endDate;
  }

  /**
   * The end date of the report
   *
   * @param endDate LocalDate
   */
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }

  /**
   * reports
   *
   * @param reports List&lt;ReportHistoryModel&gt;
   * @return ReportHistoryResponse
   */
  public ReportHistoryResponse reports(List<ReportHistoryModel> reports) {
    this.reports = reports;
    return this;
  }

  /**
   * reports
   *
   * @param reportsItem ReportHistoryModel
   * @return ReportHistoryResponse
   */
  public ReportHistoryResponse addReportsItem(ReportHistoryModel reportsItem) {
    if (this.reports == null) {
      this.reports = new ArrayList<ReportHistoryModel>();
    }
    this.reports.add(reportsItem);
    return this;
  }

  /**
   * Get reports
   *
   * @return reports
   */
  @ApiModelProperty(value = "")
  /**
   * reports
   *
   * @return reports List<ReportHistoryModel>
   */
  public List<ReportHistoryModel> getReports() {
    return reports;
  }

  /**
   * reports
   *
   * @param reports List&lt;ReportHistoryModel&gt;
   */
  public void setReports(List<ReportHistoryModel> reports) {
    this.reports = reports;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReportHistoryResponse reportHistoryResponse = (ReportHistoryResponse) o;
    return Objects.equals(this.organisationId, reportHistoryResponse.organisationId)
        && Objects.equals(this.endDate, reportHistoryResponse.endDate)
        && Objects.equals(this.reports, reportHistoryResponse.reports);
  }

  @Override
  public int hashCode() {
    return Objects.hash(organisationId, endDate, reports);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReportHistoryResponse {\n");
    sb.append("    organisationId: ").append(toIndentedString(organisationId)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    reports: ").append(toIndentedString(reports)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
