/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** TrialBalanceAccount */
public class TrialBalanceAccount {
  StringUtil util = new StringUtil();

  @JsonProperty("accountId")
  private UUID accountId;

  @JsonProperty("accountType")
  private String accountType;

  @JsonProperty("accountCode")
  private String accountCode;

  @JsonProperty("accountClass")
  private String accountClass;

  @JsonProperty("status")
  private String status;

  @JsonProperty("reportingCode")
  private String reportingCode;

  @JsonProperty("accountName")
  private String accountName;

  @JsonProperty("balance")
  private TrialBalanceEntry balance;

  @JsonProperty("signedBalance")
  private Double signedBalance;

  @JsonProperty("accountMovement")
  private TrialBalanceMovement accountMovement;

  /**
   * ID of the account
   *
   * @param accountId UUID
   * @return TrialBalanceAccount
   */
  public TrialBalanceAccount accountId(UUID accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * ID of the account
   *
   * @return accountId
   */
  @ApiModelProperty(value = "ID of the account")
  /**
   * ID of the account
   *
   * @return accountId UUID
   */
  public UUID getAccountId() {
    return accountId;
  }

  /**
   * ID of the account
   *
   * @param accountId UUID
   */
  public void setAccountId(UUID accountId) {
    this.accountId = accountId;
  }

  /**
   * The type of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountTypes&#39;&gt;Account
   * Types&lt;/a&gt;
   *
   * @param accountType String
   * @return TrialBalanceAccount
   */
  public TrialBalanceAccount accountType(String accountType) {
    this.accountType = accountType;
    return this;
  }

  /**
   * The type of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountTypes&#39;&gt;Account
   * Types&lt;/a&gt;
   *
   * @return accountType
   */
  @ApiModelProperty(
      value =
          "The type of the account. See <a"
              + " href='https://developer.xero.com/documentation/api/types#AccountTypes'>Account"
              + " Types</a>")
  /**
   * The type of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountTypes&#39;&gt;Account
   * Types&lt;/a&gt;
   *
   * @return accountType String
   */
  public String getAccountType() {
    return accountType;
  }

  /**
   * The type of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountTypes&#39;&gt;Account
   * Types&lt;/a&gt;
   *
   * @param accountType String
   */
  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }

  /**
   * Customer defined alpha numeric account code e.g 200 or SALES
   *
   * @param accountCode String
   * @return TrialBalanceAccount
   */
  public TrialBalanceAccount accountCode(String accountCode) {
    this.accountCode = accountCode;
    return this;
  }

  /**
   * Customer defined alpha numeric account code e.g 200 or SALES
   *
   * @return accountCode
   */
  @ApiModelProperty(value = "Customer defined alpha numeric account code e.g 200 or SALES")
  /**
   * Customer defined alpha numeric account code e.g 200 or SALES
   *
   * @return accountCode String
   */
  public String getAccountCode() {
    return accountCode;
  }

  /**
   * Customer defined alpha numeric account code e.g 200 or SALES
   *
   * @param accountCode String
   */
  public void setAccountCode(String accountCode) {
    this.accountCode = accountCode;
  }

  /**
   * The class of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountClassTypes&#39;&gt;Account
   * Class Types&lt;/a&gt;
   *
   * @param accountClass String
   * @return TrialBalanceAccount
   */
  public TrialBalanceAccount accountClass(String accountClass) {
    this.accountClass = accountClass;
    return this;
  }

  /**
   * The class of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountClassTypes&#39;&gt;Account
   * Class Types&lt;/a&gt;
   *
   * @return accountClass
   */
  @ApiModelProperty(
      value =
          "The class of the account. See <a"
              + " href='https://developer.xero.com/documentation/api/types#AccountClassTypes'>Account"
              + " Class Types</a>")
  /**
   * The class of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountClassTypes&#39;&gt;Account
   * Class Types&lt;/a&gt;
   *
   * @return accountClass String
   */
  public String getAccountClass() {
    return accountClass;
  }

  /**
   * The class of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountClassTypes&#39;&gt;Account
   * Class Types&lt;/a&gt;
   *
   * @param accountClass String
   */
  public void setAccountClass(String accountClass) {
    this.accountClass = accountClass;
  }

  /**
   * Accounts with a status of ACTIVE can be updated to ARCHIVED. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountStatusCodes&#39;&gt;Account
   * Status Codes&lt;/a&gt;
   *
   * @param status String
   * @return TrialBalanceAccount
   */
  public TrialBalanceAccount status(String status) {
    this.status = status;
    return this;
  }

  /**
   * Accounts with a status of ACTIVE can be updated to ARCHIVED. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountStatusCodes&#39;&gt;Account
   * Status Codes&lt;/a&gt;
   *
   * @return status
   */
  @ApiModelProperty(
      value =
          "Accounts with a status of ACTIVE can be updated to ARCHIVED. See <a"
              + " href='https://developer.xero.com/documentation/api/types#AccountStatusCodes'>Account"
              + " Status Codes</a>")
  /**
   * Accounts with a status of ACTIVE can be updated to ARCHIVED. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountStatusCodes&#39;&gt;Account
   * Status Codes&lt;/a&gt;
   *
   * @return status String
   */
  public String getStatus() {
    return status;
  }

  /**
   * Accounts with a status of ACTIVE can be updated to ARCHIVED. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountStatusCodes&#39;&gt;Account
   * Status Codes&lt;/a&gt;
   *
   * @param status String
   */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * Reporting code (Shown if set)
   *
   * @param reportingCode String
   * @return TrialBalanceAccount
   */
  public TrialBalanceAccount reportingCode(String reportingCode) {
    this.reportingCode = reportingCode;
    return this;
  }

  /**
   * Reporting code (Shown if set)
   *
   * @return reportingCode
   */
  @ApiModelProperty(value = "Reporting code (Shown if set)")
  /**
   * Reporting code (Shown if set)
   *
   * @return reportingCode String
   */
  public String getReportingCode() {
    return reportingCode;
  }

  /**
   * Reporting code (Shown if set)
   *
   * @param reportingCode String
   */
  public void setReportingCode(String reportingCode) {
    this.reportingCode = reportingCode;
  }

  /**
   * Name of the account
   *
   * @param accountName String
   * @return TrialBalanceAccount
   */
  public TrialBalanceAccount accountName(String accountName) {
    this.accountName = accountName;
    return this;
  }

  /**
   * Name of the account
   *
   * @return accountName
   */
  @ApiModelProperty(value = "Name of the account")
  /**
   * Name of the account
   *
   * @return accountName String
   */
  public String getAccountName() {
    return accountName;
  }

  /**
   * Name of the account
   *
   * @param accountName String
   */
  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }

  /**
   * balance
   *
   * @param balance TrialBalanceEntry
   * @return TrialBalanceAccount
   */
  public TrialBalanceAccount balance(TrialBalanceEntry balance) {
    this.balance = balance;
    return this;
  }

  /**
   * Get balance
   *
   * @return balance
   */
  @ApiModelProperty(value = "")
  /**
   * balance
   *
   * @return balance TrialBalanceEntry
   */
  public TrialBalanceEntry getBalance() {
    return balance;
  }

  /**
   * balance
   *
   * @param balance TrialBalanceEntry
   */
  public void setBalance(TrialBalanceEntry balance) {
    this.balance = balance;
  }

  /**
   * Value of balance. Expense and Asset accounts code debits as positive. Revenue, Liability, and
   * Equity accounts code debits as negative
   *
   * @param signedBalance Double
   * @return TrialBalanceAccount
   */
  public TrialBalanceAccount signedBalance(Double signedBalance) {
    this.signedBalance = signedBalance;
    return this;
  }

  /**
   * Value of balance. Expense and Asset accounts code debits as positive. Revenue, Liability, and
   * Equity accounts code debits as negative
   *
   * @return signedBalance
   */
  @ApiModelProperty(
      value =
          "Value of balance. Expense and Asset accounts code debits as positive. Revenue,"
              + " Liability, and Equity accounts code debits as negative")
  /**
   * Value of balance. Expense and Asset accounts code debits as positive. Revenue, Liability, and
   * Equity accounts code debits as negative
   *
   * @return signedBalance Double
   */
  public Double getSignedBalance() {
    return signedBalance;
  }

  /**
   * Value of balance. Expense and Asset accounts code debits as positive. Revenue, Liability, and
   * Equity accounts code debits as negative
   *
   * @param signedBalance Double
   */
  public void setSignedBalance(Double signedBalance) {
    this.signedBalance = signedBalance;
  }

  /**
   * accountMovement
   *
   * @param accountMovement TrialBalanceMovement
   * @return TrialBalanceAccount
   */
  public TrialBalanceAccount accountMovement(TrialBalanceMovement accountMovement) {
    this.accountMovement = accountMovement;
    return this;
  }

  /**
   * Get accountMovement
   *
   * @return accountMovement
   */
  @ApiModelProperty(value = "")
  /**
   * accountMovement
   *
   * @return accountMovement TrialBalanceMovement
   */
  public TrialBalanceMovement getAccountMovement() {
    return accountMovement;
  }

  /**
   * accountMovement
   *
   * @param accountMovement TrialBalanceMovement
   */
  public void setAccountMovement(TrialBalanceMovement accountMovement) {
    this.accountMovement = accountMovement;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TrialBalanceAccount trialBalanceAccount = (TrialBalanceAccount) o;
    return Objects.equals(this.accountId, trialBalanceAccount.accountId)
        && Objects.equals(this.accountType, trialBalanceAccount.accountType)
        && Objects.equals(this.accountCode, trialBalanceAccount.accountCode)
        && Objects.equals(this.accountClass, trialBalanceAccount.accountClass)
        && Objects.equals(this.status, trialBalanceAccount.status)
        && Objects.equals(this.reportingCode, trialBalanceAccount.reportingCode)
        && Objects.equals(this.accountName, trialBalanceAccount.accountName)
        && Objects.equals(this.balance, trialBalanceAccount.balance)
        && Objects.equals(this.signedBalance, trialBalanceAccount.signedBalance)
        && Objects.equals(this.accountMovement, trialBalanceAccount.accountMovement);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        accountId,
        accountType,
        accountCode,
        accountClass,
        status,
        reportingCode,
        accountName,
        balance,
        signedBalance,
        accountMovement);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TrialBalanceAccount {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    accountCode: ").append(toIndentedString(accountCode)).append("\n");
    sb.append("    accountClass: ").append(toIndentedString(accountClass)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    reportingCode: ").append(toIndentedString(reportingCode)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
    sb.append("    signedBalance: ").append(toIndentedString(signedBalance)).append("\n");
    sb.append("    accountMovement: ").append(toIndentedString(accountMovement)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
