/*
 * Xero Payroll AU API
 * This is the Xero Payroll API for orgs in Australia region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** HomeAddress */
public class HomeAddress {
  StringUtil util = new StringUtil();

  @JsonProperty("AddressLine1")
  private String addressLine1;

  @JsonProperty("AddressLine2")
  private String addressLine2;

  @JsonProperty("City")
  private String city;

  @JsonProperty("Region")
  private State region;

  @JsonProperty("PostalCode")
  private String postalCode;

  @JsonProperty("Country")
  private String country;

  /**
   * Address line 1 for employee home address
   *
   * @param addressLine1 String
   * @return HomeAddress
   */
  public HomeAddress addressLine1(String addressLine1) {
    this.addressLine1 = addressLine1;
    return this;
  }

  /**
   * Address line 1 for employee home address
   *
   * @return addressLine1
   */
  @ApiModelProperty(
      example = "123 Main St",
      required = true,
      value = "Address line 1 for employee home address")
  /**
   * Address line 1 for employee home address
   *
   * @return addressLine1 String
   */
  public String getAddressLine1() {
    return addressLine1;
  }

  /**
   * Address line 1 for employee home address
   *
   * @param addressLine1 String
   */
  public void setAddressLine1(String addressLine1) {
    this.addressLine1 = addressLine1;
  }

  /**
   * Address line 2 for employee home address
   *
   * @param addressLine2 String
   * @return HomeAddress
   */
  public HomeAddress addressLine2(String addressLine2) {
    this.addressLine2 = addressLine2;
    return this;
  }

  /**
   * Address line 2 for employee home address
   *
   * @return addressLine2
   */
  @ApiModelProperty(example = "Apt 4", value = "Address line 2 for employee home address")
  /**
   * Address line 2 for employee home address
   *
   * @return addressLine2 String
   */
  public String getAddressLine2() {
    return addressLine2;
  }

  /**
   * Address line 2 for employee home address
   *
   * @param addressLine2 String
   */
  public void setAddressLine2(String addressLine2) {
    this.addressLine2 = addressLine2;
  }

  /**
   * Suburb for employee home address
   *
   * @param city String
   * @return HomeAddress
   */
  public HomeAddress city(String city) {
    this.city = city;
    return this;
  }

  /**
   * Suburb for employee home address
   *
   * @return city
   */
  @ApiModelProperty(example = "St. Kilda", value = "Suburb for employee home address")
  /**
   * Suburb for employee home address
   *
   * @return city String
   */
  public String getCity() {
    return city;
  }

  /**
   * Suburb for employee home address
   *
   * @param city String
   */
  public void setCity(String city) {
    this.city = city;
  }

  /**
   * region
   *
   * @param region State
   * @return HomeAddress
   */
  public HomeAddress region(State region) {
    this.region = region;
    return this;
  }

  /**
   * Get region
   *
   * @return region
   */
  @ApiModelProperty(value = "")
  /**
   * region
   *
   * @return region State
   */
  public State getRegion() {
    return region;
  }

  /**
   * region
   *
   * @param region State
   */
  public void setRegion(State region) {
    this.region = region;
  }

  /**
   * PostCode for employee home address
   *
   * @param postalCode String
   * @return HomeAddress
   */
  public HomeAddress postalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

  /**
   * PostCode for employee home address
   *
   * @return postalCode
   */
  @ApiModelProperty(example = "3182", value = "PostCode for employee home address")
  /**
   * PostCode for employee home address
   *
   * @return postalCode String
   */
  public String getPostalCode() {
    return postalCode;
  }

  /**
   * PostCode for employee home address
   *
   * @param postalCode String
   */
  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }

  /**
   * Country of HomeAddress
   *
   * @param country String
   * @return HomeAddress
   */
  public HomeAddress country(String country) {
    this.country = country;
    return this;
  }

  /**
   * Country of HomeAddress
   *
   * @return country
   */
  @ApiModelProperty(example = "AUSTRALIA", value = "Country of HomeAddress")
  /**
   * Country of HomeAddress
   *
   * @return country String
   */
  public String getCountry() {
    return country;
  }

  /**
   * Country of HomeAddress
   *
   * @param country String
   */
  public void setCountry(String country) {
    this.country = country;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HomeAddress homeAddress = (HomeAddress) o;
    return Objects.equals(this.addressLine1, homeAddress.addressLine1)
        && Objects.equals(this.addressLine2, homeAddress.addressLine2)
        && Objects.equals(this.city, homeAddress.city)
        && Objects.equals(this.region, homeAddress.region)
        && Objects.equals(this.postalCode, homeAddress.postalCode)
        && Objects.equals(this.country, homeAddress.country);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressLine1, addressLine2, city, region, postalCode, country);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HomeAddress {\n");
    sb.append("    addressLine1: ").append(toIndentedString(addressLine1)).append("\n");
    sb.append("    addressLine2: ").append(toIndentedString(addressLine2)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    region: ").append(toIndentedString(region)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
