/*
 * Xero Payroll AU API
 * This is the Xero Payroll API for orgs in Australia region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** LeaveBalance */
public class LeaveBalance {
  StringUtil util = new StringUtil();

  @JsonProperty("LeaveName")
  private String leaveName;

  @JsonProperty("LeaveTypeID")
  private String leaveTypeID;

  @JsonProperty("NumberOfUnits")
  private Double numberOfUnits;

  @JsonProperty("TypeOfUnits")
  private String typeOfUnits;

  /**
   * The name of the leave type
   *
   * @param leaveName String
   * @return LeaveBalance
   */
  public LeaveBalance leaveName(String leaveName) {
    this.leaveName = leaveName;
    return this;
  }

  /**
   * The name of the leave type
   *
   * @return leaveName
   */
  @ApiModelProperty(example = "Annual Leave", value = "The name of the leave type")
  /**
   * The name of the leave type
   *
   * @return leaveName String
   */
  public String getLeaveName() {
    return leaveName;
  }

  /**
   * The name of the leave type
   *
   * @param leaveName String
   */
  public void setLeaveName(String leaveName) {
    this.leaveName = leaveName;
  }

  /**
   * Identifier of the leave type (see PayItems)
   *
   * @param leaveTypeID String
   * @return LeaveBalance
   */
  public LeaveBalance leaveTypeID(String leaveTypeID) {
    this.leaveTypeID = leaveTypeID;
    return this;
  }

  /**
   * Identifier of the leave type (see PayItems)
   *
   * @return leaveTypeID
   */
  @ApiModelProperty(
      example = "544d9292-4329-4512-bfff-a9f15236d776",
      value = "Identifier of the leave type (see PayItems)")
  /**
   * Identifier of the leave type (see PayItems)
   *
   * @return leaveTypeID String
   */
  public String getLeaveTypeID() {
    return leaveTypeID;
  }

  /**
   * Identifier of the leave type (see PayItems)
   *
   * @param leaveTypeID String
   */
  public void setLeaveTypeID(String leaveTypeID) {
    this.leaveTypeID = leaveTypeID;
  }

  /**
   * The balance of the leave available
   *
   * @param numberOfUnits Double
   * @return LeaveBalance
   */
  public LeaveBalance numberOfUnits(Double numberOfUnits) {
    this.numberOfUnits = numberOfUnits;
    return this;
  }

  /**
   * The balance of the leave available
   *
   * @return numberOfUnits
   */
  @ApiModelProperty(example = "81.2602", value = "The balance of the leave available")
  /**
   * The balance of the leave available
   *
   * @return numberOfUnits Double
   */
  public Double getNumberOfUnits() {
    return numberOfUnits;
  }

  /**
   * The balance of the leave available
   *
   * @param numberOfUnits Double
   */
  public void setNumberOfUnits(Double numberOfUnits) {
    this.numberOfUnits = numberOfUnits;
  }

  /**
   * The type of units as specified by the LeaveType (see PayItems)
   *
   * @param typeOfUnits String
   * @return LeaveBalance
   */
  public LeaveBalance typeOfUnits(String typeOfUnits) {
    this.typeOfUnits = typeOfUnits;
    return this;
  }

  /**
   * The type of units as specified by the LeaveType (see PayItems)
   *
   * @return typeOfUnits
   */
  @ApiModelProperty(
      example = "Hours",
      value = "The type of units as specified by the LeaveType (see PayItems)")
  /**
   * The type of units as specified by the LeaveType (see PayItems)
   *
   * @return typeOfUnits String
   */
  public String getTypeOfUnits() {
    return typeOfUnits;
  }

  /**
   * The type of units as specified by the LeaveType (see PayItems)
   *
   * @param typeOfUnits String
   */
  public void setTypeOfUnits(String typeOfUnits) {
    this.typeOfUnits = typeOfUnits;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LeaveBalance leaveBalance = (LeaveBalance) o;
    return Objects.equals(this.leaveName, leaveBalance.leaveName)
        && Objects.equals(this.leaveTypeID, leaveBalance.leaveTypeID)
        && Objects.equals(this.numberOfUnits, leaveBalance.numberOfUnits)
        && Objects.equals(this.typeOfUnits, leaveBalance.typeOfUnits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(leaveName, leaveTypeID, numberOfUnits, typeOfUnits);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LeaveBalance {\n");
    sb.append("    leaveName: ").append(toIndentedString(leaveName)).append("\n");
    sb.append("    leaveTypeID: ").append(toIndentedString(leaveTypeID)).append("\n");
    sb.append("    numberOfUnits: ").append(toIndentedString(numberOfUnits)).append("\n");
    sb.append("    typeOfUnits: ").append(toIndentedString(typeOfUnits)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
