/*
 * Xero Payroll NZ
 * This is the Xero Payroll API for orgs in the NZ region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** Deduction */
public class Deduction {
  StringUtil util = new StringUtil();

  @JsonProperty("deductionId")
  private UUID deductionId;

  @JsonProperty("deductionName")
  private String deductionName;

  /** Deduction Category type */
  public enum DeductionCategoryEnum {
    /** PAYROLLGIVING */
    PAYROLLGIVING("PayrollGiving"),

    /** KIWISAVERVOLUNTARYCONTRIBUTIONS */
    KIWISAVERVOLUNTARYCONTRIBUTIONS("KiwiSaverVoluntaryContributions"),

    /** SUPERANNUATION */
    SUPERANNUATION("Superannuation"),

    /** NZOTHER */
    NZOTHER("NzOther");

    private String value;

    DeductionCategoryEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static DeductionCategoryEnum fromValue(String value) {
      for (DeductionCategoryEnum b : DeductionCategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("deductionCategory")
  private DeductionCategoryEnum deductionCategory;

  @JsonProperty("liabilityAccountId")
  private UUID liabilityAccountId;

  @JsonProperty("currentRecord")
  private Boolean currentRecord;

  @JsonProperty("standardAmount")
  private Double standardAmount;

  /**
   * The Xero identifier for Deduction
   *
   * @param deductionId UUID
   * @return Deduction
   */
  public Deduction deductionId(UUID deductionId) {
    this.deductionId = deductionId;
    return this;
  }

  /**
   * The Xero identifier for Deduction
   *
   * @return deductionId
   */
  @ApiModelProperty(value = "The Xero identifier for Deduction")
  /**
   * The Xero identifier for Deduction
   *
   * @return deductionId UUID
   */
  public UUID getDeductionId() {
    return deductionId;
  }

  /**
   * The Xero identifier for Deduction
   *
   * @param deductionId UUID
   */
  public void setDeductionId(UUID deductionId) {
    this.deductionId = deductionId;
  }

  /**
   * Name of the deduction
   *
   * @param deductionName String
   * @return Deduction
   */
  public Deduction deductionName(String deductionName) {
    this.deductionName = deductionName;
    return this;
  }

  /**
   * Name of the deduction
   *
   * @return deductionName
   */
  @ApiModelProperty(required = true, value = "Name of the deduction")
  /**
   * Name of the deduction
   *
   * @return deductionName String
   */
  public String getDeductionName() {
    return deductionName;
  }

  /**
   * Name of the deduction
   *
   * @param deductionName String
   */
  public void setDeductionName(String deductionName) {
    this.deductionName = deductionName;
  }

  /**
   * Deduction Category type
   *
   * @param deductionCategory DeductionCategoryEnum
   * @return Deduction
   */
  public Deduction deductionCategory(DeductionCategoryEnum deductionCategory) {
    this.deductionCategory = deductionCategory;
    return this;
  }

  /**
   * Deduction Category type
   *
   * @return deductionCategory
   */
  @ApiModelProperty(required = true, value = "Deduction Category type")
  /**
   * Deduction Category type
   *
   * @return deductionCategory DeductionCategoryEnum
   */
  public DeductionCategoryEnum getDeductionCategory() {
    return deductionCategory;
  }

  /**
   * Deduction Category type
   *
   * @param deductionCategory DeductionCategoryEnum
   */
  public void setDeductionCategory(DeductionCategoryEnum deductionCategory) {
    this.deductionCategory = deductionCategory;
  }

  /**
   * Xero identifier for Liability Account
   *
   * @param liabilityAccountId UUID
   * @return Deduction
   */
  public Deduction liabilityAccountId(UUID liabilityAccountId) {
    this.liabilityAccountId = liabilityAccountId;
    return this;
  }

  /**
   * Xero identifier for Liability Account
   *
   * @return liabilityAccountId
   */
  @ApiModelProperty(required = true, value = "Xero identifier for Liability Account")
  /**
   * Xero identifier for Liability Account
   *
   * @return liabilityAccountId UUID
   */
  public UUID getLiabilityAccountId() {
    return liabilityAccountId;
  }

  /**
   * Xero identifier for Liability Account
   *
   * @param liabilityAccountId UUID
   */
  public void setLiabilityAccountId(UUID liabilityAccountId) {
    this.liabilityAccountId = liabilityAccountId;
  }

  /**
   * Identifier of a record is active or not.
   *
   * @param currentRecord Boolean
   * @return Deduction
   */
  public Deduction currentRecord(Boolean currentRecord) {
    this.currentRecord = currentRecord;
    return this;
  }

  /**
   * Identifier of a record is active or not.
   *
   * @return currentRecord
   */
  @ApiModelProperty(value = "Identifier of a record is active or not.")
  /**
   * Identifier of a record is active or not.
   *
   * @return currentRecord Boolean
   */
  public Boolean getCurrentRecord() {
    return currentRecord;
  }

  /**
   * Identifier of a record is active or not.
   *
   * @param currentRecord Boolean
   */
  public void setCurrentRecord(Boolean currentRecord) {
    this.currentRecord = currentRecord;
  }

  /**
   * Standard amount of the deduction.
   *
   * @param standardAmount Double
   * @return Deduction
   */
  public Deduction standardAmount(Double standardAmount) {
    this.standardAmount = standardAmount;
    return this;
  }

  /**
   * Standard amount of the deduction.
   *
   * @return standardAmount
   */
  @ApiModelProperty(value = "Standard amount of the deduction.")
  /**
   * Standard amount of the deduction.
   *
   * @return standardAmount Double
   */
  public Double getStandardAmount() {
    return standardAmount;
  }

  /**
   * Standard amount of the deduction.
   *
   * @param standardAmount Double
   */
  public void setStandardAmount(Double standardAmount) {
    this.standardAmount = standardAmount;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Deduction deduction = (Deduction) o;
    return Objects.equals(this.deductionId, deduction.deductionId)
        && Objects.equals(this.deductionName, deduction.deductionName)
        && Objects.equals(this.deductionCategory, deduction.deductionCategory)
        && Objects.equals(this.liabilityAccountId, deduction.liabilityAccountId)
        && Objects.equals(this.currentRecord, deduction.currentRecord)
        && Objects.equals(this.standardAmount, deduction.standardAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        deductionId,
        deductionName,
        deductionCategory,
        liabilityAccountId,
        currentRecord,
        standardAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Deduction {\n");
    sb.append("    deductionId: ").append(toIndentedString(deductionId)).append("\n");
    sb.append("    deductionName: ").append(toIndentedString(deductionName)).append("\n");
    sb.append("    deductionCategory: ").append(toIndentedString(deductionCategory)).append("\n");
    sb.append("    liabilityAccountId: ").append(toIndentedString(liabilityAccountId)).append("\n");
    sb.append("    currentRecord: ").append(toIndentedString(currentRecord)).append("\n");
    sb.append("    standardAmount: ").append(toIndentedString(standardAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
