/*
 * Xero Payroll NZ
 * This is the Xero Payroll API for orgs in the NZ region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** DeductionLine */
public class DeductionLine {
  StringUtil util = new StringUtil();

  @JsonProperty("deductionTypeID")
  private UUID deductionTypeID;

  @JsonProperty("displayName")
  private String displayName;

  @JsonProperty("amount")
  private Double amount;

  @JsonProperty("subjectToTax")
  private Boolean subjectToTax;

  @JsonProperty("percentage")
  private Double percentage;

  /**
   * Xero identifier for payroll deduction
   *
   * @param deductionTypeID UUID
   * @return DeductionLine
   */
  public DeductionLine deductionTypeID(UUID deductionTypeID) {
    this.deductionTypeID = deductionTypeID;
    return this;
  }

  /**
   * Xero identifier for payroll deduction
   *
   * @return deductionTypeID
   */
  @ApiModelProperty(value = "Xero identifier for payroll deduction")
  /**
   * Xero identifier for payroll deduction
   *
   * @return deductionTypeID UUID
   */
  public UUID getDeductionTypeID() {
    return deductionTypeID;
  }

  /**
   * Xero identifier for payroll deduction
   *
   * @param deductionTypeID UUID
   */
  public void setDeductionTypeID(UUID deductionTypeID) {
    this.deductionTypeID = deductionTypeID;
  }

  /**
   * name of earnings rate for display in UI
   *
   * @param displayName String
   * @return DeductionLine
   */
  public DeductionLine displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * name of earnings rate for display in UI
   *
   * @return displayName
   */
  @ApiModelProperty(value = "name of earnings rate for display in UI")
  /**
   * name of earnings rate for display in UI
   *
   * @return displayName String
   */
  public String getDisplayName() {
    return displayName;
  }

  /**
   * name of earnings rate for display in UI
   *
   * @param displayName String
   */
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  /**
   * The amount of the deduction line
   *
   * @param amount Double
   * @return DeductionLine
   */
  public DeductionLine amount(Double amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The amount of the deduction line
   *
   * @return amount
   */
  @ApiModelProperty(value = "The amount of the deduction line")
  /**
   * The amount of the deduction line
   *
   * @return amount Double
   */
  public Double getAmount() {
    return amount;
  }

  /**
   * The amount of the deduction line
   *
   * @param amount Double
   */
  public void setAmount(Double amount) {
    this.amount = amount;
  }

  /**
   * Identifies if the deduction is subject to tax
   *
   * @param subjectToTax Boolean
   * @return DeductionLine
   */
  public DeductionLine subjectToTax(Boolean subjectToTax) {
    this.subjectToTax = subjectToTax;
    return this;
  }

  /**
   * Identifies if the deduction is subject to tax
   *
   * @return subjectToTax
   */
  @ApiModelProperty(value = "Identifies if the deduction is subject to tax")
  /**
   * Identifies if the deduction is subject to tax
   *
   * @return subjectToTax Boolean
   */
  public Boolean getSubjectToTax() {
    return subjectToTax;
  }

  /**
   * Identifies if the deduction is subject to tax
   *
   * @param subjectToTax Boolean
   */
  public void setSubjectToTax(Boolean subjectToTax) {
    this.subjectToTax = subjectToTax;
  }

  /**
   * Deduction rate percentage
   *
   * @param percentage Double
   * @return DeductionLine
   */
  public DeductionLine percentage(Double percentage) {
    this.percentage = percentage;
    return this;
  }

  /**
   * Deduction rate percentage
   *
   * @return percentage
   */
  @ApiModelProperty(value = "Deduction rate percentage")
  /**
   * Deduction rate percentage
   *
   * @return percentage Double
   */
  public Double getPercentage() {
    return percentage;
  }

  /**
   * Deduction rate percentage
   *
   * @param percentage Double
   */
  public void setPercentage(Double percentage) {
    this.percentage = percentage;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeductionLine deductionLine = (DeductionLine) o;
    return Objects.equals(this.deductionTypeID, deductionLine.deductionTypeID)
        && Objects.equals(this.displayName, deductionLine.displayName)
        && Objects.equals(this.amount, deductionLine.amount)
        && Objects.equals(this.subjectToTax, deductionLine.subjectToTax)
        && Objects.equals(this.percentage, deductionLine.percentage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deductionTypeID, displayName, amount, subjectToTax, percentage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeductionLine {\n");
    sb.append("    deductionTypeID: ").append(toIndentedString(deductionTypeID)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    subjectToTax: ").append(toIndentedString(subjectToTax)).append("\n");
    sb.append("    percentage: ").append(toIndentedString(percentage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
