/*
 * Xero Payroll NZ
 * This is the Xero Payroll API for orgs in the NZ region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** EarningsOrders */
public class EarningsOrders {
  StringUtil util = new StringUtil();

  @JsonProperty("pagination")
  private Pagination pagination;

  @JsonProperty("problem")
  private Problem problem;

  @JsonProperty("statutoryDeductions")
  private List<EarningsOrder> statutoryDeductions = new ArrayList<EarningsOrder>();

  /**
   * pagination
   *
   * @param pagination Pagination
   * @return EarningsOrders
   */
  public EarningsOrders pagination(Pagination pagination) {
    this.pagination = pagination;
    return this;
  }

  /**
   * Get pagination
   *
   * @return pagination
   */
  @ApiModelProperty(value = "")
  /**
   * pagination
   *
   * @return pagination Pagination
   */
  public Pagination getPagination() {
    return pagination;
  }

  /**
   * pagination
   *
   * @param pagination Pagination
   */
  public void setPagination(Pagination pagination) {
    this.pagination = pagination;
  }

  /**
   * problem
   *
   * @param problem Problem
   * @return EarningsOrders
   */
  public EarningsOrders problem(Problem problem) {
    this.problem = problem;
    return this;
  }

  /**
   * Get problem
   *
   * @return problem
   */
  @ApiModelProperty(value = "")
  /**
   * problem
   *
   * @return problem Problem
   */
  public Problem getProblem() {
    return problem;
  }

  /**
   * problem
   *
   * @param problem Problem
   */
  public void setProblem(Problem problem) {
    this.problem = problem;
  }

  /**
   * statutoryDeductions
   *
   * @param statutoryDeductions List&lt;EarningsOrder&gt;
   * @return EarningsOrders
   */
  public EarningsOrders statutoryDeductions(List<EarningsOrder> statutoryDeductions) {
    this.statutoryDeductions = statutoryDeductions;
    return this;
  }

  /**
   * statutoryDeductions
   *
   * @param statutoryDeductionsItem EarningsOrder
   * @return EarningsOrders
   */
  public EarningsOrders addStatutoryDeductionsItem(EarningsOrder statutoryDeductionsItem) {
    if (this.statutoryDeductions == null) {
      this.statutoryDeductions = new ArrayList<EarningsOrder>();
    }
    this.statutoryDeductions.add(statutoryDeductionsItem);
    return this;
  }

  /**
   * Get statutoryDeductions
   *
   * @return statutoryDeductions
   */
  @ApiModelProperty(value = "")
  /**
   * statutoryDeductions
   *
   * @return statutoryDeductions List<EarningsOrder>
   */
  public List<EarningsOrder> getStatutoryDeductions() {
    return statutoryDeductions;
  }

  /**
   * statutoryDeductions
   *
   * @param statutoryDeductions List&lt;EarningsOrder&gt;
   */
  public void setStatutoryDeductions(List<EarningsOrder> statutoryDeductions) {
    this.statutoryDeductions = statutoryDeductions;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EarningsOrders earningsOrders = (EarningsOrders) o;
    return Objects.equals(this.pagination, earningsOrders.pagination)
        && Objects.equals(this.problem, earningsOrders.problem)
        && Objects.equals(this.statutoryDeductions, earningsOrders.statutoryDeductions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pagination, problem, statutoryDeductions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EarningsOrders {\n");
    sb.append("    pagination: ").append(toIndentedString(pagination)).append("\n");
    sb.append("    problem: ").append(toIndentedString(problem)).append("\n");
    sb.append("    statutoryDeductions: ")
        .append(toIndentedString(statutoryDeductions))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
