/*
 * Xero Payroll NZ
 * This is the Xero Payroll API for orgs in the NZ region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.LocalDate;

/** EmployeeWorkingPatternWithWorkingWeeksRequest */
public class EmployeeWorkingPatternWithWorkingWeeksRequest {
  StringUtil util = new StringUtil();

  @JsonProperty("effectiveFrom")
  private LocalDate effectiveFrom;

  @JsonProperty("workingWeeks")
  private List<WorkingWeek> workingWeeks = new ArrayList<WorkingWeek>();

  /**
   * The effective date of the corresponding salary and wages
   *
   * @param effectiveFrom LocalDate
   * @return EmployeeWorkingPatternWithWorkingWeeksRequest
   */
  public EmployeeWorkingPatternWithWorkingWeeksRequest effectiveFrom(LocalDate effectiveFrom) {
    this.effectiveFrom = effectiveFrom;
    return this;
  }

  /**
   * The effective date of the corresponding salary and wages
   *
   * @return effectiveFrom
   */
  @ApiModelProperty(
      required = true,
      value = "The effective date of the corresponding salary and wages")
  /**
   * The effective date of the corresponding salary and wages
   *
   * @return effectiveFrom LocalDate
   */
  public LocalDate getEffectiveFrom() {
    return effectiveFrom;
  }

  /**
   * The effective date of the corresponding salary and wages
   *
   * @param effectiveFrom LocalDate
   */
  public void setEffectiveFrom(LocalDate effectiveFrom) {
    this.effectiveFrom = effectiveFrom;
  }

  /**
   * workingWeeks
   *
   * @param workingWeeks List&lt;WorkingWeek&gt;
   * @return EmployeeWorkingPatternWithWorkingWeeksRequest
   */
  public EmployeeWorkingPatternWithWorkingWeeksRequest workingWeeks(
      List<WorkingWeek> workingWeeks) {
    this.workingWeeks = workingWeeks;
    return this;
  }

  /**
   * workingWeeks
   *
   * @param workingWeeksItem WorkingWeek
   * @return EmployeeWorkingPatternWithWorkingWeeksRequest
   */
  public EmployeeWorkingPatternWithWorkingWeeksRequest addWorkingWeeksItem(
      WorkingWeek workingWeeksItem) {
    this.workingWeeks.add(workingWeeksItem);
    return this;
  }

  /**
   * Get workingWeeks
   *
   * @return workingWeeks
   */
  @ApiModelProperty(required = true, value = "")
  /**
   * workingWeeks
   *
   * @return workingWeeks List<WorkingWeek>
   */
  public List<WorkingWeek> getWorkingWeeks() {
    return workingWeeks;
  }

  /**
   * workingWeeks
   *
   * @param workingWeeks List&lt;WorkingWeek&gt;
   */
  public void setWorkingWeeks(List<WorkingWeek> workingWeeks) {
    this.workingWeeks = workingWeeks;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EmployeeWorkingPatternWithWorkingWeeksRequest employeeWorkingPatternWithWorkingWeeksRequest =
        (EmployeeWorkingPatternWithWorkingWeeksRequest) o;
    return Objects.equals(
            this.effectiveFrom, employeeWorkingPatternWithWorkingWeeksRequest.effectiveFrom)
        && Objects.equals(
            this.workingWeeks, employeeWorkingPatternWithWorkingWeeksRequest.workingWeeks);
  }

  @Override
  public int hashCode() {
    return Objects.hash(effectiveFrom, workingWeeks);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmployeeWorkingPatternWithWorkingWeeksRequest {\n");
    sb.append("    effectiveFrom: ").append(toIndentedString(effectiveFrom)).append("\n");
    sb.append("    workingWeeks: ").append(toIndentedString(workingWeeks)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
