/*
 * Xero Payroll NZ
 * This is the Xero Payroll API for orgs in the NZ region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** LeaveEarningsLine */
public class LeaveEarningsLine {
  StringUtil util = new StringUtil();

  @JsonProperty("earningsLineID")
  private UUID earningsLineID;

  @JsonProperty("earningsRateID")
  private UUID earningsRateID;

  @JsonProperty("displayName")
  private String displayName;

  @JsonProperty("ratePerUnit")
  private Double ratePerUnit;

  @JsonProperty("numberOfUnits")
  private Double numberOfUnits;

  @JsonProperty("fixedAmount")
  private Double fixedAmount;

  @JsonProperty("amount")
  private Double amount;

  @JsonProperty("isLinkedToTimesheet")
  private Boolean isLinkedToTimesheet;

  @JsonProperty("isAverageDailyPayRate")
  private Boolean isAverageDailyPayRate;

  @JsonProperty("isSystemGenerated")
  private Boolean isSystemGenerated;

  /**
   * Xero identifier for payroll earnings line
   *
   * @param earningsLineID UUID
   * @return LeaveEarningsLine
   */
  public LeaveEarningsLine earningsLineID(UUID earningsLineID) {
    this.earningsLineID = earningsLineID;
    return this;
  }

  /**
   * Xero identifier for payroll earnings line
   *
   * @return earningsLineID
   */
  @ApiModelProperty(value = "Xero identifier for payroll earnings line")
  /**
   * Xero identifier for payroll earnings line
   *
   * @return earningsLineID UUID
   */
  public UUID getEarningsLineID() {
    return earningsLineID;
  }

  /**
   * Xero identifier for payroll earnings line
   *
   * @param earningsLineID UUID
   */
  public void setEarningsLineID(UUID earningsLineID) {
    this.earningsLineID = earningsLineID;
  }

  /**
   * Xero identifier for payroll leave earnings rate
   *
   * @param earningsRateID UUID
   * @return LeaveEarningsLine
   */
  public LeaveEarningsLine earningsRateID(UUID earningsRateID) {
    this.earningsRateID = earningsRateID;
    return this;
  }

  /**
   * Xero identifier for payroll leave earnings rate
   *
   * @return earningsRateID
   */
  @ApiModelProperty(value = "Xero identifier for payroll leave earnings rate")
  /**
   * Xero identifier for payroll leave earnings rate
   *
   * @return earningsRateID UUID
   */
  public UUID getEarningsRateID() {
    return earningsRateID;
  }

  /**
   * Xero identifier for payroll leave earnings rate
   *
   * @param earningsRateID UUID
   */
  public void setEarningsRateID(UUID earningsRateID) {
    this.earningsRateID = earningsRateID;
  }

  /**
   * name of earnings rate for display in UI
   *
   * @param displayName String
   * @return LeaveEarningsLine
   */
  public LeaveEarningsLine displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * name of earnings rate for display in UI
   *
   * @return displayName
   */
  @ApiModelProperty(value = "name of earnings rate for display in UI")
  /**
   * name of earnings rate for display in UI
   *
   * @return displayName String
   */
  public String getDisplayName() {
    return displayName;
  }

  /**
   * name of earnings rate for display in UI
   *
   * @param displayName String
   */
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  /**
   * Rate per unit for leave earnings line
   *
   * @param ratePerUnit Double
   * @return LeaveEarningsLine
   */
  public LeaveEarningsLine ratePerUnit(Double ratePerUnit) {
    this.ratePerUnit = ratePerUnit;
    return this;
  }

  /**
   * Rate per unit for leave earnings line
   *
   * @return ratePerUnit
   */
  @ApiModelProperty(value = "Rate per unit for leave earnings line")
  /**
   * Rate per unit for leave earnings line
   *
   * @return ratePerUnit Double
   */
  public Double getRatePerUnit() {
    return ratePerUnit;
  }

  /**
   * Rate per unit for leave earnings line
   *
   * @param ratePerUnit Double
   */
  public void setRatePerUnit(Double ratePerUnit) {
    this.ratePerUnit = ratePerUnit;
  }

  /**
   * Leave earnings number of units
   *
   * @param numberOfUnits Double
   * @return LeaveEarningsLine
   */
  public LeaveEarningsLine numberOfUnits(Double numberOfUnits) {
    this.numberOfUnits = numberOfUnits;
    return this;
  }

  /**
   * Leave earnings number of units
   *
   * @return numberOfUnits
   */
  @ApiModelProperty(value = "Leave earnings number of units")
  /**
   * Leave earnings number of units
   *
   * @return numberOfUnits Double
   */
  public Double getNumberOfUnits() {
    return numberOfUnits;
  }

  /**
   * Leave earnings number of units
   *
   * @param numberOfUnits Double
   */
  public void setNumberOfUnits(Double numberOfUnits) {
    this.numberOfUnits = numberOfUnits;
  }

  /**
   * Leave earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed
   *
   * @param fixedAmount Double
   * @return LeaveEarningsLine
   */
  public LeaveEarningsLine fixedAmount(Double fixedAmount) {
    this.fixedAmount = fixedAmount;
    return this;
  }

  /**
   * Leave earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed
   *
   * @return fixedAmount
   */
  @ApiModelProperty(
      value = "Leave earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed")
  /**
   * Leave earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed
   *
   * @return fixedAmount Double
   */
  public Double getFixedAmount() {
    return fixedAmount;
  }

  /**
   * Leave earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed
   *
   * @param fixedAmount Double
   */
  public void setFixedAmount(Double fixedAmount) {
    this.fixedAmount = fixedAmount;
  }

  /**
   * The amount of the earnings line.
   *
   * @param amount Double
   * @return LeaveEarningsLine
   */
  public LeaveEarningsLine amount(Double amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The amount of the earnings line.
   *
   * @return amount
   */
  @ApiModelProperty(value = "The amount of the earnings line.")
  /**
   * The amount of the earnings line.
   *
   * @return amount Double
   */
  public Double getAmount() {
    return amount;
  }

  /**
   * The amount of the earnings line.
   *
   * @param amount Double
   */
  public void setAmount(Double amount) {
    this.amount = amount;
  }

  /**
   * Identifies if the leave earnings is taken from the timesheet. False for leave earnings line
   *
   * @param isLinkedToTimesheet Boolean
   * @return LeaveEarningsLine
   */
  public LeaveEarningsLine isLinkedToTimesheet(Boolean isLinkedToTimesheet) {
    this.isLinkedToTimesheet = isLinkedToTimesheet;
    return this;
  }

  /**
   * Identifies if the leave earnings is taken from the timesheet. False for leave earnings line
   *
   * @return isLinkedToTimesheet
   */
  @ApiModelProperty(
      value =
          "Identifies if the leave earnings is taken from the timesheet. False for leave earnings"
              + " line")
  /**
   * Identifies if the leave earnings is taken from the timesheet. False for leave earnings line
   *
   * @return isLinkedToTimesheet Boolean
   */
  public Boolean getIsLinkedToTimesheet() {
    return isLinkedToTimesheet;
  }

  /**
   * Identifies if the leave earnings is taken from the timesheet. False for leave earnings line
   *
   * @param isLinkedToTimesheet Boolean
   */
  public void setIsLinkedToTimesheet(Boolean isLinkedToTimesheet) {
    this.isLinkedToTimesheet = isLinkedToTimesheet;
  }

  /**
   * Identifies if the earnings is using an average daily pay rate
   *
   * @param isAverageDailyPayRate Boolean
   * @return LeaveEarningsLine
   */
  public LeaveEarningsLine isAverageDailyPayRate(Boolean isAverageDailyPayRate) {
    this.isAverageDailyPayRate = isAverageDailyPayRate;
    return this;
  }

  /**
   * Identifies if the earnings is using an average daily pay rate
   *
   * @return isAverageDailyPayRate
   */
  @ApiModelProperty(value = "Identifies if the earnings is using an average daily pay rate")
  /**
   * Identifies if the earnings is using an average daily pay rate
   *
   * @return isAverageDailyPayRate Boolean
   */
  public Boolean getIsAverageDailyPayRate() {
    return isAverageDailyPayRate;
  }

  /**
   * Identifies if the earnings is using an average daily pay rate
   *
   * @param isAverageDailyPayRate Boolean
   */
  public void setIsAverageDailyPayRate(Boolean isAverageDailyPayRate) {
    this.isAverageDailyPayRate = isAverageDailyPayRate;
  }

  /**
   * Flag to identify whether the earnings line is system generated or not.
   *
   * @param isSystemGenerated Boolean
   * @return LeaveEarningsLine
   */
  public LeaveEarningsLine isSystemGenerated(Boolean isSystemGenerated) {
    this.isSystemGenerated = isSystemGenerated;
    return this;
  }

  /**
   * Flag to identify whether the earnings line is system generated or not.
   *
   * @return isSystemGenerated
   */
  @ApiModelProperty(
      value = "Flag to identify whether the earnings line is system generated or not.")
  /**
   * Flag to identify whether the earnings line is system generated or not.
   *
   * @return isSystemGenerated Boolean
   */
  public Boolean getIsSystemGenerated() {
    return isSystemGenerated;
  }

  /**
   * Flag to identify whether the earnings line is system generated or not.
   *
   * @param isSystemGenerated Boolean
   */
  public void setIsSystemGenerated(Boolean isSystemGenerated) {
    this.isSystemGenerated = isSystemGenerated;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LeaveEarningsLine leaveEarningsLine = (LeaveEarningsLine) o;
    return Objects.equals(this.earningsLineID, leaveEarningsLine.earningsLineID)
        && Objects.equals(this.earningsRateID, leaveEarningsLine.earningsRateID)
        && Objects.equals(this.displayName, leaveEarningsLine.displayName)
        && Objects.equals(this.ratePerUnit, leaveEarningsLine.ratePerUnit)
        && Objects.equals(this.numberOfUnits, leaveEarningsLine.numberOfUnits)
        && Objects.equals(this.fixedAmount, leaveEarningsLine.fixedAmount)
        && Objects.equals(this.amount, leaveEarningsLine.amount)
        && Objects.equals(this.isLinkedToTimesheet, leaveEarningsLine.isLinkedToTimesheet)
        && Objects.equals(this.isAverageDailyPayRate, leaveEarningsLine.isAverageDailyPayRate)
        && Objects.equals(this.isSystemGenerated, leaveEarningsLine.isSystemGenerated);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        earningsLineID,
        earningsRateID,
        displayName,
        ratePerUnit,
        numberOfUnits,
        fixedAmount,
        amount,
        isLinkedToTimesheet,
        isAverageDailyPayRate,
        isSystemGenerated);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LeaveEarningsLine {\n");
    sb.append("    earningsLineID: ").append(toIndentedString(earningsLineID)).append("\n");
    sb.append("    earningsRateID: ").append(toIndentedString(earningsRateID)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    ratePerUnit: ").append(toIndentedString(ratePerUnit)).append("\n");
    sb.append("    numberOfUnits: ").append(toIndentedString(numberOfUnits)).append("\n");
    sb.append("    fixedAmount: ").append(toIndentedString(fixedAmount)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    isLinkedToTimesheet: ")
        .append(toIndentedString(isLinkedToTimesheet))
        .append("\n");
    sb.append("    isAverageDailyPayRate: ")
        .append(toIndentedString(isAverageDailyPayRate))
        .append("\n");
    sb.append("    isSystemGenerated: ").append(toIndentedString(isSystemGenerated)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
