/*
 * Xero Payroll NZ
 * This is the Xero Payroll API for orgs in the NZ region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;

/** Timesheet */
public class Timesheet {
  StringUtil util = new StringUtil();

  @JsonProperty("timesheetID")
  private UUID timesheetID;

  @JsonProperty("payrollCalendarID")
  private UUID payrollCalendarID;

  @JsonProperty("employeeID")
  private UUID employeeID;

  @JsonProperty("startDate")
  private LocalDate startDate;

  @JsonProperty("endDate")
  private LocalDate endDate;

  /** Status of the timesheet */
  public enum StatusEnum {
    /** DRAFT */
    DRAFT("Draft"),

    /** APPROVED */
    APPROVED("Approved"),

    /** COMPLETED */
    COMPLETED("Completed"),

    /** REQUESTED */
    REQUESTED("Requested");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("totalHours")
  private Double totalHours;

  @JsonProperty("updatedDateUTC")
  private LocalDateTime updatedDateUTC;

  @JsonProperty("timesheetLines")
  private List<TimesheetLine> timesheetLines = new ArrayList<TimesheetLine>();

  /**
   * The Xero identifier for a Timesheet
   *
   * @param timesheetID UUID
   * @return Timesheet
   */
  public Timesheet timesheetID(UUID timesheetID) {
    this.timesheetID = timesheetID;
    return this;
  }

  /**
   * The Xero identifier for a Timesheet
   *
   * @return timesheetID
   */
  @ApiModelProperty(value = "The Xero identifier for a Timesheet")
  /**
   * The Xero identifier for a Timesheet
   *
   * @return timesheetID UUID
   */
  public UUID getTimesheetID() {
    return timesheetID;
  }

  /**
   * The Xero identifier for a Timesheet
   *
   * @param timesheetID UUID
   */
  public void setTimesheetID(UUID timesheetID) {
    this.timesheetID = timesheetID;
  }

  /**
   * The Xero identifier for the Payroll Calendar that the Timesheet applies to
   *
   * @param payrollCalendarID UUID
   * @return Timesheet
   */
  public Timesheet payrollCalendarID(UUID payrollCalendarID) {
    this.payrollCalendarID = payrollCalendarID;
    return this;
  }

  /**
   * The Xero identifier for the Payroll Calendar that the Timesheet applies to
   *
   * @return payrollCalendarID
   */
  @ApiModelProperty(
      required = true,
      value = "The Xero identifier for the Payroll Calendar that the Timesheet applies to")
  /**
   * The Xero identifier for the Payroll Calendar that the Timesheet applies to
   *
   * @return payrollCalendarID UUID
   */
  public UUID getPayrollCalendarID() {
    return payrollCalendarID;
  }

  /**
   * The Xero identifier for the Payroll Calendar that the Timesheet applies to
   *
   * @param payrollCalendarID UUID
   */
  public void setPayrollCalendarID(UUID payrollCalendarID) {
    this.payrollCalendarID = payrollCalendarID;
  }

  /**
   * The Xero identifier for the Employee that the Timesheet is for
   *
   * @param employeeID UUID
   * @return Timesheet
   */
  public Timesheet employeeID(UUID employeeID) {
    this.employeeID = employeeID;
    return this;
  }

  /**
   * The Xero identifier for the Employee that the Timesheet is for
   *
   * @return employeeID
   */
  @ApiModelProperty(
      required = true,
      value = "The Xero identifier for the Employee that the Timesheet is for")
  /**
   * The Xero identifier for the Employee that the Timesheet is for
   *
   * @return employeeID UUID
   */
  public UUID getEmployeeID() {
    return employeeID;
  }

  /**
   * The Xero identifier for the Employee that the Timesheet is for
   *
   * @param employeeID UUID
   */
  public void setEmployeeID(UUID employeeID) {
    this.employeeID = employeeID;
  }

  /**
   * The Start Date of the Timesheet period (YYYY-MM-DD)
   *
   * @param startDate LocalDate
   * @return Timesheet
   */
  public Timesheet startDate(LocalDate startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * The Start Date of the Timesheet period (YYYY-MM-DD)
   *
   * @return startDate
   */
  @ApiModelProperty(required = true, value = "The Start Date of the Timesheet period (YYYY-MM-DD)")
  /**
   * The Start Date of the Timesheet period (YYYY-MM-DD)
   *
   * @return startDate LocalDate
   */
  public LocalDate getStartDate() {
    return startDate;
  }

  /**
   * The Start Date of the Timesheet period (YYYY-MM-DD)
   *
   * @param startDate LocalDate
   */
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  /**
   * The End Date of the Timesheet period (YYYY-MM-DD)
   *
   * @param endDate LocalDate
   * @return Timesheet
   */
  public Timesheet endDate(LocalDate endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * The End Date of the Timesheet period (YYYY-MM-DD)
   *
   * @return endDate
   */
  @ApiModelProperty(required = true, value = "The End Date of the Timesheet period (YYYY-MM-DD)")
  /**
   * The End Date of the Timesheet period (YYYY-MM-DD)
   *
   * @return endDate LocalDate
   */
  public LocalDate getEndDate() {
    return endDate;
  }

  /**
   * The End Date of the Timesheet period (YYYY-MM-DD)
   *
   * @param endDate LocalDate
   */
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }

  /**
   * Status of the timesheet
   *
   * @param status StatusEnum
   * @return Timesheet
   */
  public Timesheet status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Status of the timesheet
   *
   * @return status
   */
  @ApiModelProperty(value = "Status of the timesheet")
  /**
   * Status of the timesheet
   *
   * @return status StatusEnum
   */
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * Status of the timesheet
   *
   * @param status StatusEnum
   */
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * The Total Hours of the Timesheet
   *
   * @param totalHours Double
   * @return Timesheet
   */
  public Timesheet totalHours(Double totalHours) {
    this.totalHours = totalHours;
    return this;
  }

  /**
   * The Total Hours of the Timesheet
   *
   * @return totalHours
   */
  @ApiModelProperty(value = "The Total Hours of the Timesheet")
  /**
   * The Total Hours of the Timesheet
   *
   * @return totalHours Double
   */
  public Double getTotalHours() {
    return totalHours;
  }

  /**
   * The Total Hours of the Timesheet
   *
   * @param totalHours Double
   */
  public void setTotalHours(Double totalHours) {
    this.totalHours = totalHours;
  }

  /**
   * The UTC date time that the Timesheet was last updated
   *
   * @param updatedDateUTC LocalDateTime
   * @return Timesheet
   */
  public Timesheet updatedDateUTC(LocalDateTime updatedDateUTC) {
    this.updatedDateUTC = updatedDateUTC;
    return this;
  }

  /**
   * The UTC date time that the Timesheet was last updated
   *
   * @return updatedDateUTC
   */
  @ApiModelProperty(value = "The UTC date time that the Timesheet was last updated")
  /**
   * The UTC date time that the Timesheet was last updated
   *
   * @return updatedDateUTC LocalDateTime
   */
  public LocalDateTime getUpdatedDateUTC() {
    return updatedDateUTC;
  }

  /**
   * The UTC date time that the Timesheet was last updated
   *
   * @param updatedDateUTC LocalDateTime
   */
  public void setUpdatedDateUTC(LocalDateTime updatedDateUTC) {
    this.updatedDateUTC = updatedDateUTC;
  }

  /**
   * timesheetLines
   *
   * @param timesheetLines List&lt;TimesheetLine&gt;
   * @return Timesheet
   */
  public Timesheet timesheetLines(List<TimesheetLine> timesheetLines) {
    this.timesheetLines = timesheetLines;
    return this;
  }

  /**
   * timesheetLines
   *
   * @param timesheetLinesItem TimesheetLine
   * @return Timesheet
   */
  public Timesheet addTimesheetLinesItem(TimesheetLine timesheetLinesItem) {
    if (this.timesheetLines == null) {
      this.timesheetLines = new ArrayList<TimesheetLine>();
    }
    this.timesheetLines.add(timesheetLinesItem);
    return this;
  }

  /**
   * Get timesheetLines
   *
   * @return timesheetLines
   */
  @ApiModelProperty(value = "")
  /**
   * timesheetLines
   *
   * @return timesheetLines List<TimesheetLine>
   */
  public List<TimesheetLine> getTimesheetLines() {
    return timesheetLines;
  }

  /**
   * timesheetLines
   *
   * @param timesheetLines List&lt;TimesheetLine&gt;
   */
  public void setTimesheetLines(List<TimesheetLine> timesheetLines) {
    this.timesheetLines = timesheetLines;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Timesheet timesheet = (Timesheet) o;
    return Objects.equals(this.timesheetID, timesheet.timesheetID)
        && Objects.equals(this.payrollCalendarID, timesheet.payrollCalendarID)
        && Objects.equals(this.employeeID, timesheet.employeeID)
        && Objects.equals(this.startDate, timesheet.startDate)
        && Objects.equals(this.endDate, timesheet.endDate)
        && Objects.equals(this.status, timesheet.status)
        && Objects.equals(this.totalHours, timesheet.totalHours)
        && Objects.equals(this.updatedDateUTC, timesheet.updatedDateUTC)
        && Objects.equals(this.timesheetLines, timesheet.timesheetLines);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        timesheetID,
        payrollCalendarID,
        employeeID,
        startDate,
        endDate,
        status,
        totalHours,
        updatedDateUTC,
        timesheetLines);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Timesheet {\n");
    sb.append("    timesheetID: ").append(toIndentedString(timesheetID)).append("\n");
    sb.append("    payrollCalendarID: ").append(toIndentedString(payrollCalendarID)).append("\n");
    sb.append("    employeeID: ").append(toIndentedString(employeeID)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    totalHours: ").append(toIndentedString(totalHours)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    timesheetLines: ").append(toIndentedString(timesheetLines)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
