/*
 * Xero Payroll UK
 * This is the Xero Payroll API for orgs in the UK region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

/** EmployeeStatutoryLeaveSummary */
public class EmployeeStatutoryLeaveSummary {
  StringUtil util = new StringUtil();

  @JsonProperty("statutoryLeaveID")
  private UUID statutoryLeaveID;

  @JsonProperty("employeeID")
  private UUID employeeID;

  /** The category of statutory leave */
  public enum TypeEnum {
    /** SICK */
    SICK("Sick"),

    /** ADOPTION */
    ADOPTION("Adoption"),

    /** MATERNITY */
    MATERNITY("Maternity"),

    /** PATERNITY */
    PATERNITY("Paternity"),

    /** SHAREDPARENTAL */
    SHAREDPARENTAL("Sharedparental"),

    /** BEREAVEMENT */
    BEREAVEMENT("Bereavement"),

    /** NEONATALCARE */
    NEONATALCARE("NeonatalCare");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  @JsonProperty("startDate")
  private LocalDate startDate;

  @JsonProperty("endDate")
  private LocalDate endDate;

  @JsonProperty("isEntitled")
  private Boolean isEntitled;

  /** The status of the leave */
  public enum StatusEnum {
    /** PENDING */
    PENDING("Pending"),

    /** IN_PROGRESS */
    IN_PROGRESS("In-Progress"),

    /** COMPLETED */
    COMPLETED("Completed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  /**
   * The unique identifier (guid) of a statutory leave.
   *
   * @param statutoryLeaveID UUID
   * @return EmployeeStatutoryLeaveSummary
   */
  public EmployeeStatutoryLeaveSummary statutoryLeaveID(UUID statutoryLeaveID) {
    this.statutoryLeaveID = statutoryLeaveID;
    return this;
  }

  /**
   * The unique identifier (guid) of a statutory leave.
   *
   * @return statutoryLeaveID
   */
  @ApiModelProperty(value = "The unique identifier (guid) of a statutory leave.")
  /**
   * The unique identifier (guid) of a statutory leave.
   *
   * @return statutoryLeaveID UUID
   */
  public UUID getStatutoryLeaveID() {
    return statutoryLeaveID;
  }

  /**
   * The unique identifier (guid) of a statutory leave.
   *
   * @param statutoryLeaveID UUID
   */
  public void setStatutoryLeaveID(UUID statutoryLeaveID) {
    this.statutoryLeaveID = statutoryLeaveID;
  }

  /**
   * The unique identifier (guid) of the employee
   *
   * @param employeeID UUID
   * @return EmployeeStatutoryLeaveSummary
   */
  public EmployeeStatutoryLeaveSummary employeeID(UUID employeeID) {
    this.employeeID = employeeID;
    return this;
  }

  /**
   * The unique identifier (guid) of the employee
   *
   * @return employeeID
   */
  @ApiModelProperty(value = "The unique identifier (guid) of the employee")
  /**
   * The unique identifier (guid) of the employee
   *
   * @return employeeID UUID
   */
  public UUID getEmployeeID() {
    return employeeID;
  }

  /**
   * The unique identifier (guid) of the employee
   *
   * @param employeeID UUID
   */
  public void setEmployeeID(UUID employeeID) {
    this.employeeID = employeeID;
  }

  /**
   * The category of statutory leave
   *
   * @param type TypeEnum
   * @return EmployeeStatutoryLeaveSummary
   */
  public EmployeeStatutoryLeaveSummary type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The category of statutory leave
   *
   * @return type
   */
  @ApiModelProperty(value = "The category of statutory leave")
  /**
   * The category of statutory leave
   *
   * @return type TypeEnum
   */
  public TypeEnum getType() {
    return type;
  }

  /**
   * The category of statutory leave
   *
   * @param type TypeEnum
   */
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * The date when the leave starts
   *
   * @param startDate LocalDate
   * @return EmployeeStatutoryLeaveSummary
   */
  public EmployeeStatutoryLeaveSummary startDate(LocalDate startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * The date when the leave starts
   *
   * @return startDate
   */
  @ApiModelProperty(value = "The date when the leave starts")
  /**
   * The date when the leave starts
   *
   * @return startDate LocalDate
   */
  public LocalDate getStartDate() {
    return startDate;
  }

  /**
   * The date when the leave starts
   *
   * @param startDate LocalDate
   */
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  /**
   * The date when the leave ends
   *
   * @param endDate LocalDate
   * @return EmployeeStatutoryLeaveSummary
   */
  public EmployeeStatutoryLeaveSummary endDate(LocalDate endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * The date when the leave ends
   *
   * @return endDate
   */
  @ApiModelProperty(value = "The date when the leave ends")
  /**
   * The date when the leave ends
   *
   * @return endDate LocalDate
   */
  public LocalDate getEndDate() {
    return endDate;
  }

  /**
   * The date when the leave ends
   *
   * @param endDate LocalDate
   */
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }

  /**
   * Whether the leave was entitled to receive payment
   *
   * @param isEntitled Boolean
   * @return EmployeeStatutoryLeaveSummary
   */
  public EmployeeStatutoryLeaveSummary isEntitled(Boolean isEntitled) {
    this.isEntitled = isEntitled;
    return this;
  }

  /**
   * Whether the leave was entitled to receive payment
   *
   * @return isEntitled
   */
  @ApiModelProperty(value = "Whether the leave was entitled to receive payment")
  /**
   * Whether the leave was entitled to receive payment
   *
   * @return isEntitled Boolean
   */
  public Boolean getIsEntitled() {
    return isEntitled;
  }

  /**
   * Whether the leave was entitled to receive payment
   *
   * @param isEntitled Boolean
   */
  public void setIsEntitled(Boolean isEntitled) {
    this.isEntitled = isEntitled;
  }

  /**
   * The status of the leave
   *
   * @param status StatusEnum
   * @return EmployeeStatutoryLeaveSummary
   */
  public EmployeeStatutoryLeaveSummary status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the leave
   *
   * @return status
   */
  @ApiModelProperty(value = "The status of the leave")
  /**
   * The status of the leave
   *
   * @return status StatusEnum
   */
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The status of the leave
   *
   * @param status StatusEnum
   */
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EmployeeStatutoryLeaveSummary employeeStatutoryLeaveSummary = (EmployeeStatutoryLeaveSummary) o;
    return Objects.equals(this.statutoryLeaveID, employeeStatutoryLeaveSummary.statutoryLeaveID)
        && Objects.equals(this.employeeID, employeeStatutoryLeaveSummary.employeeID)
        && Objects.equals(this.type, employeeStatutoryLeaveSummary.type)
        && Objects.equals(this.startDate, employeeStatutoryLeaveSummary.startDate)
        && Objects.equals(this.endDate, employeeStatutoryLeaveSummary.endDate)
        && Objects.equals(this.isEntitled, employeeStatutoryLeaveSummary.isEntitled)
        && Objects.equals(this.status, employeeStatutoryLeaveSummary.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(statutoryLeaveID, employeeID, type, startDate, endDate, isEntitled, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmployeeStatutoryLeaveSummary {\n");
    sb.append("    statutoryLeaveID: ").append(toIndentedString(statutoryLeaveID)).append("\n");
    sb.append("    employeeID: ").append(toIndentedString(employeeID)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    isEntitled: ").append(toIndentedString(isEntitled)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
