/*
 * Xero Payroll UK
 * This is the Xero Payroll API for orgs in the UK region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

/** Employment */
public class Employment {
  StringUtil util = new StringUtil();

  @JsonProperty("payrollCalendarID")
  private UUID payrollCalendarID;

  @JsonProperty("startDate")
  private LocalDate startDate;

  @JsonProperty("employeeNumber")
  private String employeeNumber;

  @JsonProperty("niCategory")
  private NICategoryLetter niCategory;

  @JsonProperty("niCategories")
  private List<NICategory> niCategories = new ArrayList<NICategory>();

  /**
   * Xero unique identifier for the payroll calendar of the employee
   *
   * @param payrollCalendarID UUID
   * @return Employment
   */
  public Employment payrollCalendarID(UUID payrollCalendarID) {
    this.payrollCalendarID = payrollCalendarID;
    return this;
  }

  /**
   * Xero unique identifier for the payroll calendar of the employee
   *
   * @return payrollCalendarID
   */
  @ApiModelProperty(
      required = true,
      value = "Xero unique identifier for the payroll calendar of the employee")
  /**
   * Xero unique identifier for the payroll calendar of the employee
   *
   * @return payrollCalendarID UUID
   */
  public UUID getPayrollCalendarID() {
    return payrollCalendarID;
  }

  /**
   * Xero unique identifier for the payroll calendar of the employee
   *
   * @param payrollCalendarID UUID
   */
  public void setPayrollCalendarID(UUID payrollCalendarID) {
    this.payrollCalendarID = payrollCalendarID;
  }

  /**
   * Start date of the employment (YYYY-MM-DD)
   *
   * @param startDate LocalDate
   * @return Employment
   */
  public Employment startDate(LocalDate startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Start date of the employment (YYYY-MM-DD)
   *
   * @return startDate
   */
  @ApiModelProperty(required = true, value = "Start date of the employment (YYYY-MM-DD)")
  /**
   * Start date of the employment (YYYY-MM-DD)
   *
   * @return startDate LocalDate
   */
  public LocalDate getStartDate() {
    return startDate;
  }

  /**
   * Start date of the employment (YYYY-MM-DD)
   *
   * @param startDate LocalDate
   */
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  /**
   * The employment number of the employee
   *
   * @param employeeNumber String
   * @return Employment
   */
  public Employment employeeNumber(String employeeNumber) {
    this.employeeNumber = employeeNumber;
    return this;
  }

  /**
   * The employment number of the employee
   *
   * @return employeeNumber
   */
  @ApiModelProperty(example = "7", required = true, value = "The employment number of the employee")
  /**
   * The employment number of the employee
   *
   * @return employeeNumber String
   */
  public String getEmployeeNumber() {
    return employeeNumber;
  }

  /**
   * The employment number of the employee
   *
   * @param employeeNumber String
   */
  public void setEmployeeNumber(String employeeNumber) {
    this.employeeNumber = employeeNumber;
  }

  /**
   * niCategory
   *
   * @param niCategory NICategoryLetter
   * @return Employment
   */
  public Employment niCategory(NICategoryLetter niCategory) {
    this.niCategory = niCategory;
    return this;
  }

  /**
   * Get niCategory
   *
   * @return niCategory
   */
  @ApiModelProperty(value = "")
  /**
   * niCategory
   *
   * @return niCategory NICategoryLetter
   */
  public NICategoryLetter getNiCategory() {
    return niCategory;
  }

  /**
   * niCategory
   *
   * @param niCategory NICategoryLetter
   */
  public void setNiCategory(NICategoryLetter niCategory) {
    this.niCategory = niCategory;
  }

  /**
   * The employee&#39;s NI categories
   *
   * @param niCategories List&lt;NICategory&gt;
   * @return Employment
   */
  public Employment niCategories(List<NICategory> niCategories) {
    this.niCategories = niCategories;
    return this;
  }

  /**
   * The employee&#39;s NI categories
   *
   * @param niCategoriesItem NICategory
   * @return Employment
   */
  public Employment addNiCategoriesItem(NICategory niCategoriesItem) {
    this.niCategories.add(niCategoriesItem);
    return this;
  }

  /**
   * The employee&#39;s NI categories
   *
   * @return niCategories
   */
  @ApiModelProperty(required = true, value = "The employee's NI categories")
  /**
   * The employee&#39;s NI categories
   *
   * @return niCategories List<NICategory>
   */
  public List<NICategory> getNiCategories() {
    return niCategories;
  }

  /**
   * The employee&#39;s NI categories
   *
   * @param niCategories List&lt;NICategory&gt;
   */
  public void setNiCategories(List<NICategory> niCategories) {
    this.niCategories = niCategories;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Employment employment = (Employment) o;
    return Objects.equals(this.payrollCalendarID, employment.payrollCalendarID)
        && Objects.equals(this.startDate, employment.startDate)
        && Objects.equals(this.employeeNumber, employment.employeeNumber)
        && Objects.equals(this.niCategory, employment.niCategory)
        && Objects.equals(this.niCategories, employment.niCategories);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payrollCalendarID, startDate, employeeNumber, niCategory, niCategories);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Employment {\n");
    sb.append("    payrollCalendarID: ").append(toIndentedString(payrollCalendarID)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    employeeNumber: ").append(toIndentedString(employeeNumber)).append("\n");
    sb.append("    niCategory: ").append(toIndentedString(niCategory)).append("\n");
    sb.append("    niCategories: ").append(toIndentedString(niCategories)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
