/*
 * Xero Payroll UK
 * This is the Xero Payroll API for orgs in the UK region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import org.threeten.bp.LocalDate;

/** NICategory */
public class NICategory {
  StringUtil util = new StringUtil();

  @JsonProperty("startDate")
  private LocalDate startDate;

  @JsonProperty("niCategory")
  private NICategoryLetter niCategory;

  @JsonProperty("niCategoryID")
  private BigDecimal niCategoryID;

  @JsonProperty("dateFirstEmployedAsCivilian")
  private LocalDate dateFirstEmployedAsCivilian;

  @JsonProperty("workplacePostcode")
  private String workplacePostcode;

  /**
   * The start date of the NI category (YYYY-MM-DD)
   *
   * @param startDate LocalDate
   * @return NICategory
   */
  public NICategory startDate(LocalDate startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * The start date of the NI category (YYYY-MM-DD)
   *
   * @return startDate
   */
  @ApiModelProperty(
      example = "Mon Dec 02 00:00:00 UTC 2024",
      value = "The start date of the NI category (YYYY-MM-DD)")
  /**
   * The start date of the NI category (YYYY-MM-DD)
   *
   * @return startDate LocalDate
   */
  public LocalDate getStartDate() {
    return startDate;
  }

  /**
   * The start date of the NI category (YYYY-MM-DD)
   *
   * @param startDate LocalDate
   */
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  /**
   * niCategory
   *
   * @param niCategory NICategoryLetter
   * @return NICategory
   */
  public NICategory niCategory(NICategoryLetter niCategory) {
    this.niCategory = niCategory;
    return this;
  }

  /**
   * Get niCategory
   *
   * @return niCategory
   */
  @ApiModelProperty(required = true, value = "")
  /**
   * niCategory
   *
   * @return niCategory NICategoryLetter
   */
  public NICategoryLetter getNiCategory() {
    return niCategory;
  }

  /**
   * niCategory
   *
   * @param niCategory NICategoryLetter
   */
  public void setNiCategory(NICategoryLetter niCategory) {
    this.niCategory = niCategory;
  }

  /**
   * Xero unique identifier for the NI category
   *
   * @param niCategoryID BigDecimal
   * @return NICategory
   */
  public NICategory niCategoryID(BigDecimal niCategoryID) {
    this.niCategoryID = niCategoryID;
    return this;
  }

  /**
   * Xero unique identifier for the NI category
   *
   * @return niCategoryID
   */
  @ApiModelProperty(example = "15", value = "Xero unique identifier for the NI category")
  /**
   * Xero unique identifier for the NI category
   *
   * @return niCategoryID BigDecimal
   */
  public BigDecimal getNiCategoryID() {
    return niCategoryID;
  }

  /**
   * Xero unique identifier for the NI category
   *
   * @param niCategoryID BigDecimal
   */
  public void setNiCategoryID(BigDecimal niCategoryID) {
    this.niCategoryID = niCategoryID;
  }

  /**
   * The date in which the employee was first employed as a civilian (YYYY-MM-DD)
   *
   * @param dateFirstEmployedAsCivilian LocalDate
   * @return NICategory
   */
  public NICategory dateFirstEmployedAsCivilian(LocalDate dateFirstEmployedAsCivilian) {
    this.dateFirstEmployedAsCivilian = dateFirstEmployedAsCivilian;
    return this;
  }

  /**
   * The date in which the employee was first employed as a civilian (YYYY-MM-DD)
   *
   * @return dateFirstEmployedAsCivilian
   */
  @ApiModelProperty(
      example = "Mon Dec 02 00:00:00 UTC 2024",
      value = "The date in which the employee was first employed as a civilian (YYYY-MM-DD)")
  /**
   * The date in which the employee was first employed as a civilian (YYYY-MM-DD)
   *
   * @return dateFirstEmployedAsCivilian LocalDate
   */
  public LocalDate getDateFirstEmployedAsCivilian() {
    return dateFirstEmployedAsCivilian;
  }

  /**
   * The date in which the employee was first employed as a civilian (YYYY-MM-DD)
   *
   * @param dateFirstEmployedAsCivilian LocalDate
   */
  public void setDateFirstEmployedAsCivilian(LocalDate dateFirstEmployedAsCivilian) {
    this.dateFirstEmployedAsCivilian = dateFirstEmployedAsCivilian;
  }

  /**
   * The workplace postcode
   *
   * @param workplacePostcode String
   * @return NICategory
   */
  public NICategory workplacePostcode(String workplacePostcode) {
    this.workplacePostcode = workplacePostcode;
    return this;
  }

  /**
   * The workplace postcode
   *
   * @return workplacePostcode
   */
  @ApiModelProperty(example = "SW1A 1AA", required = true, value = "The workplace postcode")
  /**
   * The workplace postcode
   *
   * @return workplacePostcode String
   */
  public String getWorkplacePostcode() {
    return workplacePostcode;
  }

  /**
   * The workplace postcode
   *
   * @param workplacePostcode String
   */
  public void setWorkplacePostcode(String workplacePostcode) {
    this.workplacePostcode = workplacePostcode;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NICategory niCategory = (NICategory) o;
    return Objects.equals(this.startDate, niCategory.startDate)
        && Objects.equals(this.niCategory, niCategory.niCategory)
        && Objects.equals(this.niCategoryID, niCategory.niCategoryID)
        && Objects.equals(this.dateFirstEmployedAsCivilian, niCategory.dateFirstEmployedAsCivilian)
        && Objects.equals(this.workplacePostcode, niCategory.workplacePostcode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        startDate, niCategory, niCategoryID, dateFirstEmployedAsCivilian, workplacePostcode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NICategory {\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    niCategory: ").append(toIndentedString(niCategory)).append("\n");
    sb.append("    niCategoryID: ").append(toIndentedString(niCategoryID)).append("\n");
    sb.append("    dateFirstEmployedAsCivilian: ")
        .append(toIndentedString(dateFirstEmployedAsCivilian))
        .append("\n");
    sb.append("    workplacePostcode: ").append(toIndentedString(workplacePostcode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
