/*
 * Xero Payroll UK
 * This is the Xero Payroll API for orgs in the UK region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** PaymentMethod */
public class PaymentMethod {
  StringUtil util = new StringUtil();

  /** The payment method code */
  public enum PaymentMethodEnum {
    /** CHEQUE */
    CHEQUE("Cheque"),

    /** ELECTRONICALLY */
    ELECTRONICALLY("Electronically"),

    /** MANUAL */
    MANUAL("Manual");

    private String value;

    PaymentMethodEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static PaymentMethodEnum fromValue(String value) {
      for (PaymentMethodEnum b : PaymentMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("paymentMethod")
  private PaymentMethodEnum paymentMethod;

  @JsonProperty("bankAccounts")
  private List<BankAccount> bankAccounts = new ArrayList<BankAccount>();

  /**
   * The payment method code
   *
   * @param paymentMethod PaymentMethodEnum
   * @return PaymentMethod
   */
  public PaymentMethod paymentMethod(PaymentMethodEnum paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

  /**
   * The payment method code
   *
   * @return paymentMethod
   */
  @ApiModelProperty(required = true, value = "The payment method code")
  /**
   * The payment method code
   *
   * @return paymentMethod PaymentMethodEnum
   */
  public PaymentMethodEnum getPaymentMethod() {
    return paymentMethod;
  }

  /**
   * The payment method code
   *
   * @param paymentMethod PaymentMethodEnum
   */
  public void setPaymentMethod(PaymentMethodEnum paymentMethod) {
    this.paymentMethod = paymentMethod;
  }

  /**
   * bankAccounts
   *
   * @param bankAccounts List&lt;BankAccount&gt;
   * @return PaymentMethod
   */
  public PaymentMethod bankAccounts(List<BankAccount> bankAccounts) {
    this.bankAccounts = bankAccounts;
    return this;
  }

  /**
   * bankAccounts
   *
   * @param bankAccountsItem BankAccount
   * @return PaymentMethod
   */
  public PaymentMethod addBankAccountsItem(BankAccount bankAccountsItem) {
    if (this.bankAccounts == null) {
      this.bankAccounts = new ArrayList<BankAccount>();
    }
    this.bankAccounts.add(bankAccountsItem);
    return this;
  }

  /**
   * Get bankAccounts
   *
   * @return bankAccounts
   */
  @ApiModelProperty(value = "")
  /**
   * bankAccounts
   *
   * @return bankAccounts List<BankAccount>
   */
  public List<BankAccount> getBankAccounts() {
    return bankAccounts;
  }

  /**
   * bankAccounts
   *
   * @param bankAccounts List&lt;BankAccount&gt;
   */
  public void setBankAccounts(List<BankAccount> bankAccounts) {
    this.bankAccounts = bankAccounts;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethod paymentMethod = (PaymentMethod) o;
    return Objects.equals(this.paymentMethod, paymentMethod.paymentMethod)
        && Objects.equals(this.bankAccounts, paymentMethod.bankAccounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentMethod, bankAccounts);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethod {\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    bankAccounts: ").append(toIndentedString(bankAccounts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
