/*
 * Xero Payroll UK
 * This is the Xero Payroll API for orgs in the UK region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

/** SalaryAndWage */
public class SalaryAndWage {
  StringUtil util = new StringUtil();

  @JsonProperty("salaryAndWagesID")
  private UUID salaryAndWagesID;

  @JsonProperty("earningsRateID")
  private UUID earningsRateID;

  @JsonProperty("numberOfUnitsPerWeek")
  private Double numberOfUnitsPerWeek;

  @JsonProperty("ratePerUnit")
  private Double ratePerUnit;

  @JsonProperty("numberOfUnitsPerDay")
  private Double numberOfUnitsPerDay;

  @JsonProperty("effectiveFrom")
  private LocalDate effectiveFrom;

  @JsonProperty("annualSalary")
  private Double annualSalary;

  /** The current status of the corresponding salary and wages */
  public enum StatusEnum {
    /** ACTIVE */
    ACTIVE("Active"),

    /** PENDING */
    PENDING("Pending"),

    /** HISTORY */
    HISTORY("History");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  /** The type of the payment of the corresponding salary and wages */
  public enum PaymentTypeEnum {
    /** SALARY */
    SALARY("Salary"),

    /** HOURLY */
    HOURLY("Hourly");

    private String value;

    PaymentTypeEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static PaymentTypeEnum fromValue(String value) {
      for (PaymentTypeEnum b : PaymentTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("paymentType")
  private PaymentTypeEnum paymentType;

  /**
   * Xero unique identifier for a salary and wages record
   *
   * @param salaryAndWagesID UUID
   * @return SalaryAndWage
   */
  public SalaryAndWage salaryAndWagesID(UUID salaryAndWagesID) {
    this.salaryAndWagesID = salaryAndWagesID;
    return this;
  }

  /**
   * Xero unique identifier for a salary and wages record
   *
   * @return salaryAndWagesID
   */
  @ApiModelProperty(value = "Xero unique identifier for a salary and wages record")
  /**
   * Xero unique identifier for a salary and wages record
   *
   * @return salaryAndWagesID UUID
   */
  public UUID getSalaryAndWagesID() {
    return salaryAndWagesID;
  }

  /**
   * Xero unique identifier for a salary and wages record
   *
   * @param salaryAndWagesID UUID
   */
  public void setSalaryAndWagesID(UUID salaryAndWagesID) {
    this.salaryAndWagesID = salaryAndWagesID;
  }

  /**
   * Xero unique identifier for an earnings rate
   *
   * @param earningsRateID UUID
   * @return SalaryAndWage
   */
  public SalaryAndWage earningsRateID(UUID earningsRateID) {
    this.earningsRateID = earningsRateID;
    return this;
  }

  /**
   * Xero unique identifier for an earnings rate
   *
   * @return earningsRateID
   */
  @ApiModelProperty(required = true, value = "Xero unique identifier for an earnings rate")
  /**
   * Xero unique identifier for an earnings rate
   *
   * @return earningsRateID UUID
   */
  public UUID getEarningsRateID() {
    return earningsRateID;
  }

  /**
   * Xero unique identifier for an earnings rate
   *
   * @param earningsRateID UUID
   */
  public void setEarningsRateID(UUID earningsRateID) {
    this.earningsRateID = earningsRateID;
  }

  /**
   * The Number of Units per week for the corresponding salary and wages
   *
   * @param numberOfUnitsPerWeek Double
   * @return SalaryAndWage
   */
  public SalaryAndWage numberOfUnitsPerWeek(Double numberOfUnitsPerWeek) {
    this.numberOfUnitsPerWeek = numberOfUnitsPerWeek;
    return this;
  }

  /**
   * The Number of Units per week for the corresponding salary and wages
   *
   * @return numberOfUnitsPerWeek
   */
  @ApiModelProperty(
      required = true,
      value = "The Number of Units per week for the corresponding salary and wages")
  /**
   * The Number of Units per week for the corresponding salary and wages
   *
   * @return numberOfUnitsPerWeek Double
   */
  public Double getNumberOfUnitsPerWeek() {
    return numberOfUnitsPerWeek;
  }

  /**
   * The Number of Units per week for the corresponding salary and wages
   *
   * @param numberOfUnitsPerWeek Double
   */
  public void setNumberOfUnitsPerWeek(Double numberOfUnitsPerWeek) {
    this.numberOfUnitsPerWeek = numberOfUnitsPerWeek;
  }

  /**
   * The rate of each unit for the corresponding salary and wages
   *
   * @param ratePerUnit Double
   * @return SalaryAndWage
   */
  public SalaryAndWage ratePerUnit(Double ratePerUnit) {
    this.ratePerUnit = ratePerUnit;
    return this;
  }

  /**
   * The rate of each unit for the corresponding salary and wages
   *
   * @return ratePerUnit
   */
  @ApiModelProperty(value = "The rate of each unit for the corresponding salary and wages")
  /**
   * The rate of each unit for the corresponding salary and wages
   *
   * @return ratePerUnit Double
   */
  public Double getRatePerUnit() {
    return ratePerUnit;
  }

  /**
   * The rate of each unit for the corresponding salary and wages
   *
   * @param ratePerUnit Double
   */
  public void setRatePerUnit(Double ratePerUnit) {
    this.ratePerUnit = ratePerUnit;
  }

  /**
   * The Number of Units per day for the corresponding salary and wages
   *
   * @param numberOfUnitsPerDay Double
   * @return SalaryAndWage
   */
  public SalaryAndWage numberOfUnitsPerDay(Double numberOfUnitsPerDay) {
    this.numberOfUnitsPerDay = numberOfUnitsPerDay;
    return this;
  }

  /**
   * The Number of Units per day for the corresponding salary and wages
   *
   * @return numberOfUnitsPerDay
   */
  @ApiModelProperty(value = "The Number of Units per day for the corresponding salary and wages")
  /**
   * The Number of Units per day for the corresponding salary and wages
   *
   * @return numberOfUnitsPerDay Double
   */
  public Double getNumberOfUnitsPerDay() {
    return numberOfUnitsPerDay;
  }

  /**
   * The Number of Units per day for the corresponding salary and wages
   *
   * @param numberOfUnitsPerDay Double
   */
  public void setNumberOfUnitsPerDay(Double numberOfUnitsPerDay) {
    this.numberOfUnitsPerDay = numberOfUnitsPerDay;
  }

  /**
   * The effective date of the corresponding salary and wages
   *
   * @param effectiveFrom LocalDate
   * @return SalaryAndWage
   */
  public SalaryAndWage effectiveFrom(LocalDate effectiveFrom) {
    this.effectiveFrom = effectiveFrom;
    return this;
  }

  /**
   * The effective date of the corresponding salary and wages
   *
   * @return effectiveFrom
   */
  @ApiModelProperty(
      required = true,
      value = "The effective date of the corresponding salary and wages")
  /**
   * The effective date of the corresponding salary and wages
   *
   * @return effectiveFrom LocalDate
   */
  public LocalDate getEffectiveFrom() {
    return effectiveFrom;
  }

  /**
   * The effective date of the corresponding salary and wages
   *
   * @param effectiveFrom LocalDate
   */
  public void setEffectiveFrom(LocalDate effectiveFrom) {
    this.effectiveFrom = effectiveFrom;
  }

  /**
   * The annual salary
   *
   * @param annualSalary Double
   * @return SalaryAndWage
   */
  public SalaryAndWage annualSalary(Double annualSalary) {
    this.annualSalary = annualSalary;
    return this;
  }

  /**
   * The annual salary
   *
   * @return annualSalary
   */
  @ApiModelProperty(required = true, value = "The annual salary")
  /**
   * The annual salary
   *
   * @return annualSalary Double
   */
  public Double getAnnualSalary() {
    return annualSalary;
  }

  /**
   * The annual salary
   *
   * @param annualSalary Double
   */
  public void setAnnualSalary(Double annualSalary) {
    this.annualSalary = annualSalary;
  }

  /**
   * The current status of the corresponding salary and wages
   *
   * @param status StatusEnum
   * @return SalaryAndWage
   */
  public SalaryAndWage status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * The current status of the corresponding salary and wages
   *
   * @return status
   */
  @ApiModelProperty(
      required = true,
      value = "The current status of the corresponding salary and wages")
  /**
   * The current status of the corresponding salary and wages
   *
   * @return status StatusEnum
   */
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * The current status of the corresponding salary and wages
   *
   * @param status StatusEnum
   */
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * The type of the payment of the corresponding salary and wages
   *
   * @param paymentType PaymentTypeEnum
   * @return SalaryAndWage
   */
  public SalaryAndWage paymentType(PaymentTypeEnum paymentType) {
    this.paymentType = paymentType;
    return this;
  }

  /**
   * The type of the payment of the corresponding salary and wages
   *
   * @return paymentType
   */
  @ApiModelProperty(
      required = true,
      value = "The type of the payment of the corresponding salary and wages")
  /**
   * The type of the payment of the corresponding salary and wages
   *
   * @return paymentType PaymentTypeEnum
   */
  public PaymentTypeEnum getPaymentType() {
    return paymentType;
  }

  /**
   * The type of the payment of the corresponding salary and wages
   *
   * @param paymentType PaymentTypeEnum
   */
  public void setPaymentType(PaymentTypeEnum paymentType) {
    this.paymentType = paymentType;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalaryAndWage salaryAndWage = (SalaryAndWage) o;
    return Objects.equals(this.salaryAndWagesID, salaryAndWage.salaryAndWagesID)
        && Objects.equals(this.earningsRateID, salaryAndWage.earningsRateID)
        && Objects.equals(this.numberOfUnitsPerWeek, salaryAndWage.numberOfUnitsPerWeek)
        && Objects.equals(this.ratePerUnit, salaryAndWage.ratePerUnit)
        && Objects.equals(this.numberOfUnitsPerDay, salaryAndWage.numberOfUnitsPerDay)
        && Objects.equals(this.effectiveFrom, salaryAndWage.effectiveFrom)
        && Objects.equals(this.annualSalary, salaryAndWage.annualSalary)
        && Objects.equals(this.status, salaryAndWage.status)
        && Objects.equals(this.paymentType, salaryAndWage.paymentType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        salaryAndWagesID,
        earningsRateID,
        numberOfUnitsPerWeek,
        ratePerUnit,
        numberOfUnitsPerDay,
        effectiveFrom,
        annualSalary,
        status,
        paymentType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalaryAndWage {\n");
    sb.append("    salaryAndWagesID: ").append(toIndentedString(salaryAndWagesID)).append("\n");
    sb.append("    earningsRateID: ").append(toIndentedString(earningsRateID)).append("\n");
    sb.append("    numberOfUnitsPerWeek: ")
        .append(toIndentedString(numberOfUnitsPerWeek))
        .append("\n");
    sb.append("    ratePerUnit: ").append(toIndentedString(ratePerUnit)).append("\n");
    sb.append("    numberOfUnitsPerDay: ")
        .append(toIndentedString(numberOfUnitsPerDay))
        .append("\n");
    sb.append("    effectiveFrom: ").append(toIndentedString(effectiveFrom)).append("\n");
    sb.append("    annualSalary: ").append(toIndentedString(annualSalary)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    paymentType: ").append(toIndentedString(paymentType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
