/*
 * Xero Payroll UK
 * This is the Xero Payroll API for orgs in the UK region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** TimesheetEarningsLine */
public class TimesheetEarningsLine {
  StringUtil util = new StringUtil();

  @JsonProperty("earningsRateID")
  private UUID earningsRateID;

  @JsonProperty("ratePerUnit")
  private Double ratePerUnit;

  @JsonProperty("numberOfUnits")
  private Double numberOfUnits;

  @JsonProperty("fixedAmount")
  private Double fixedAmount;

  @JsonProperty("amount")
  private Double amount;

  @JsonProperty("isLinkedToTimesheet")
  private Boolean isLinkedToTimesheet;

  /**
   * Xero identifier for payroll timesheet earnings rate
   *
   * @param earningsRateID UUID
   * @return TimesheetEarningsLine
   */
  public TimesheetEarningsLine earningsRateID(UUID earningsRateID) {
    this.earningsRateID = earningsRateID;
    return this;
  }

  /**
   * Xero identifier for payroll timesheet earnings rate
   *
   * @return earningsRateID
   */
  @ApiModelProperty(value = "Xero identifier for payroll timesheet earnings rate")
  /**
   * Xero identifier for payroll timesheet earnings rate
   *
   * @return earningsRateID UUID
   */
  public UUID getEarningsRateID() {
    return earningsRateID;
  }

  /**
   * Xero identifier for payroll timesheet earnings rate
   *
   * @param earningsRateID UUID
   */
  public void setEarningsRateID(UUID earningsRateID) {
    this.earningsRateID = earningsRateID;
  }

  /**
   * Rate per unit for timesheet earnings line
   *
   * @param ratePerUnit Double
   * @return TimesheetEarningsLine
   */
  public TimesheetEarningsLine ratePerUnit(Double ratePerUnit) {
    this.ratePerUnit = ratePerUnit;
    return this;
  }

  /**
   * Rate per unit for timesheet earnings line
   *
   * @return ratePerUnit
   */
  @ApiModelProperty(value = "Rate per unit for timesheet earnings line")
  /**
   * Rate per unit for timesheet earnings line
   *
   * @return ratePerUnit Double
   */
  public Double getRatePerUnit() {
    return ratePerUnit;
  }

  /**
   * Rate per unit for timesheet earnings line
   *
   * @param ratePerUnit Double
   */
  public void setRatePerUnit(Double ratePerUnit) {
    this.ratePerUnit = ratePerUnit;
  }

  /**
   * Timesheet earnings number of units
   *
   * @param numberOfUnits Double
   * @return TimesheetEarningsLine
   */
  public TimesheetEarningsLine numberOfUnits(Double numberOfUnits) {
    this.numberOfUnits = numberOfUnits;
    return this;
  }

  /**
   * Timesheet earnings number of units
   *
   * @return numberOfUnits
   */
  @ApiModelProperty(value = "Timesheet earnings number of units")
  /**
   * Timesheet earnings number of units
   *
   * @return numberOfUnits Double
   */
  public Double getNumberOfUnits() {
    return numberOfUnits;
  }

  /**
   * Timesheet earnings number of units
   *
   * @param numberOfUnits Double
   */
  public void setNumberOfUnits(Double numberOfUnits) {
    this.numberOfUnits = numberOfUnits;
  }

  /**
   * Timesheet earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed
   *
   * @param fixedAmount Double
   * @return TimesheetEarningsLine
   */
  public TimesheetEarningsLine fixedAmount(Double fixedAmount) {
    this.fixedAmount = fixedAmount;
    return this;
  }

  /**
   * Timesheet earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed
   *
   * @return fixedAmount
   */
  @ApiModelProperty(
      value =
          "Timesheet earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed")
  /**
   * Timesheet earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed
   *
   * @return fixedAmount Double
   */
  public Double getFixedAmount() {
    return fixedAmount;
  }

  /**
   * Timesheet earnings fixed amount. Only applicable if the EarningsRate RateType is Fixed
   *
   * @param fixedAmount Double
   */
  public void setFixedAmount(Double fixedAmount) {
    this.fixedAmount = fixedAmount;
  }

  /**
   * The amount of the timesheet earnings line.
   *
   * @param amount Double
   * @return TimesheetEarningsLine
   */
  public TimesheetEarningsLine amount(Double amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The amount of the timesheet earnings line.
   *
   * @return amount
   */
  @ApiModelProperty(value = "The amount of the timesheet earnings line.")
  /**
   * The amount of the timesheet earnings line.
   *
   * @return amount Double
   */
  public Double getAmount() {
    return amount;
  }

  /**
   * The amount of the timesheet earnings line.
   *
   * @param amount Double
   */
  public void setAmount(Double amount) {
    this.amount = amount;
  }

  /**
   * Identifies if the timesheet earnings is taken from the timesheet. False for leave earnings line
   *
   * @param isLinkedToTimesheet Boolean
   * @return TimesheetEarningsLine
   */
  public TimesheetEarningsLine isLinkedToTimesheet(Boolean isLinkedToTimesheet) {
    this.isLinkedToTimesheet = isLinkedToTimesheet;
    return this;
  }

  /**
   * Identifies if the timesheet earnings is taken from the timesheet. False for leave earnings line
   *
   * @return isLinkedToTimesheet
   */
  @ApiModelProperty(
      value =
          "Identifies if the timesheet earnings is taken from the timesheet. False for leave"
              + " earnings line")
  /**
   * Identifies if the timesheet earnings is taken from the timesheet. False for leave earnings line
   *
   * @return isLinkedToTimesheet Boolean
   */
  public Boolean getIsLinkedToTimesheet() {
    return isLinkedToTimesheet;
  }

  /**
   * Identifies if the timesheet earnings is taken from the timesheet. False for leave earnings line
   *
   * @param isLinkedToTimesheet Boolean
   */
  public void setIsLinkedToTimesheet(Boolean isLinkedToTimesheet) {
    this.isLinkedToTimesheet = isLinkedToTimesheet;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TimesheetEarningsLine timesheetEarningsLine = (TimesheetEarningsLine) o;
    return Objects.equals(this.earningsRateID, timesheetEarningsLine.earningsRateID)
        && Objects.equals(this.ratePerUnit, timesheetEarningsLine.ratePerUnit)
        && Objects.equals(this.numberOfUnits, timesheetEarningsLine.numberOfUnits)
        && Objects.equals(this.fixedAmount, timesheetEarningsLine.fixedAmount)
        && Objects.equals(this.amount, timesheetEarningsLine.amount)
        && Objects.equals(this.isLinkedToTimesheet, timesheetEarningsLine.isLinkedToTimesheet);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        earningsRateID, ratePerUnit, numberOfUnits, fixedAmount, amount, isLinkedToTimesheet);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TimesheetEarningsLine {\n");
    sb.append("    earningsRateID: ").append(toIndentedString(earningsRateID)).append("\n");
    sb.append("    ratePerUnit: ").append(toIndentedString(ratePerUnit)).append("\n");
    sb.append("    numberOfUnits: ").append(toIndentedString(numberOfUnits)).append("\n");
    sb.append("    fixedAmount: ").append(toIndentedString(fixedAmount)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    isLinkedToTimesheet: ")
        .append(toIndentedString(isLinkedToTimesheet))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
