/*
 * Xero Payroll NZ
 * This is the Xero Payroll API for orgs in the NZ region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** ReimbursementLine */
public class ReimbursementLine {
  StringUtil util = new StringUtil();

  @JsonProperty("reimbursementTypeID")
  private UUID reimbursementTypeID;

  @JsonProperty("description")
  private String description;

  @JsonProperty("amount")
  private Double amount;

  @JsonProperty("ratePerUnit")
  private Double ratePerUnit;

  @JsonProperty("numberOfUnits")
  private Double numberOfUnits;
  /**
   * Xero identifier for payroll reimbursement
   *
   * @param reimbursementTypeID UUID
   * @return ReimbursementLine
   */
  public ReimbursementLine reimbursementTypeID(UUID reimbursementTypeID) {
    this.reimbursementTypeID = reimbursementTypeID;
    return this;
  }

  /**
   * Xero identifier for payroll reimbursement
   *
   * @return reimbursementTypeID
   */
  @ApiModelProperty(value = "Xero identifier for payroll reimbursement")
  /**
   * Xero identifier for payroll reimbursement
   *
   * @return reimbursementTypeID UUID
   */
  public UUID getReimbursementTypeID() {
    return reimbursementTypeID;
  }

  /**
   * Xero identifier for payroll reimbursement
   *
   * @param reimbursementTypeID UUID
   */
  public void setReimbursementTypeID(UUID reimbursementTypeID) {
    this.reimbursementTypeID = reimbursementTypeID;
  }

  /**
   * Reimbursement line description
   *
   * @param description String
   * @return ReimbursementLine
   */
  public ReimbursementLine description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Reimbursement line description
   *
   * @return description
   */
  @ApiModelProperty(value = "Reimbursement line description")
  /**
   * Reimbursement line description
   *
   * @return description String
   */
  public String getDescription() {
    return description;
  }

  /**
   * Reimbursement line description
   *
   * @param description String
   */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Reimbursement amount
   *
   * @param amount Double
   * @return ReimbursementLine
   */
  public ReimbursementLine amount(Double amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Reimbursement amount
   *
   * @return amount
   */
  @ApiModelProperty(value = "Reimbursement amount")
  /**
   * Reimbursement amount
   *
   * @return amount Double
   */
  public Double getAmount() {
    return amount;
  }

  /**
   * Reimbursement amount
   *
   * @param amount Double
   */
  public void setAmount(Double amount) {
    this.amount = amount;
  }

  /**
   * Rate per unit for leave earnings line
   *
   * @param ratePerUnit Double
   * @return ReimbursementLine
   */
  public ReimbursementLine ratePerUnit(Double ratePerUnit) {
    this.ratePerUnit = ratePerUnit;
    return this;
  }

  /**
   * Rate per unit for leave earnings line
   *
   * @return ratePerUnit
   */
  @ApiModelProperty(value = "Rate per unit for leave earnings line")
  /**
   * Rate per unit for leave earnings line
   *
   * @return ratePerUnit Double
   */
  public Double getRatePerUnit() {
    return ratePerUnit;
  }

  /**
   * Rate per unit for leave earnings line
   *
   * @param ratePerUnit Double
   */
  public void setRatePerUnit(Double ratePerUnit) {
    this.ratePerUnit = ratePerUnit;
  }

  /**
   * Leave earnings number of units
   *
   * @param numberOfUnits Double
   * @return ReimbursementLine
   */
  public ReimbursementLine numberOfUnits(Double numberOfUnits) {
    this.numberOfUnits = numberOfUnits;
    return this;
  }

  /**
   * Leave earnings number of units
   *
   * @return numberOfUnits
   */
  @ApiModelProperty(value = "Leave earnings number of units")
  /**
   * Leave earnings number of units
   *
   * @return numberOfUnits Double
   */
  public Double getNumberOfUnits() {
    return numberOfUnits;
  }

  /**
   * Leave earnings number of units
   *
   * @param numberOfUnits Double
   */
  public void setNumberOfUnits(Double numberOfUnits) {
    this.numberOfUnits = numberOfUnits;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReimbursementLine reimbursementLine = (ReimbursementLine) o;
    return Objects.equals(this.reimbursementTypeID, reimbursementLine.reimbursementTypeID)
        && Objects.equals(this.description, reimbursementLine.description)
        && Objects.equals(this.amount, reimbursementLine.amount)
        && Objects.equals(this.ratePerUnit, reimbursementLine.ratePerUnit)
        && Objects.equals(this.numberOfUnits, reimbursementLine.numberOfUnits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reimbursementTypeID, description, amount, ratePerUnit, numberOfUnits);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReimbursementLine {\n");
    sb.append("    reimbursementTypeID: ")
        .append(toIndentedString(reimbursementTypeID))
        .append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    ratePerUnit: ").append(toIndentedString(ratePerUnit)).append("\n");
    sb.append("    numberOfUnits: ").append(toIndentedString(numberOfUnits)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
