/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** CashflowAccount */
public class CashflowAccount {
  StringUtil util = new StringUtil();

  @JsonProperty("accountId")
  private UUID accountId;

  @JsonProperty("accountType")
  private String accountType;

  @JsonProperty("accountClass")
  private String accountClass;

  @JsonProperty("code")
  private String code;

  @JsonProperty("name")
  private String name;

  @JsonProperty("reportingCode")
  private String reportingCode;

  @JsonProperty("total")
  private Double total;
  /**
   * ID of the account
   *
   * @param accountId UUID
   * @return CashflowAccount
   */
  public CashflowAccount accountId(UUID accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * ID of the account
   *
   * @return accountId
   */
  @ApiModelProperty(value = "ID of the account")
  /**
   * ID of the account
   *
   * @return accountId UUID
   */
  public UUID getAccountId() {
    return accountId;
  }

  /**
   * ID of the account
   *
   * @param accountId UUID
   */
  public void setAccountId(UUID accountId) {
    this.accountId = accountId;
  }

  /**
   * The type of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountTypes&#39;&gt;Account
   * Types&lt;/a&gt;
   *
   * @param accountType String
   * @return CashflowAccount
   */
  public CashflowAccount accountType(String accountType) {
    this.accountType = accountType;
    return this;
  }

  /**
   * The type of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountTypes&#39;&gt;Account
   * Types&lt;/a&gt;
   *
   * @return accountType
   */
  @ApiModelProperty(
      value =
          "The type of the account. See <a"
              + " href='https://developer.xero.com/documentation/api/types#AccountTypes'>Account"
              + " Types</a>")
  /**
   * The type of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountTypes&#39;&gt;Account
   * Types&lt;/a&gt;
   *
   * @return accountType String
   */
  public String getAccountType() {
    return accountType;
  }

  /**
   * The type of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountTypes&#39;&gt;Account
   * Types&lt;/a&gt;
   *
   * @param accountType String
   */
  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }

  /**
   * The class of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountClassTypes&#39;&gt;Account
   * Class Types&lt;/a&gt;
   *
   * @param accountClass String
   * @return CashflowAccount
   */
  public CashflowAccount accountClass(String accountClass) {
    this.accountClass = accountClass;
    return this;
  }

  /**
   * The class of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountClassTypes&#39;&gt;Account
   * Class Types&lt;/a&gt;
   *
   * @return accountClass
   */
  @ApiModelProperty(
      value =
          "The class of the account. See <a"
              + " href='https://developer.xero.com/documentation/api/types#AccountClassTypes'>Account"
              + " Class Types</a>")
  /**
   * The class of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountClassTypes&#39;&gt;Account
   * Class Types&lt;/a&gt;
   *
   * @return accountClass String
   */
  public String getAccountClass() {
    return accountClass;
  }

  /**
   * The class of the account. See &lt;a
   * href&#x3D;&#39;https://developer.xero.com/documentation/api/types#AccountClassTypes&#39;&gt;Account
   * Class Types&lt;/a&gt;
   *
   * @param accountClass String
   */
  public void setAccountClass(String accountClass) {
    this.accountClass = accountClass;
  }

  /**
   * Account code
   *
   * @param code String
   * @return CashflowAccount
   */
  public CashflowAccount code(String code) {
    this.code = code;
    return this;
  }

  /**
   * Account code
   *
   * @return code
   */
  @ApiModelProperty(value = "Account code")
  /**
   * Account code
   *
   * @return code String
   */
  public String getCode() {
    return code;
  }

  /**
   * Account code
   *
   * @param code String
   */
  public void setCode(String code) {
    this.code = code;
  }

  /**
   * Account name
   *
   * @param name String
   * @return CashflowAccount
   */
  public CashflowAccount name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Account name
   *
   * @return name
   */
  @ApiModelProperty(value = "Account name")
  /**
   * Account name
   *
   * @return name String
   */
  public String getName() {
    return name;
  }

  /**
   * Account name
   *
   * @param name String
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Reporting code used for cash flow classification
   *
   * @param reportingCode String
   * @return CashflowAccount
   */
  public CashflowAccount reportingCode(String reportingCode) {
    this.reportingCode = reportingCode;
    return this;
  }

  /**
   * Reporting code used for cash flow classification
   *
   * @return reportingCode
   */
  @ApiModelProperty(value = "Reporting code used for cash flow classification")
  /**
   * Reporting code used for cash flow classification
   *
   * @return reportingCode String
   */
  public String getReportingCode() {
    return reportingCode;
  }

  /**
   * Reporting code used for cash flow classification
   *
   * @param reportingCode String
   */
  public void setReportingCode(String reportingCode) {
    this.reportingCode = reportingCode;
  }

  /**
   * Total amount for the account
   *
   * @param total Double
   * @return CashflowAccount
   */
  public CashflowAccount total(Double total) {
    this.total = total;
    return this;
  }

  /**
   * Total amount for the account
   *
   * @return total
   */
  @ApiModelProperty(value = "Total amount for the account")
  /**
   * Total amount for the account
   *
   * @return total Double
   */
  public Double getTotal() {
    return total;
  }

  /**
   * Total amount for the account
   *
   * @param total Double
   */
  public void setTotal(Double total) {
    this.total = total;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CashflowAccount cashflowAccount = (CashflowAccount) o;
    return Objects.equals(this.accountId, cashflowAccount.accountId)
        && Objects.equals(this.accountType, cashflowAccount.accountType)
        && Objects.equals(this.accountClass, cashflowAccount.accountClass)
        && Objects.equals(this.code, cashflowAccount.code)
        && Objects.equals(this.name, cashflowAccount.name)
        && Objects.equals(this.reportingCode, cashflowAccount.reportingCode)
        && Objects.equals(this.total, cashflowAccount.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, accountType, accountClass, code, name, reportingCode, total);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CashflowAccount {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    accountClass: ").append(toIndentedString(accountClass)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    reportingCode: ").append(toIndentedString(reportingCode)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
