/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** PnlAccountType */
public class PnlAccountType {
  StringUtil util = new StringUtil();

  @JsonProperty("total")
  private Double total;

  @JsonProperty("title")
  private String title;

  @JsonProperty("accounts")
  private List<PnlAccount> accounts = new ArrayList<PnlAccount>();
  /**
   * Total movement on this account type
   *
   * @param total Double
   * @return PnlAccountType
   */
  public PnlAccountType total(Double total) {
    this.total = total;
    return this;
  }

  /**
   * Total movement on this account type
   *
   * @return total
   */
  @ApiModelProperty(value = "Total movement on this account type")
  /**
   * Total movement on this account type
   *
   * @return total Double
   */
  public Double getTotal() {
    return total;
  }

  /**
   * Total movement on this account type
   *
   * @param total Double
   */
  public void setTotal(Double total) {
    this.total = total;
  }

  /**
   * Name of this account type, it will be either Trading Income or Other Income for Revenue section
   * / Direct Cost or Operating Expenses for Expense section
   *
   * @param title String
   * @return PnlAccountType
   */
  public PnlAccountType title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Name of this account type, it will be either Trading Income or Other Income for Revenue section
   * / Direct Cost or Operating Expenses for Expense section
   *
   * @return title
   */
  @ApiModelProperty(
      value =
          "Name of this account type, it will be either Trading Income or Other Income for Revenue"
              + " section / Direct Cost or Operating Expenses for Expense section")
  /**
   * Name of this account type, it will be either Trading Income or Other Income for Revenue section
   * / Direct Cost or Operating Expenses for Expense section
   *
   * @return title String
   */
  public String getTitle() {
    return title;
  }

  /**
   * Name of this account type, it will be either Trading Income or Other Income for Revenue section
   * / Direct Cost or Operating Expenses for Expense section
   *
   * @param title String
   */
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * A list of the movement on each account detail during the query period. Refer to the account
   * detail element below
   *
   * @param accounts List&lt;PnlAccount&gt;
   * @return PnlAccountType
   */
  public PnlAccountType accounts(List<PnlAccount> accounts) {
    this.accounts = accounts;
    return this;
  }

  /**
   * A list of the movement on each account detail during the query period. Refer to the account
   * detail element below
   *
   * @param accountsItem PnlAccount
   * @return PnlAccountType
   */
  public PnlAccountType addAccountsItem(PnlAccount accountsItem) {
    if (this.accounts == null) {
      this.accounts = new ArrayList<PnlAccount>();
    }
    this.accounts.add(accountsItem);
    return this;
  }

  /**
   * A list of the movement on each account detail during the query period. Refer to the account
   * detail element below
   *
   * @return accounts
   */
  @ApiModelProperty(
      value =
          "A list of the movement on each account detail during the query period. Refer to the"
              + " account detail element below")
  /**
   * A list of the movement on each account detail during the query period. Refer to the account
   * detail element below
   *
   * @return accounts List<PnlAccount>
   */
  public List<PnlAccount> getAccounts() {
    return accounts;
  }

  /**
   * A list of the movement on each account detail during the query period. Refer to the account
   * detail element below
   *
   * @param accounts List&lt;PnlAccount&gt;
   */
  public void setAccounts(List<PnlAccount> accounts) {
    this.accounts = accounts;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PnlAccountType pnlAccountType = (PnlAccountType) o;
    return Objects.equals(this.total, pnlAccountType.total)
        && Objects.equals(this.title, pnlAccountType.title)
        && Objects.equals(this.accounts, pnlAccountType.accounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, title, accounts);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PnlAccountType {\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    accounts: ").append(toIndentedString(accounts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
