/*
 * Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.api;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneOffset;

/** StringUtil has helper methods for String and Date conversions  */
public class StringUtil {
    /**
     * Check if the given array contains the given value (with case-insensitive
     * comparison).
     *
     * @param array
     *            The array
     * @param value
     *            The value to search
     * @return true if the array contains the value
     */
    public static boolean containsIgnoreCase(String[] array, String value) {
        for (String str : array) {
            if (value == null && str == null) {
                return true;
            }
            if (value != null && value.equalsIgnoreCase(str)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Join an array of strings with the given separator.
     * <p>
     * Note: This might be replaced by utility method from commons-lang or guava
     * someday if one of those libraries is added as dependency.
     * </p>
     *
     * @param array
     *            The array of strings
     * @param separator
     *            The separator
     * @return the resulting string
     */
    public static String join(String[] array, String separator) {
        int len = array.length;
        if (len == 0) {
            return "";
        }

        StringBuilder out = new StringBuilder();
        out.append(array[0]);
        for (int i = 1; i < len; i++) {
            out.append(separator).append(array[i]);
        }
        return out.toString();
    }

    /** Convert string to date
    * @param date String is a date in MS DateFormat
    * @return LocalDate a standard date  
    * @exception IOException thown if string pattern matching and formatting fails
    */
    public LocalDate convertStringToDate(String date)
            throws IOException {
        LocalDate formattedDate;
        Pattern datePatt = Pattern.compile("^/Date\\((\\d+)([+-]\\d+)?\\)/$");
        Pattern datePattNeg = Pattern.compile("^/Date\\(-(\\d+)([+-]\\d+)?\\)/$");
        Matcher m = datePatt.matcher(date);
        Matcher matchNeg = datePattNeg.matcher(date);
        if (m != null && m.matches()) {
            Long l = Long.parseLong(m.group(1));
            formattedDate = Instant.ofEpochMilli(l).atZone(ZoneOffset.UTC).toLocalDate();
        } else if (matchNeg != null && matchNeg.matches()) {
            Long l = Long.parseLong(matchNeg.group(1));
            formattedDate = Instant.ofEpochMilli(-l).atZone(ZoneOffset.UTC).toLocalDate();
        } else {
            throw new IllegalArgumentException("Wrong date format");
        }
        return formattedDate;
    }
    
    /** Convert string to datetime
    * @param date String is a date in MS DateFormat
    * @return OffsetDateTime an offset date time set to UTC  
    * @exception IOException thown if string pattern matching and formatting fails
    */
    public OffsetDateTime convertStringToOffsetDateTime(String date)
            throws IOException {
        OffsetDateTime formattedDate;
        Pattern datePatt = Pattern.compile("^/Date\\((\\d+)([+-]\\d+)?\\)/$");
        Matcher m = datePatt.matcher(date);
        Pattern datePattNeg = Pattern.compile("^/Date\\(-(\\d+)([+-]\\d+)?\\)/$");
        Matcher mNeg = datePattNeg.matcher(date);
        if (m != null && m.matches()) {
            Long l = Long.parseLong(m.group(1));
            formattedDate = Instant.ofEpochMilli(l).atZone(ZoneOffset.UTC).toOffsetDateTime();
        } else if (mNeg != null && mNeg.matches()) {
            Long l = Long.parseLong(mNeg.group(1));
            formattedDate = Instant.ofEpochMilli(-l).atZone(ZoneOffset.UTC).toOffsetDateTime();
        } else {
            throw new IllegalArgumentException("Wrong date format");
        }
        return formattedDate;
    }

    /** Convert string to datetime
    * @param date String is a date in MS DateFormat
    * @return LocalDateTime an local date time   
    * @exception IOException thown if string pattern matching and formatting fails
    */
    public LocalDateTime convertStringToLocalDateTime(String date)
            throws IOException {
        LocalDateTime formattedDate;
        Pattern datePatt = Pattern.compile("^/Date\\((\\d+)([+-]\\d+)?\\)/$");
        Matcher m = datePatt.matcher(date);
        Pattern datePattNeg = Pattern.compile("^/Date\\(-(\\d+)([+-]\\d+)?\\)/$");
        Matcher mNeg = datePattNeg.matcher(date);
        if (m != null && m.matches()) {
            Long l = Long.parseLong(m.group(1));
            formattedDate = Instant.ofEpochMilli(l).atZone(ZoneOffset.UTC).toLocalDateTime();
        } else if (mNeg != null && mNeg.matches()) {
            Long l = Long.parseLong(mNeg.group(1));
            formattedDate = Instant.ofEpochMilli(-l).atZone(ZoneOffset.UTC).toLocalDateTime();
        } else {
            throw new IllegalArgumentException("Wrong date format");
        }
        return formattedDate;
    }
}
