/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

/** PaymentResponse */
public class PaymentResponse {
  StringUtil util = new StringUtil();

  @JsonProperty("paymentId")
  private UUID paymentId;

  @JsonProperty("batchPaymentId")
  private UUID batchPaymentId;

  @JsonProperty("date")
  private LocalDate date;

  @JsonProperty("amount")
  private Double amount;

  @JsonProperty("bankAmount")
  private Double bankAmount;

  @JsonProperty("currencyRate")
  private Double currencyRate;

  @JsonProperty("invoice")
  private InvoiceResponse invoice;

  @JsonProperty("creditNote")
  private CreditNoteResponse creditNote;

  @JsonProperty("prepayment")
  private PrepaymentResponse prepayment;

  @JsonProperty("overpayment")
  private OverpaymentResponse overpayment;
  /**
   * Xero Identifier of payment
   *
   * @param paymentId UUID
   * @return PaymentResponse
   */
  public PaymentResponse paymentId(UUID paymentId) {
    this.paymentId = paymentId;
    return this;
  }

  /**
   * Xero Identifier of payment
   *
   * @return paymentId
   */
  @ApiModelProperty(value = "Xero Identifier of payment")
  /**
   * Xero Identifier of payment
   *
   * @return paymentId UUID
   */
  public UUID getPaymentId() {
    return paymentId;
  }

  /**
   * Xero Identifier of payment
   *
   * @param paymentId UUID
   */
  public void setPaymentId(UUID paymentId) {
    this.paymentId = paymentId;
  }

  /**
   * Xero Identifier of batch payment. Present if the payment was created as part of a batch.
   *
   * @param batchPaymentId UUID
   * @return PaymentResponse
   */
  public PaymentResponse batchPaymentId(UUID batchPaymentId) {
    this.batchPaymentId = batchPaymentId;
    return this;
  }

  /**
   * Xero Identifier of batch payment. Present if the payment was created as part of a batch.
   *
   * @return batchPaymentId
   */
  @ApiModelProperty(
      value =
          "Xero Identifier of batch payment. Present if the payment was created as part of a"
              + " batch.")
  /**
   * Xero Identifier of batch payment. Present if the payment was created as part of a batch.
   *
   * @return batchPaymentId UUID
   */
  public UUID getBatchPaymentId() {
    return batchPaymentId;
  }

  /**
   * Xero Identifier of batch payment. Present if the payment was created as part of a batch.
   *
   * @param batchPaymentId UUID
   */
  public void setBatchPaymentId(UUID batchPaymentId) {
    this.batchPaymentId = batchPaymentId;
  }

  /**
   * Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06
   *
   * @param date LocalDate
   * @return PaymentResponse
   */
  public PaymentResponse date(LocalDate date) {
    this.date = date;
    return this;
  }

  /**
   * Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06
   *
   * @return date
   */
  @ApiModelProperty(value = "Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06")
  /**
   * Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06
   *
   * @return date LocalDate
   */
  public LocalDate getDate() {
    return date;
  }

  /**
   * Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06
   *
   * @param date LocalDate
   */
  public void setDate(LocalDate date) {
    this.date = date;
  }

  /**
   * The amount of the payment
   *
   * @param amount Double
   * @return PaymentResponse
   */
  public PaymentResponse amount(Double amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The amount of the payment
   *
   * @return amount
   */
  @ApiModelProperty(value = "The amount of the payment")
  /**
   * The amount of the payment
   *
   * @return amount Double
   */
  public Double getAmount() {
    return amount;
  }

  /**
   * The amount of the payment
   *
   * @param amount Double
   */
  public void setAmount(Double amount) {
    this.amount = amount;
  }

  /**
   * The bank amount of the payment
   *
   * @param bankAmount Double
   * @return PaymentResponse
   */
  public PaymentResponse bankAmount(Double bankAmount) {
    this.bankAmount = bankAmount;
    return this;
  }

  /**
   * The bank amount of the payment
   *
   * @return bankAmount
   */
  @ApiModelProperty(value = "The bank amount of the payment")
  /**
   * The bank amount of the payment
   *
   * @return bankAmount Double
   */
  public Double getBankAmount() {
    return bankAmount;
  }

  /**
   * The bank amount of the payment
   *
   * @param bankAmount Double
   */
  public void setBankAmount(Double bankAmount) {
    this.bankAmount = bankAmount;
  }

  /**
   * Exchange rate when payment is received. Only used for non base currency invoices and credit
   * notes e.g. 0.7500
   *
   * @param currencyRate Double
   * @return PaymentResponse
   */
  public PaymentResponse currencyRate(Double currencyRate) {
    this.currencyRate = currencyRate;
    return this;
  }

  /**
   * Exchange rate when payment is received. Only used for non base currency invoices and credit
   * notes e.g. 0.7500
   *
   * @return currencyRate
   */
  @ApiModelProperty(
      value =
          "Exchange rate when payment is received. Only used for non base currency invoices and"
              + " credit notes e.g. 0.7500")
  /**
   * Exchange rate when payment is received. Only used for non base currency invoices and credit
   * notes e.g. 0.7500
   *
   * @return currencyRate Double
   */
  public Double getCurrencyRate() {
    return currencyRate;
  }

  /**
   * Exchange rate when payment is received. Only used for non base currency invoices and credit
   * notes e.g. 0.7500
   *
   * @param currencyRate Double
   */
  public void setCurrencyRate(Double currencyRate) {
    this.currencyRate = currencyRate;
  }

  /**
   * invoice
   *
   * @param invoice InvoiceResponse
   * @return PaymentResponse
   */
  public PaymentResponse invoice(InvoiceResponse invoice) {
    this.invoice = invoice;
    return this;
  }

  /**
   * Get invoice
   *
   * @return invoice
   */
  @ApiModelProperty(value = "")
  /**
   * invoice
   *
   * @return invoice InvoiceResponse
   */
  public InvoiceResponse getInvoice() {
    return invoice;
  }

  /**
   * invoice
   *
   * @param invoice InvoiceResponse
   */
  public void setInvoice(InvoiceResponse invoice) {
    this.invoice = invoice;
  }

  /**
   * creditNote
   *
   * @param creditNote CreditNoteResponse
   * @return PaymentResponse
   */
  public PaymentResponse creditNote(CreditNoteResponse creditNote) {
    this.creditNote = creditNote;
    return this;
  }

  /**
   * Get creditNote
   *
   * @return creditNote
   */
  @ApiModelProperty(value = "")
  /**
   * creditNote
   *
   * @return creditNote CreditNoteResponse
   */
  public CreditNoteResponse getCreditNote() {
    return creditNote;
  }

  /**
   * creditNote
   *
   * @param creditNote CreditNoteResponse
   */
  public void setCreditNote(CreditNoteResponse creditNote) {
    this.creditNote = creditNote;
  }

  /**
   * prepayment
   *
   * @param prepayment PrepaymentResponse
   * @return PaymentResponse
   */
  public PaymentResponse prepayment(PrepaymentResponse prepayment) {
    this.prepayment = prepayment;
    return this;
  }

  /**
   * Get prepayment
   *
   * @return prepayment
   */
  @ApiModelProperty(value = "")
  /**
   * prepayment
   *
   * @return prepayment PrepaymentResponse
   */
  public PrepaymentResponse getPrepayment() {
    return prepayment;
  }

  /**
   * prepayment
   *
   * @param prepayment PrepaymentResponse
   */
  public void setPrepayment(PrepaymentResponse prepayment) {
    this.prepayment = prepayment;
  }

  /**
   * overpayment
   *
   * @param overpayment OverpaymentResponse
   * @return PaymentResponse
   */
  public PaymentResponse overpayment(OverpaymentResponse overpayment) {
    this.overpayment = overpayment;
    return this;
  }

  /**
   * Get overpayment
   *
   * @return overpayment
   */
  @ApiModelProperty(value = "")
  /**
   * overpayment
   *
   * @return overpayment OverpaymentResponse
   */
  public OverpaymentResponse getOverpayment() {
    return overpayment;
  }

  /**
   * overpayment
   *
   * @param overpayment OverpaymentResponse
   */
  public void setOverpayment(OverpaymentResponse overpayment) {
    this.overpayment = overpayment;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentResponse paymentResponse = (PaymentResponse) o;
    return Objects.equals(this.paymentId, paymentResponse.paymentId)
        && Objects.equals(this.batchPaymentId, paymentResponse.batchPaymentId)
        && Objects.equals(this.date, paymentResponse.date)
        && Objects.equals(this.amount, paymentResponse.amount)
        && Objects.equals(this.bankAmount, paymentResponse.bankAmount)
        && Objects.equals(this.currencyRate, paymentResponse.currencyRate)
        && Objects.equals(this.invoice, paymentResponse.invoice)
        && Objects.equals(this.creditNote, paymentResponse.creditNote)
        && Objects.equals(this.prepayment, paymentResponse.prepayment)
        && Objects.equals(this.overpayment, paymentResponse.overpayment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        paymentId,
        batchPaymentId,
        date,
        amount,
        bankAmount,
        currencyRate,
        invoice,
        creditNote,
        prepayment,
        overpayment);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentResponse {\n");
    sb.append("    paymentId: ").append(toIndentedString(paymentId)).append("\n");
    sb.append("    batchPaymentId: ").append(toIndentedString(batchPaymentId)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    bankAmount: ").append(toIndentedString(bankAmount)).append("\n");
    sb.append("    currencyRate: ").append(toIndentedString(currencyRate)).append("\n");
    sb.append("    invoice: ").append(toIndentedString(invoice)).append("\n");
    sb.append("    creditNote: ").append(toIndentedString(creditNote)).append("\n");
    sb.append("    prepayment: ").append(toIndentedString(prepayment)).append("\n");
    sb.append("    overpayment: ").append(toIndentedString(overpayment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
