/*
 * Xero Payroll AU API
 * This is the Xero Payroll API for orgs in Australia region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** Account */
public class Account {
  StringUtil util = new StringUtil();

  @JsonProperty("AccountID")
  private UUID accountID;

  @JsonProperty("Type")
  private AccountType type;

  @JsonProperty("Code")
  private String code;

  @JsonProperty("Name")
  private String name;
  /**
   * Xero identifier for accounts
   *
   * @param accountID UUID
   * @return Account
   */
  public Account accountID(UUID accountID) {
    this.accountID = accountID;
    return this;
  }

  /**
   * Xero identifier for accounts
   *
   * @return accountID
   */
  @ApiModelProperty(
      example = "c56b19ef-75bf-45e8-98a4-e699a96609f7",
      value = "Xero identifier for accounts")
  /**
   * Xero identifier for accounts
   *
   * @return accountID UUID
   */
  public UUID getAccountID() {
    return accountID;
  }

  /**
   * Xero identifier for accounts
   *
   * @param accountID UUID
   */
  public void setAccountID(UUID accountID) {
    this.accountID = accountID;
  }

  /**
   * type
   *
   * @param type AccountType
   * @return Account
   */
  public Account type(AccountType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   *
   * @return type
   */
  @ApiModelProperty(value = "")
  /**
   * type
   *
   * @return type AccountType
   */
  public AccountType getType() {
    return type;
  }

  /**
   * type
   *
   * @param type AccountType
   */
  public void setType(AccountType type) {
    this.type = type;
  }

  /**
   * Customer defined account code
   *
   * @param code String
   * @return Account
   */
  public Account code(String code) {
    this.code = code;
    return this;
  }

  /**
   * Customer defined account code
   *
   * @return code
   */
  @ApiModelProperty(example = "420", value = "Customer defined account code")
  /**
   * Customer defined account code
   *
   * @return code String
   */
  public String getCode() {
    return code;
  }

  /**
   * Customer defined account code
   *
   * @param code String
   */
  public void setCode(String code) {
    this.code = code;
  }

  /**
   * Name of account
   *
   * @param name String
   * @return Account
   */
  public Account name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Name of account
   *
   * @return name
   */
  @ApiModelProperty(example = "General expenses", value = "Name of account")
  /**
   * Name of account
   *
   * @return name String
   */
  public String getName() {
    return name;
  }

  /**
   * Name of account
   *
   * @param name String
   */
  public void setName(String name) {
    this.name = name;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Account account = (Account) o;
    return Objects.equals(this.accountID, account.accountID)
        && Objects.equals(this.type, account.type)
        && Objects.equals(this.code, account.code)
        && Objects.equals(this.name, account.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountID, type, code, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Account {\n");
    sb.append("    accountID: ").append(toIndentedString(accountID)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
