/*
 * Xero Payroll NZ
 * This is the Xero Payroll API for orgs in the NZ region.
 *
 * The version of the OpenAPI document: 2.28.1
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMethods;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.payrollnz.Benefit;
import com.xero.models.payrollnz.Deduction;
import com.xero.models.payrollnz.DeductionObject;
import com.xero.models.payrollnz.Deductions;
import com.xero.models.payrollnz.EarningsRate;
import com.xero.models.payrollnz.EarningsRateObject;
import com.xero.models.payrollnz.EarningsRates;
import com.xero.models.payrollnz.EarningsTemplate;
import com.xero.models.payrollnz.EarningsTemplateObject;
import com.xero.models.payrollnz.Employee;
import com.xero.models.payrollnz.EmployeeEarningsTemplates;
import com.xero.models.payrollnz.EmployeeLeave;
import com.xero.models.payrollnz.EmployeeLeaveBalances;
import com.xero.models.payrollnz.EmployeeLeaveObject;
import com.xero.models.payrollnz.EmployeeLeaveSetup;
import com.xero.models.payrollnz.EmployeeLeaveSetupObject;
import com.xero.models.payrollnz.EmployeeLeaveType;
import com.xero.models.payrollnz.EmployeeLeaveTypeObject;
import com.xero.models.payrollnz.EmployeeLeaveTypes;
import com.xero.models.payrollnz.EmployeeLeaves;
import com.xero.models.payrollnz.EmployeeObject;
import com.xero.models.payrollnz.EmployeeOpeningBalance;
import com.xero.models.payrollnz.EmployeeOpeningBalancesObject;
import com.xero.models.payrollnz.EmployeePayTemplates;
import com.xero.models.payrollnz.EmployeeTax;
import com.xero.models.payrollnz.EmployeeTaxObject;
import com.xero.models.payrollnz.Employees;
import com.xero.models.payrollnz.Employment;
import com.xero.models.payrollnz.EmploymentObject;
import com.xero.models.payrollnz.LeavePeriods;
import com.xero.models.payrollnz.LeaveType;
import com.xero.models.payrollnz.LeaveTypeObject;
import com.xero.models.payrollnz.LeaveTypes;
import com.xero.models.payrollnz.PayRun;
import com.xero.models.payrollnz.PayRunCalendar;
import com.xero.models.payrollnz.PayRunCalendarObject;
import com.xero.models.payrollnz.PayRunCalendars;
import com.xero.models.payrollnz.PayRunObject;
import com.xero.models.payrollnz.PayRuns;
import com.xero.models.payrollnz.PaySlip;
import com.xero.models.payrollnz.PaySlipObject;
import com.xero.models.payrollnz.PaySlips;
import com.xero.models.payrollnz.PaymentMethod;
import com.xero.models.payrollnz.PaymentMethodObject;
import com.xero.models.payrollnz.Reimbursement;
import com.xero.models.payrollnz.ReimbursementObject;
import com.xero.models.payrollnz.Reimbursements;
import com.xero.models.payrollnz.SalaryAndWage;
import com.xero.models.payrollnz.SalaryAndWageObject;
import com.xero.models.payrollnz.SalaryAndWages;
import com.xero.models.payrollnz.Settings;
import com.xero.models.payrollnz.StatutoryDeductionObject;
import com.xero.models.payrollnz.StatutoryDeductions;
import com.xero.models.payrollnz.SuperannuationObject;
import com.xero.models.payrollnz.Superannuations;
import com.xero.models.payrollnz.Timesheet;
import com.xero.models.payrollnz.TimesheetLine;
import com.xero.models.payrollnz.TimesheetLineObject;
import com.xero.models.payrollnz.TimesheetObject;
import com.xero.models.payrollnz.Timesheets;
import com.xero.models.payrollnz.TrackingCategories;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;

/** PayrollNzApi has methods for interacting with all endpoints in the API set */
public class PayrollNzApi {
  private ApiClient apiClient;
  private static PayrollNzApi instance = null;
  private String userAgent = "Default";
  private String version = "4.21.0";
  static final Logger logger = LoggerFactory.getLogger(PayrollNzApi.class);

  /** PayrollNzApi */
  public PayrollNzApi() {
    this(new ApiClient());
  }

  /**
   * PayrollNzApi getInstance
   *
   * @param apiClient ApiClient pass into the new instance of this class
   * @return instance of this class
   */
  public static PayrollNzApi getInstance(ApiClient apiClient) {
    if (instance == null) {
      instance = new PayrollNzApi(apiClient);
    }
    return instance;
  }

  /**
   * PayrollNzApi
   *
   * @param apiClient ApiClient pass into the new instance of this class
   */
  public PayrollNzApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * get ApiClient
   *
   * @return apiClient the current ApiClient
   */
  public ApiClient getApiClient() {
    return apiClient;
  }

  /**
   * set ApiClient
   *
   * @param apiClient ApiClient pass into the new instance of this class
   */
  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * set user agent
   *
   * @param userAgent string to override the user agent
   */
  public void setUserAgent(String userAgent) {
    this.userAgent = userAgent;
  }

  /**
   * get user agent
   *
   * @return String of user agent
   */
  public String getUserAgent() {
    return this.userAgent + " [Xero-Java-" + this.version + "]";
  }

  /**
   * Approves a timesheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param accessToken Authorization token for user set in header of each request
   * @return TimesheetObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TimesheetObject approveTimesheet(String accessToken, String xeroTenantId, UUID timesheetID)
      throws IOException {
    try {
      TypeReference<TimesheetObject> typeRef = new TypeReference<TimesheetObject>() {};
      HttpResponse response =
          approveTimesheetForHttpResponse(accessToken, xeroTenantId, timesheetID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : approveTimesheet -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<TimesheetObject> errorTypeRef = new TypeReference<TimesheetObject>() {};
        TimesheetObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "TimesheetObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Approves a timesheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse approveTimesheetForHttpResponse(
      String accessToken, String xeroTenantId, UUID timesheetID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling approveTimesheet");
    } // verify the required parameter 'timesheetID' is set
    if (timesheetID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetID' when calling approveTimesheet");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling approveTimesheet");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("TimesheetID", timesheetID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Timesheets/{TimesheetID}/Approve");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a new deduction for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param deduction The deduction parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return DeductionObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public DeductionObject createDeduction(
      String accessToken, String xeroTenantId, Deduction deduction) throws IOException {
    try {
      TypeReference<DeductionObject> typeRef = new TypeReference<DeductionObject>() {};
      HttpResponse response = createDeductionForHttpResponse(accessToken, xeroTenantId, deduction);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createDeduction -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<DeductionObject> errorTypeRef = new TypeReference<DeductionObject>() {};
        DeductionObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "DeductionObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new deduction for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param deduction The deduction parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createDeductionForHttpResponse(
      String accessToken, String xeroTenantId, Deduction deduction) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createDeduction");
    } // verify the required parameter 'deduction' is set
    if (deduction == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'deduction' when calling createDeduction");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createDeduction");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Deductions");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(deduction);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a new earnings rate
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param earningsRate The earningsRate parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EarningsRateObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EarningsRateObject createEarningsRate(
      String accessToken, String xeroTenantId, EarningsRate earningsRate) throws IOException {
    try {
      TypeReference<EarningsRateObject> typeRef = new TypeReference<EarningsRateObject>() {};
      HttpResponse response =
          createEarningsRateForHttpResponse(accessToken, xeroTenantId, earningsRate);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEarningsRate -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EarningsRateObject> errorTypeRef = new TypeReference<EarningsRateObject>() {};
        EarningsRateObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EarningsRateObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new earnings rate
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param earningsRate The earningsRate parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEarningsRateForHttpResponse(
      String accessToken, String xeroTenantId, EarningsRate earningsRate) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createEarningsRate");
    } // verify the required parameter 'earningsRate' is set
    if (earningsRate == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'earningsRate' when calling createEarningsRate");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createEarningsRate");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/EarningsRates");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(earningsRate);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates an employees
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employee The employee parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeObject createEmployee(String accessToken, String xeroTenantId, Employee employee)
      throws IOException {
    try {
      TypeReference<EmployeeObject> typeRef = new TypeReference<EmployeeObject>() {};
      HttpResponse response = createEmployeeForHttpResponse(accessToken, xeroTenantId, employee);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEmployee -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeObject> errorTypeRef = new TypeReference<EmployeeObject>() {};
        EmployeeObject object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an employees
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employee The employee parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEmployeeForHttpResponse(
      String accessToken, String xeroTenantId, Employee employee) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createEmployee");
    } // verify the required parameter 'employee' is set
    if (employee == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employee' when calling createEmployee");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createEmployee");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Employees");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(employee);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates earnings template records for an employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param earningsTemplate The earningsTemplate parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EarningsTemplateObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EarningsTemplateObject createEmployeeEarningsTemplate(
      String accessToken, String xeroTenantId, UUID employeeID, EarningsTemplate earningsTemplate)
      throws IOException {
    try {
      TypeReference<EarningsTemplateObject> typeRef =
          new TypeReference<EarningsTemplateObject>() {};
      HttpResponse response =
          createEmployeeEarningsTemplateForHttpResponse(
              accessToken, xeroTenantId, employeeID, earningsTemplate);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEmployeeEarningsTemplate -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EarningsTemplateObject> errorTypeRef =
            new TypeReference<EarningsTemplateObject>() {};
        EarningsTemplateObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(
            e.getStatusCode(), "EarningsTemplateObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates earnings template records for an employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param earningsTemplate The earningsTemplate parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEmployeeEarningsTemplateForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, EarningsTemplate earningsTemplate)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createEmployeeEarningsTemplate");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling"
              + " createEmployeeEarningsTemplate");
    } // verify the required parameter 'earningsTemplate' is set
    if (earningsTemplate == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'earningsTemplate' when calling"
              + " createEmployeeEarningsTemplate");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createEmployeeEarningsTemplate");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Employees/{EmployeeID}/PayTemplates/earnings");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(earningsTemplate);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates leave records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employeeLeave The employeeLeave parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeLeaveObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeLeaveObject createEmployeeLeave(
      String accessToken, String xeroTenantId, UUID employeeID, EmployeeLeave employeeLeave)
      throws IOException {
    try {
      TypeReference<EmployeeLeaveObject> typeRef = new TypeReference<EmployeeLeaveObject>() {};
      HttpResponse response =
          createEmployeeLeaveForHttpResponse(accessToken, xeroTenantId, employeeID, employeeLeave);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEmployeeLeave -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeLeaveObject> errorTypeRef =
            new TypeReference<EmployeeLeaveObject>() {};
        EmployeeLeaveObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeLeaveObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates leave records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employeeLeave The employeeLeave parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEmployeeLeaveForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, EmployeeLeave employeeLeave)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createEmployeeLeave");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling createEmployeeLeave");
    } // verify the required parameter 'employeeLeave' is set
    if (employeeLeave == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeLeave' when calling createEmployeeLeave");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createEmployeeLeave");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/Leave");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(employeeLeave);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a leave set-up for a specific employee. This is required before viewing, configuring
   * and requesting leave for an employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employeeLeaveSetup The employeeLeaveSetup parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeLeaveSetupObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeLeaveSetupObject createEmployeeLeaveSetup(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      EmployeeLeaveSetup employeeLeaveSetup)
      throws IOException {
    try {
      TypeReference<EmployeeLeaveSetupObject> typeRef =
          new TypeReference<EmployeeLeaveSetupObject>() {};
      HttpResponse response =
          createEmployeeLeaveSetupForHttpResponse(
              accessToken, xeroTenantId, employeeID, employeeLeaveSetup);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEmployeeLeaveSetup -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeLeaveSetupObject> errorTypeRef =
            new TypeReference<EmployeeLeaveSetupObject>() {};
        EmployeeLeaveSetupObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(
            e.getStatusCode(), "EmployeeLeaveSetupObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a leave set-up for a specific employee. This is required before viewing, configuring
   * and requesting leave for an employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employeeLeaveSetup The employeeLeaveSetup parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEmployeeLeaveSetupForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      EmployeeLeaveSetup employeeLeaveSetup)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createEmployeeLeaveSetup");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling createEmployeeLeaveSetup");
    } // verify the required parameter 'employeeLeaveSetup' is set
    if (employeeLeaveSetup == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeLeaveSetup' when calling"
              + " createEmployeeLeaveSetup");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createEmployeeLeaveSetup");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/leaveSetup");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(employeeLeaveSetup);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates leave type records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employeeLeaveType The employeeLeaveType parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeLeaveTypeObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeLeaveTypeObject createEmployeeLeaveType(
      String accessToken, String xeroTenantId, UUID employeeID, EmployeeLeaveType employeeLeaveType)
      throws IOException {
    try {
      TypeReference<EmployeeLeaveTypeObject> typeRef =
          new TypeReference<EmployeeLeaveTypeObject>() {};
      HttpResponse response =
          createEmployeeLeaveTypeForHttpResponse(
              accessToken, xeroTenantId, employeeID, employeeLeaveType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEmployeeLeaveType -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeLeaveTypeObject> errorTypeRef =
            new TypeReference<EmployeeLeaveTypeObject>() {};
        EmployeeLeaveTypeObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(
            e.getStatusCode(), "EmployeeLeaveTypeObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates leave type records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employeeLeaveType The employeeLeaveType parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEmployeeLeaveTypeForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, EmployeeLeaveType employeeLeaveType)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createEmployeeLeaveType");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling createEmployeeLeaveType");
    } // verify the required parameter 'employeeLeaveType' is set
    if (employeeLeaveType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeLeaveType' when calling"
              + " createEmployeeLeaveType");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createEmployeeLeaveType");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/LeaveTypes");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(employeeLeaveType);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates opening balances for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employeeOpeningBalance The employeeOpeningBalance parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeOpeningBalancesObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeOpeningBalancesObject createEmployeeOpeningBalances(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      List<EmployeeOpeningBalance> employeeOpeningBalance)
      throws IOException {
    try {
      TypeReference<EmployeeOpeningBalancesObject> typeRef =
          new TypeReference<EmployeeOpeningBalancesObject>() {};
      HttpResponse response =
          createEmployeeOpeningBalancesForHttpResponse(
              accessToken, xeroTenantId, employeeID, employeeOpeningBalance);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEmployeeOpeningBalances -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeOpeningBalancesObject> errorTypeRef =
            new TypeReference<EmployeeOpeningBalancesObject>() {};
        EmployeeOpeningBalancesObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(
            e.getStatusCode(), "EmployeeOpeningBalancesObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates opening balances for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employeeOpeningBalance The employeeOpeningBalance parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEmployeeOpeningBalancesForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      List<EmployeeOpeningBalance> employeeOpeningBalance)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createEmployeeOpeningBalances");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling createEmployeeOpeningBalances");
    } // verify the required parameter 'employeeOpeningBalance' is set
    if (employeeOpeningBalance == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeOpeningBalance' when calling"
              + " createEmployeeOpeningBalances");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createEmployeeOpeningBalances");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/openingBalances");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(employeeOpeningBalance);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a payment method for an employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param paymentMethod The paymentMethod parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return PaymentMethodObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PaymentMethodObject createEmployeePaymentMethod(
      String accessToken, String xeroTenantId, UUID employeeID, PaymentMethod paymentMethod)
      throws IOException {
    try {
      TypeReference<PaymentMethodObject> typeRef = new TypeReference<PaymentMethodObject>() {};
      HttpResponse response =
          createEmployeePaymentMethodForHttpResponse(
              accessToken, xeroTenantId, employeeID, paymentMethod);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEmployeePaymentMethod -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PaymentMethodObject> errorTypeRef =
            new TypeReference<PaymentMethodObject>() {};
        PaymentMethodObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PaymentMethodObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a payment method for an employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param paymentMethod The paymentMethod parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEmployeePaymentMethodForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, PaymentMethod paymentMethod)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createEmployeePaymentMethod");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling createEmployeePaymentMethod");
    } // verify the required parameter 'paymentMethod' is set
    if (paymentMethod == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paymentMethod' when calling"
              + " createEmployeePaymentMethod");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createEmployeePaymentMethod");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/PaymentMethods");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(paymentMethod);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates an employee salary and wage record
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param salaryAndWage The salaryAndWage parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return SalaryAndWageObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public SalaryAndWageObject createEmployeeSalaryAndWage(
      String accessToken, String xeroTenantId, UUID employeeID, SalaryAndWage salaryAndWage)
      throws IOException {
    try {
      TypeReference<SalaryAndWageObject> typeRef = new TypeReference<SalaryAndWageObject>() {};
      HttpResponse response =
          createEmployeeSalaryAndWageForHttpResponse(
              accessToken, xeroTenantId, employeeID, salaryAndWage);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEmployeeSalaryAndWage -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<SalaryAndWageObject> errorTypeRef =
            new TypeReference<SalaryAndWageObject>() {};
        SalaryAndWageObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "SalaryAndWageObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an employee salary and wage record
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param salaryAndWage The salaryAndWage parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEmployeeSalaryAndWageForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, SalaryAndWage salaryAndWage)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createEmployeeSalaryAndWage");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling createEmployeeSalaryAndWage");
    } // verify the required parameter 'salaryAndWage' is set
    if (salaryAndWage == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'salaryAndWage' when calling"
              + " createEmployeeSalaryAndWage");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createEmployeeSalaryAndWage");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/SalaryAndWages");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(salaryAndWage);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates an employment detail for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employment The employment parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EmploymentObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmploymentObject createEmployment(
      String accessToken, String xeroTenantId, UUID employeeID, Employment employment)
      throws IOException {
    try {
      TypeReference<EmploymentObject> typeRef = new TypeReference<EmploymentObject>() {};
      HttpResponse response =
          createEmploymentForHttpResponse(accessToken, xeroTenantId, employeeID, employment);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createEmployment -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmploymentObject> errorTypeRef = new TypeReference<EmploymentObject>() {};
        EmploymentObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmploymentObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an employment detail for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employment The employment parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createEmploymentForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, Employment employment)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createEmployment");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling createEmployment");
    } // verify the required parameter 'employment' is set
    if (employment == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employment' when calling createEmployment");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createEmployment");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/Employment");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(employment);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a new leave type
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param leaveType The leaveType parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return LeaveTypeObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public LeaveTypeObject createLeaveType(
      String accessToken, String xeroTenantId, LeaveType leaveType) throws IOException {
    try {
      TypeReference<LeaveTypeObject> typeRef = new TypeReference<LeaveTypeObject>() {};
      HttpResponse response = createLeaveTypeForHttpResponse(accessToken, xeroTenantId, leaveType);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createLeaveType -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<LeaveTypeObject> errorTypeRef = new TypeReference<LeaveTypeObject>() {};
        LeaveTypeObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "LeaveTypeObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new leave type
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param leaveType The leaveType parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createLeaveTypeForHttpResponse(
      String accessToken, String xeroTenantId, LeaveType leaveType) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createLeaveType");
    } // verify the required parameter 'leaveType' is set
    if (leaveType == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'leaveType' when calling createLeaveType");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createLeaveType");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/LeaveTypes");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(leaveType);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates multiple employee earnings template records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param earningsTemplate The earningsTemplate parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeEarningsTemplates
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeEarningsTemplates createMultipleEmployeeEarningsTemplate(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      List<EarningsTemplate> earningsTemplate)
      throws IOException {
    try {
      TypeReference<EmployeeEarningsTemplates> typeRef =
          new TypeReference<EmployeeEarningsTemplates>() {};
      HttpResponse response =
          createMultipleEmployeeEarningsTemplateForHttpResponse(
              accessToken, xeroTenantId, employeeID, earningsTemplate);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createMultipleEmployeeEarningsTemplate -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeEarningsTemplates> errorTypeRef =
            new TypeReference<EmployeeEarningsTemplates>() {};
        EmployeeEarningsTemplates object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(
            e.getStatusCode(), "EmployeeEarningsTemplates", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates multiple employee earnings template records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param earningsTemplate The earningsTemplate parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createMultipleEmployeeEarningsTemplateForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      List<EarningsTemplate> earningsTemplate)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " createMultipleEmployeeEarningsTemplate");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling"
              + " createMultipleEmployeeEarningsTemplate");
    } // verify the required parameter 'earningsTemplate' is set
    if (earningsTemplate == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'earningsTemplate' when calling"
              + " createMultipleEmployeeEarningsTemplate");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " createMultipleEmployeeEarningsTemplate");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/paytemplateearnings");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(earningsTemplate);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a pay run
   *
   * <p><b>200</b> - created payrun results
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payRun The payRun parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return PayRunObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PayRunObject createPayRun(String accessToken, String xeroTenantId, PayRun payRun)
      throws IOException {
    try {
      TypeReference<PayRunObject> typeRef = new TypeReference<PayRunObject>() {};
      HttpResponse response = createPayRunForHttpResponse(accessToken, xeroTenantId, payRun);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPayRun -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PayRunObject> errorTypeRef = new TypeReference<PayRunObject>() {};
        PayRunObject object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PayRunObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a pay run
   *
   * <p><b>200</b> - created payrun results
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payRun The payRun parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPayRunForHttpResponse(
      String accessToken, String xeroTenantId, PayRun payRun) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createPayRun");
    } // verify the required parameter 'payRun' is set
    if (payRun == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payRun' when calling createPayRun");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createPayRun");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PayRuns");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(payRun);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a new payrun calendar
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payRunCalendar The payRunCalendar parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return PayRunCalendarObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PayRunCalendarObject createPayRunCalendar(
      String accessToken, String xeroTenantId, PayRunCalendar payRunCalendar) throws IOException {
    try {
      TypeReference<PayRunCalendarObject> typeRef = new TypeReference<PayRunCalendarObject>() {};
      HttpResponse response =
          createPayRunCalendarForHttpResponse(accessToken, xeroTenantId, payRunCalendar);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createPayRunCalendar -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PayRunCalendarObject> errorTypeRef =
            new TypeReference<PayRunCalendarObject>() {};
        PayRunCalendarObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PayRunCalendarObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new payrun calendar
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payRunCalendar The payRunCalendar parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createPayRunCalendarForHttpResponse(
      String accessToken, String xeroTenantId, PayRunCalendar payRunCalendar) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createPayRunCalendar");
    } // verify the required parameter 'payRunCalendar' is set
    if (payRunCalendar == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payRunCalendar' when calling createPayRunCalendar");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createPayRunCalendar");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PayRunCalendars");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(payRunCalendar);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a new reimbursement
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param reimbursement The reimbursement parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return ReimbursementObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ReimbursementObject createReimbursement(
      String accessToken, String xeroTenantId, Reimbursement reimbursement) throws IOException {
    try {
      TypeReference<ReimbursementObject> typeRef = new TypeReference<ReimbursementObject>() {};
      HttpResponse response =
          createReimbursementForHttpResponse(accessToken, xeroTenantId, reimbursement);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createReimbursement -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<ReimbursementObject> errorTypeRef =
            new TypeReference<ReimbursementObject>() {};
        ReimbursementObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "ReimbursementObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new reimbursement
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param reimbursement The reimbursement parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createReimbursementForHttpResponse(
      String accessToken, String xeroTenantId, Reimbursement reimbursement) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createReimbursement");
    } // verify the required parameter 'reimbursement' is set
    if (reimbursement == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'reimbursement' when calling createReimbursement");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createReimbursement");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Reimbursements");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(reimbursement);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a new superannuation
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param benefit The benefit parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return SuperannuationObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public SuperannuationObject createSuperannuation(
      String accessToken, String xeroTenantId, Benefit benefit) throws IOException {
    try {
      TypeReference<SuperannuationObject> typeRef = new TypeReference<SuperannuationObject>() {};
      HttpResponse response =
          createSuperannuationForHttpResponse(accessToken, xeroTenantId, benefit);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createSuperannuation -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<SuperannuationObject> errorTypeRef =
            new TypeReference<SuperannuationObject>() {};
        SuperannuationObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "SuperannuationObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new superannuation
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param benefit The benefit parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createSuperannuationForHttpResponse(
      String accessToken, String xeroTenantId, Benefit benefit) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createSuperannuation");
    } // verify the required parameter 'benefit' is set
    if (benefit == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'benefit' when calling createSuperannuation");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createSuperannuation");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Superannuations");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(benefit);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates a new timesheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheet The timesheet parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return TimesheetObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TimesheetObject createTimesheet(
      String accessToken, String xeroTenantId, Timesheet timesheet) throws IOException {
    try {
      TypeReference<TimesheetObject> typeRef = new TypeReference<TimesheetObject>() {};
      HttpResponse response = createTimesheetForHttpResponse(accessToken, xeroTenantId, timesheet);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createTimesheet -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<TimesheetObject> errorTypeRef = new TypeReference<TimesheetObject>() {};
        TimesheetObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "TimesheetObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates a new timesheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheet The timesheet parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createTimesheetForHttpResponse(
      String accessToken, String xeroTenantId, Timesheet timesheet) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createTimesheet");
    } // verify the required parameter 'timesheet' is set
    if (timesheet == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheet' when calling createTimesheet");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createTimesheet");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Timesheets");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(timesheet);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Create a new timesheet line for a specific time sheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param timesheetLine The timesheetLine parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return TimesheetLineObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TimesheetLineObject createTimesheetLine(
      String accessToken, String xeroTenantId, UUID timesheetID, TimesheetLine timesheetLine)
      throws IOException {
    try {
      TypeReference<TimesheetLineObject> typeRef = new TypeReference<TimesheetLineObject>() {};
      HttpResponse response =
          createTimesheetLineForHttpResponse(accessToken, xeroTenantId, timesheetID, timesheetLine);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : createTimesheetLine -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<TimesheetLineObject> errorTypeRef =
            new TypeReference<TimesheetLineObject>() {};
        TimesheetLineObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "TimesheetLineObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Create a new timesheet line for a specific time sheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param timesheetLine The timesheetLine parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse createTimesheetLineForHttpResponse(
      String accessToken, String xeroTenantId, UUID timesheetID, TimesheetLine timesheetLine)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling createTimesheetLine");
    } // verify the required parameter 'timesheetID' is set
    if (timesheetID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetID' when calling createTimesheetLine");
    } // verify the required parameter 'timesheetLine' is set
    if (timesheetLine == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetLine' when calling createTimesheetLine");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling createTimesheetLine");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("TimesheetID", timesheetID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Timesheets/{TimesheetID}/Lines");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(timesheetLine);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes an employee&#39;s earnings template record
   *
   * <p><b>200</b> - deletion successful
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param payTemplateEarningID Id for single pay template earnings object
   * @param accessToken Authorization token for user set in header of each request
   * @return EarningsTemplateObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EarningsTemplateObject deleteEmployeeEarningsTemplate(
      String accessToken, String xeroTenantId, UUID employeeID, UUID payTemplateEarningID)
      throws IOException {
    try {
      TypeReference<EarningsTemplateObject> typeRef =
          new TypeReference<EarningsTemplateObject>() {};
      HttpResponse response =
          deleteEmployeeEarningsTemplateForHttpResponse(
              accessToken, xeroTenantId, employeeID, payTemplateEarningID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteEmployeeEarningsTemplate -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes an employee&#39;s earnings template record
   *
   * <p><b>200</b> - deletion successful
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param payTemplateEarningID Id for single pay template earnings object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteEmployeeEarningsTemplateForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, UUID payTemplateEarningID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " deleteEmployeeEarningsTemplate");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling"
              + " deleteEmployeeEarningsTemplate");
    } // verify the required parameter 'payTemplateEarningID' is set
    if (payTemplateEarningID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payTemplateEarningID' when calling"
              + " deleteEmployeeEarningsTemplate");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " deleteEmployeeEarningsTemplate");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);
    uriVariables.put("PayTemplateEarningID", payTemplateEarningID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/Employees/{EmployeeID}/PayTemplates/earnings/{PayTemplateEarningID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes a leave record for a specific employee
   *
   * <p><b>200</b> - successful response
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param leaveID Leave id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeLeaveObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeLeaveObject deleteEmployeeLeave(
      String accessToken, String xeroTenantId, UUID employeeID, UUID leaveID) throws IOException {
    try {
      TypeReference<EmployeeLeaveObject> typeRef = new TypeReference<EmployeeLeaveObject>() {};
      HttpResponse response =
          deleteEmployeeLeaveForHttpResponse(accessToken, xeroTenantId, employeeID, leaveID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteEmployeeLeave -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeLeaveObject> errorTypeRef =
            new TypeReference<EmployeeLeaveObject>() {};
        EmployeeLeaveObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeLeaveObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes a leave record for a specific employee
   *
   * <p><b>200</b> - successful response
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param leaveID Leave id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteEmployeeLeaveForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, UUID leaveID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteEmployeeLeave");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling deleteEmployeeLeave");
    } // verify the required parameter 'leaveID' is set
    if (leaveID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'leaveID' when calling deleteEmployeeLeave");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteEmployeeLeave");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);
    uriVariables.put("LeaveID", leaveID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/Leave/{LeaveID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes an employee&#39;s salary and wages record
   *
   * <p><b>200</b> - deletion successful
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param salaryAndWagesID Id for single salary and wages object
   * @param accessToken Authorization token for user set in header of each request
   * @return SalaryAndWageObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public SalaryAndWageObject deleteEmployeeSalaryAndWage(
      String accessToken, String xeroTenantId, UUID employeeID, UUID salaryAndWagesID)
      throws IOException {
    try {
      TypeReference<SalaryAndWageObject> typeRef = new TypeReference<SalaryAndWageObject>() {};
      HttpResponse response =
          deleteEmployeeSalaryAndWageForHttpResponse(
              accessToken, xeroTenantId, employeeID, salaryAndWagesID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteEmployeeSalaryAndWage -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes an employee&#39;s salary and wages record
   *
   * <p><b>200</b> - deletion successful
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param salaryAndWagesID Id for single salary and wages object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteEmployeeSalaryAndWageForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, UUID salaryAndWagesID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteEmployeeSalaryAndWage");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling deleteEmployeeSalaryAndWage");
    } // verify the required parameter 'salaryAndWagesID' is set
    if (salaryAndWagesID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'salaryAndWagesID' when calling"
              + " deleteEmployeeSalaryAndWage");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteEmployeeSalaryAndWage");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);
    uriVariables.put("SalaryAndWagesID", salaryAndWagesID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes a timesheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param accessToken Authorization token for user set in header of each request
   * @return TimesheetLine
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TimesheetLine deleteTimesheet(String accessToken, String xeroTenantId, UUID timesheetID)
      throws IOException {
    try {
      TypeReference<TimesheetLine> typeRef = new TypeReference<TimesheetLine>() {};
      HttpResponse response =
          deleteTimesheetForHttpResponse(accessToken, xeroTenantId, timesheetID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteTimesheet -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes a timesheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteTimesheetForHttpResponse(
      String accessToken, String xeroTenantId, UUID timesheetID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteTimesheet");
    } // verify the required parameter 'timesheetID' is set
    if (timesheetID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetID' when calling deleteTimesheet");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteTimesheet");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("TimesheetID", timesheetID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Timesheets/{TimesheetID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Deletes a timesheet line for a specific timesheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param timesheetLineID Identifier for the timesheet line
   * @param accessToken Authorization token for user set in header of each request
   * @return TimesheetLine
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TimesheetLine deleteTimesheetLine(
      String accessToken, String xeroTenantId, UUID timesheetID, UUID timesheetLineID)
      throws IOException {
    try {
      TypeReference<TimesheetLine> typeRef = new TypeReference<TimesheetLine>() {};
      HttpResponse response =
          deleteTimesheetLineForHttpResponse(
              accessToken, xeroTenantId, timesheetID, timesheetLineID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : deleteTimesheetLine -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Deletes a timesheet line for a specific timesheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param timesheetLineID Identifier for the timesheet line
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse deleteTimesheetLineForHttpResponse(
      String accessToken, String xeroTenantId, UUID timesheetID, UUID timesheetLineID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling deleteTimesheetLine");
    } // verify the required parameter 'timesheetID' is set
    if (timesheetID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetID' when calling deleteTimesheetLine");
    } // verify the required parameter 'timesheetLineID' is set
    if (timesheetLineID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetLineID' when calling deleteTimesheetLine");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling deleteTimesheetLine");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("TimesheetID", timesheetID);
    uriVariables.put("TimesheetLineID", timesheetLineID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("DELETE " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.DELETE, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a single deduction by using a unique deduction ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param deductionId Identifier for the deduction
   * @param accessToken Authorization token for user set in header of each request
   * @return DeductionObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public DeductionObject getDeduction(String accessToken, String xeroTenantId, UUID deductionId)
      throws IOException {
    try {
      TypeReference<DeductionObject> typeRef = new TypeReference<DeductionObject>() {};
      HttpResponse response = getDeductionForHttpResponse(accessToken, xeroTenantId, deductionId);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getDeduction -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<DeductionObject> errorTypeRef = new TypeReference<DeductionObject>() {};
        DeductionObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "DeductionObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a single deduction by using a unique deduction ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param deductionId Identifier for the deduction
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getDeductionForHttpResponse(
      String accessToken, String xeroTenantId, UUID deductionId) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getDeduction");
    } // verify the required parameter 'deductionId' is set
    if (deductionId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'deductionId' when calling getDeduction");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getDeduction");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("deductionId", deductionId);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Deductions/{deductionId}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves deductions for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return Deductions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Deductions getDeductions(String accessToken, String xeroTenantId, Integer page)
      throws IOException {
    try {
      TypeReference<Deductions> typeRef = new TypeReference<Deductions>() {};
      HttpResponse response = getDeductionsForHttpResponse(accessToken, xeroTenantId, page);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getDeductions -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<Deductions> errorTypeRef = new TypeReference<Deductions>() {};
        Deductions object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "Deductions", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves deductions for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getDeductionsForHttpResponse(
      String accessToken, String xeroTenantId, Integer page) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getDeductions");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getDeductions");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Deductions");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific earnings rates by using a unique earnings rate id
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param earningsRateID Identifier for the earnings rate
   * @param accessToken Authorization token for user set in header of each request
   * @return EarningsRateObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EarningsRateObject getEarningsRate(
      String accessToken, String xeroTenantId, UUID earningsRateID) throws IOException {
    try {
      TypeReference<EarningsRateObject> typeRef = new TypeReference<EarningsRateObject>() {};
      HttpResponse response =
          getEarningsRateForHttpResponse(accessToken, xeroTenantId, earningsRateID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEarningsRate -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EarningsRateObject> errorTypeRef = new TypeReference<EarningsRateObject>() {};
        EarningsRateObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EarningsRateObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific earnings rates by using a unique earnings rate id
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param earningsRateID Identifier for the earnings rate
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEarningsRateForHttpResponse(
      String accessToken, String xeroTenantId, UUID earningsRateID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEarningsRate");
    } // verify the required parameter 'earningsRateID' is set
    if (earningsRateID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'earningsRateID' when calling getEarningsRate");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEarningsRate");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EarningsRateID", earningsRateID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/EarningsRates/{EarningsRateID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves earnings rates
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return EarningsRates
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EarningsRates getEarningsRates(String accessToken, String xeroTenantId, Integer page)
      throws IOException {
    try {
      TypeReference<EarningsRates> typeRef = new TypeReference<EarningsRates>() {};
      HttpResponse response = getEarningsRatesForHttpResponse(accessToken, xeroTenantId, page);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEarningsRates -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EarningsRates> errorTypeRef = new TypeReference<EarningsRates>() {};
        EarningsRates object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EarningsRates", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves earnings rates
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEarningsRatesForHttpResponse(
      String accessToken, String xeroTenantId, Integer page) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEarningsRates");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEarningsRates");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/EarningsRates");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves an employees using a unique employee ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeObject getEmployee(String accessToken, String xeroTenantId, UUID employeeID)
      throws IOException {
    try {
      TypeReference<EmployeeObject> typeRef = new TypeReference<EmployeeObject>() {};
      HttpResponse response = getEmployeeForHttpResponse(accessToken, xeroTenantId, employeeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployee -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeObject> errorTypeRef = new TypeReference<EmployeeObject>() {};
        EmployeeObject object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves an employees using a unique employee ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeeForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployee");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployee");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployee");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves leave balances for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeLeaveBalances
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeLeaveBalances getEmployeeLeaveBalances(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    try {
      TypeReference<EmployeeLeaveBalances> typeRef = new TypeReference<EmployeeLeaveBalances>() {};
      HttpResponse response =
          getEmployeeLeaveBalancesForHttpResponse(accessToken, xeroTenantId, employeeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployeeLeaveBalances -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeLeaveBalances> errorTypeRef =
            new TypeReference<EmployeeLeaveBalances>() {};
        EmployeeLeaveBalances object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeLeaveBalances", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves leave balances for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeeLeaveBalancesForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployeeLeaveBalances");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployeeLeaveBalances");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployeeLeaveBalances");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/LeaveBalances");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves leave periods for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param startDate Filter by start date
   * @param endDate Filter by end date
   * @param accessToken Authorization token for user set in header of each request
   * @return LeavePeriods
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public LeavePeriods getEmployeeLeavePeriods(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      LocalDate startDate,
      LocalDate endDate)
      throws IOException {
    try {
      TypeReference<LeavePeriods> typeRef = new TypeReference<LeavePeriods>() {};
      HttpResponse response =
          getEmployeeLeavePeriodsForHttpResponse(
              accessToken, xeroTenantId, employeeID, startDate, endDate);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployeeLeavePeriods -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<LeavePeriods> errorTypeRef = new TypeReference<LeavePeriods>() {};
        LeavePeriods object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "LeavePeriods", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves leave periods for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param startDate Filter by start date
   * @param endDate Filter by end date
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeeLeavePeriodsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      LocalDate startDate,
      LocalDate endDate)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployeeLeavePeriods");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployeeLeavePeriods");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployeeLeavePeriods");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/LeavePeriods");
    if (startDate != null) {
      String key = "startDate";
      Object value = startDate;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (endDate != null) {
      String key = "endDate";
      Object value = endDate;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves leave types for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeLeaveTypes
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeLeaveTypes getEmployeeLeaveTypes(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    try {
      TypeReference<EmployeeLeaveTypes> typeRef = new TypeReference<EmployeeLeaveTypes>() {};
      HttpResponse response =
          getEmployeeLeaveTypesForHttpResponse(accessToken, xeroTenantId, employeeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployeeLeaveTypes -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeLeaveTypes> errorTypeRef = new TypeReference<EmployeeLeaveTypes>() {};
        EmployeeLeaveTypes object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeLeaveTypes", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves leave types for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeeLeaveTypesForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployeeLeaveTypes");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployeeLeaveTypes");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployeeLeaveTypes");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/LeaveTypes");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves leave records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeLeaves
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeLeaves getEmployeeLeaves(String accessToken, String xeroTenantId, UUID employeeID)
      throws IOException {
    try {
      TypeReference<EmployeeLeaves> typeRef = new TypeReference<EmployeeLeaves>() {};
      HttpResponse response =
          getEmployeeLeavesForHttpResponse(accessToken, xeroTenantId, employeeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployeeLeaves -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeLeaves> errorTypeRef = new TypeReference<EmployeeLeaves>() {};
        EmployeeLeaves object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeLeaves", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves leave records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeeLeavesForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployeeLeaves");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployeeLeaves");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployeeLeaves");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/Leave");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves the opening balance for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeOpeningBalancesObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeOpeningBalancesObject getEmployeeOpeningBalances(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    try {
      TypeReference<EmployeeOpeningBalancesObject> typeRef =
          new TypeReference<EmployeeOpeningBalancesObject>() {};
      HttpResponse response =
          getEmployeeOpeningBalancesForHttpResponse(accessToken, xeroTenantId, employeeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployeeOpeningBalances -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeOpeningBalancesObject> errorTypeRef =
            new TypeReference<EmployeeOpeningBalancesObject>() {};
        EmployeeOpeningBalancesObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(
            e.getStatusCode(), "EmployeeOpeningBalancesObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves the opening balance for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeeOpeningBalancesForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployeeOpeningBalances");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployeeOpeningBalances");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployeeOpeningBalances");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/openingBalances");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves pay templates for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeePayTemplates
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeePayTemplates getEmployeePayTemplates(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    try {
      TypeReference<EmployeePayTemplates> typeRef = new TypeReference<EmployeePayTemplates>() {};
      HttpResponse response =
          getEmployeePayTemplatesForHttpResponse(accessToken, xeroTenantId, employeeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployeePayTemplates -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeePayTemplates> errorTypeRef =
            new TypeReference<EmployeePayTemplates>() {};
        EmployeePayTemplates object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeePayTemplates", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves pay templates for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeePayTemplatesForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployeePayTemplates");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployeePayTemplates");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployeePayTemplates");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/PayTemplates");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves available payment methods for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return PaymentMethodObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PaymentMethodObject getEmployeePaymentMethod(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    try {
      TypeReference<PaymentMethodObject> typeRef = new TypeReference<PaymentMethodObject>() {};
      HttpResponse response =
          getEmployeePaymentMethodForHttpResponse(accessToken, xeroTenantId, employeeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployeePaymentMethod -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PaymentMethodObject> errorTypeRef =
            new TypeReference<PaymentMethodObject>() {};
        PaymentMethodObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PaymentMethodObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves available payment methods for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeePaymentMethodForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployeePaymentMethod");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployeePaymentMethod");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployeePaymentMethod");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/PaymentMethods");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves an employee&#39;s salary and wages record by using a unique salary and wage ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param salaryAndWagesID Id for single pay template earnings object
   * @param accessToken Authorization token for user set in header of each request
   * @return SalaryAndWages
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public SalaryAndWages getEmployeeSalaryAndWage(
      String accessToken, String xeroTenantId, UUID employeeID, UUID salaryAndWagesID)
      throws IOException {
    try {
      TypeReference<SalaryAndWages> typeRef = new TypeReference<SalaryAndWages>() {};
      HttpResponse response =
          getEmployeeSalaryAndWageForHttpResponse(
              accessToken, xeroTenantId, employeeID, salaryAndWagesID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployeeSalaryAndWage -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<SalaryAndWages> errorTypeRef = new TypeReference<SalaryAndWages>() {};
        SalaryAndWages object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "SalaryAndWages", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves an employee&#39;s salary and wages record by using a unique salary and wage ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param salaryAndWagesID Id for single pay template earnings object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeeSalaryAndWageForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, UUID salaryAndWagesID)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployeeSalaryAndWage");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployeeSalaryAndWage");
    } // verify the required parameter 'salaryAndWagesID' is set
    if (salaryAndWagesID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'salaryAndWagesID' when calling"
              + " getEmployeeSalaryAndWage");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployeeSalaryAndWage");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);
    uriVariables.put("SalaryAndWagesID", salaryAndWagesID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves an employee&#39;s salary and wages
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return SalaryAndWages
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public SalaryAndWages getEmployeeSalaryAndWages(
      String accessToken, String xeroTenantId, UUID employeeID, Integer page) throws IOException {
    try {
      TypeReference<SalaryAndWages> typeRef = new TypeReference<SalaryAndWages>() {};
      HttpResponse response =
          getEmployeeSalaryAndWagesForHttpResponse(accessToken, xeroTenantId, employeeID, page);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployeeSalaryAndWages -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<SalaryAndWages> errorTypeRef = new TypeReference<SalaryAndWages>() {};
        SalaryAndWages object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "SalaryAndWages", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves an employee&#39;s salary and wages
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeeSalaryAndWagesForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, Integer page) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployeeSalaryAndWages");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployeeSalaryAndWages");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployeeSalaryAndWages");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/SalaryAndWages");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves tax records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeTaxObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeTaxObject getEmployeeTax(String accessToken, String xeroTenantId, UUID employeeID)
      throws IOException {
    try {
      TypeReference<EmployeeTaxObject> typeRef = new TypeReference<EmployeeTaxObject>() {};
      HttpResponse response = getEmployeeTaxForHttpResponse(accessToken, xeroTenantId, employeeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployeeTax -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeTaxObject> errorTypeRef = new TypeReference<EmployeeTaxObject>() {};
        EmployeeTaxObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeTaxObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves tax records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeeTaxForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployeeTax");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling getEmployeeTax");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployeeTax");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/Tax");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves employees
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param filter Filter by first name and/or lastname
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return Employees
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Employees getEmployees(
      String accessToken, String xeroTenantId, String filter, Integer page) throws IOException {
    try {
      TypeReference<Employees> typeRef = new TypeReference<Employees>() {};
      HttpResponse response = getEmployeesForHttpResponse(accessToken, xeroTenantId, filter, page);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getEmployees -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<Employees> errorTypeRef = new TypeReference<Employees>() {};
        Employees object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "Employees", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves employees
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param filter Filter by first name and/or lastname
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getEmployeesForHttpResponse(
      String accessToken, String xeroTenantId, String filter, Integer page) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getEmployees");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getEmployees");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Employees");
    if (filter != null) {
      String key = "filter";
      Object value = filter;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific leave type by using a unique leave type ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param leaveTypeID Identifier for the leave type
   * @param accessToken Authorization token for user set in header of each request
   * @return LeaveTypeObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public LeaveTypeObject getLeaveType(String accessToken, String xeroTenantId, UUID leaveTypeID)
      throws IOException {
    try {
      TypeReference<LeaveTypeObject> typeRef = new TypeReference<LeaveTypeObject>() {};
      HttpResponse response = getLeaveTypeForHttpResponse(accessToken, xeroTenantId, leaveTypeID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getLeaveType -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<LeaveTypeObject> errorTypeRef = new TypeReference<LeaveTypeObject>() {};
        LeaveTypeObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "LeaveTypeObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific leave type by using a unique leave type ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param leaveTypeID Identifier for the leave type
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getLeaveTypeForHttpResponse(
      String accessToken, String xeroTenantId, UUID leaveTypeID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getLeaveType");
    } // verify the required parameter 'leaveTypeID' is set
    if (leaveTypeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'leaveTypeID' when calling getLeaveType");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getLeaveType");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("LeaveTypeID", leaveTypeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/LeaveTypes/{LeaveTypeID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves leave types
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param activeOnly Filters leave types by active status. By default the API returns all leave
   *     types.
   * @param accessToken Authorization token for user set in header of each request
   * @return LeaveTypes
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public LeaveTypes getLeaveTypes(
      String accessToken, String xeroTenantId, Integer page, Boolean activeOnly)
      throws IOException {
    try {
      TypeReference<LeaveTypes> typeRef = new TypeReference<LeaveTypes>() {};
      HttpResponse response =
          getLeaveTypesForHttpResponse(accessToken, xeroTenantId, page, activeOnly);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getLeaveTypes -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<LeaveTypes> errorTypeRef = new TypeReference<LeaveTypes>() {};
        LeaveTypes object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "LeaveTypes", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves leave types
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param activeOnly Filters leave types by active status. By default the API returns all leave
   *     types.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getLeaveTypesForHttpResponse(
      String accessToken, String xeroTenantId, Integer page, Boolean activeOnly)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getLeaveTypes");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getLeaveTypes");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/LeaveTypes");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (activeOnly != null) {
      String key = "ActiveOnly";
      Object value = activeOnly;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific pay run by using a unique pay run ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payRunID Identifier for the pay run
   * @param accessToken Authorization token for user set in header of each request
   * @return PayRunObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PayRunObject getPayRun(String accessToken, String xeroTenantId, UUID payRunID)
      throws IOException {
    try {
      TypeReference<PayRunObject> typeRef = new TypeReference<PayRunObject>() {};
      HttpResponse response = getPayRunForHttpResponse(accessToken, xeroTenantId, payRunID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPayRun -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PayRunObject> errorTypeRef = new TypeReference<PayRunObject>() {};
        PayRunObject object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PayRunObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific pay run by using a unique pay run ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payRunID Identifier for the pay run
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPayRunForHttpResponse(
      String accessToken, String xeroTenantId, UUID payRunID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPayRun");
    } // verify the required parameter 'payRunID' is set
    if (payRunID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payRunID' when calling getPayRun");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPayRun");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PayRunID", payRunID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PayRuns/{PayRunID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific payrun calendar by using a unique payroll calendar ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payrollCalendarID Identifier for the payrun calendars
   * @param accessToken Authorization token for user set in header of each request
   * @return PayRunCalendarObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PayRunCalendarObject getPayRunCalendar(
      String accessToken, String xeroTenantId, UUID payrollCalendarID) throws IOException {
    try {
      TypeReference<PayRunCalendarObject> typeRef = new TypeReference<PayRunCalendarObject>() {};
      HttpResponse response =
          getPayRunCalendarForHttpResponse(accessToken, xeroTenantId, payrollCalendarID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPayRunCalendar -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PayRunCalendarObject> errorTypeRef =
            new TypeReference<PayRunCalendarObject>() {};
        PayRunCalendarObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PayRunCalendarObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific payrun calendar by using a unique payroll calendar ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payrollCalendarID Identifier for the payrun calendars
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPayRunCalendarForHttpResponse(
      String accessToken, String xeroTenantId, UUID payrollCalendarID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPayRunCalendar");
    } // verify the required parameter 'payrollCalendarID' is set
    if (payrollCalendarID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payrollCalendarID' when calling getPayRunCalendar");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPayRunCalendar");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PayrollCalendarID", payrollCalendarID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/PayRunCalendars/{PayrollCalendarID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves payrun calendars
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return PayRunCalendars
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PayRunCalendars getPayRunCalendars(String accessToken, String xeroTenantId, Integer page)
      throws IOException {
    try {
      TypeReference<PayRunCalendars> typeRef = new TypeReference<PayRunCalendars>() {};
      HttpResponse response = getPayRunCalendarsForHttpResponse(accessToken, xeroTenantId, page);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPayRunCalendars -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PayRunCalendars> errorTypeRef = new TypeReference<PayRunCalendars>() {};
        PayRunCalendars object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PayRunCalendars", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves payrun calendars
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPayRunCalendarsForHttpResponse(
      String accessToken, String xeroTenantId, Integer page) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPayRunCalendars");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPayRunCalendars");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PayRunCalendars");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves pay runs
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param status By default get payruns will return all the payruns for an organization. You can
   *     add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter
   *     the payruns by status.
   * @param accessToken Authorization token for user set in header of each request
   * @return PayRuns
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PayRuns getPayRuns(String accessToken, String xeroTenantId, Integer page, String status)
      throws IOException {
    try {
      TypeReference<PayRuns> typeRef = new TypeReference<PayRuns>() {};
      HttpResponse response = getPayRunsForHttpResponse(accessToken, xeroTenantId, page, status);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPayRuns -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PayRuns> errorTypeRef = new TypeReference<PayRuns>() {};
        PayRuns object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PayRuns", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves pay runs
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param status By default get payruns will return all the payruns for an organization. You can
   *     add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter
   *     the payruns by status.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPayRunsForHttpResponse(
      String accessToken, String xeroTenantId, Integer page, String status) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPayRuns");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPayRuns");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PayRuns");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (status != null) {
      String key = "status";
      Object value = status;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific payslip by a unique pay slip ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paySlipID Identifier for the payslip
   * @param accessToken Authorization token for user set in header of each request
   * @return PaySlipObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PaySlipObject getPaySlip(String accessToken, String xeroTenantId, UUID paySlipID)
      throws IOException {
    try {
      TypeReference<PaySlipObject> typeRef = new TypeReference<PaySlipObject>() {};
      HttpResponse response = getPaySlipForHttpResponse(accessToken, xeroTenantId, paySlipID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPaySlip -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PaySlipObject> errorTypeRef = new TypeReference<PaySlipObject>() {};
        PaySlipObject object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PaySlipObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific payslip by a unique pay slip ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paySlipID Identifier for the payslip
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPaySlipForHttpResponse(
      String accessToken, String xeroTenantId, UUID paySlipID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPaySlip");
    } // verify the required parameter 'paySlipID' is set
    if (paySlipID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paySlipID' when calling getPaySlip");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPaySlip");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PaySlipID", paySlipID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PaySlips/{PaySlipID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves payslips
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payRunID PayrunID which specifies the containing payrun of payslips to retrieve. By
   *     default, the API does not group payslips by payrun.
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return PaySlips
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PaySlips getPaySlips(String accessToken, String xeroTenantId, UUID payRunID, Integer page)
      throws IOException {
    try {
      TypeReference<PaySlips> typeRef = new TypeReference<PaySlips>() {};
      HttpResponse response = getPaySlipsForHttpResponse(accessToken, xeroTenantId, payRunID, page);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getPaySlips -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PaySlips> errorTypeRef = new TypeReference<PaySlips>() {};
        PaySlips object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PaySlips", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves payslips
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payRunID PayrunID which specifies the containing payrun of payslips to retrieve. By
   *     default, the API does not group payslips by payrun.
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getPaySlipsForHttpResponse(
      String accessToken, String xeroTenantId, UUID payRunID, Integer page) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getPaySlips");
    } // verify the required parameter 'payRunID' is set
    if (payRunID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payRunID' when calling getPaySlips");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getPaySlips");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PaySlips");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (payRunID != null) {
      String key = "PayRunID";
      Object value = payRunID;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific reimbursement by using a unique reimbursement ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param reimbursementID Identifier for the reimbursement
   * @param accessToken Authorization token for user set in header of each request
   * @return ReimbursementObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public ReimbursementObject getReimbursement(
      String accessToken, String xeroTenantId, UUID reimbursementID) throws IOException {
    try {
      TypeReference<ReimbursementObject> typeRef = new TypeReference<ReimbursementObject>() {};
      HttpResponse response =
          getReimbursementForHttpResponse(accessToken, xeroTenantId, reimbursementID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getReimbursement -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<ReimbursementObject> errorTypeRef =
            new TypeReference<ReimbursementObject>() {};
        ReimbursementObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "ReimbursementObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific reimbursement by using a unique reimbursement ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param reimbursementID Identifier for the reimbursement
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getReimbursementForHttpResponse(
      String accessToken, String xeroTenantId, UUID reimbursementID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getReimbursement");
    } // verify the required parameter 'reimbursementID' is set
    if (reimbursementID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'reimbursementID' when calling getReimbursement");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getReimbursement");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("ReimbursementID", reimbursementID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Reimbursements/{ReimbursementID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves reimbursements
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return Reimbursements
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Reimbursements getReimbursements(String accessToken, String xeroTenantId, Integer page)
      throws IOException {
    try {
      TypeReference<Reimbursements> typeRef = new TypeReference<Reimbursements>() {};
      HttpResponse response = getReimbursementsForHttpResponse(accessToken, xeroTenantId, page);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getReimbursements -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<Reimbursements> errorTypeRef = new TypeReference<Reimbursements>() {};
        Reimbursements object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "Reimbursements", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves reimbursements
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getReimbursementsForHttpResponse(
      String accessToken, String xeroTenantId, Integer page) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getReimbursements");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getReimbursements");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Reimbursements");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves settings
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return Settings
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Settings getSettings(String accessToken, String xeroTenantId) throws IOException {
    try {
      TypeReference<Settings> typeRef = new TypeReference<Settings>() {};
      HttpResponse response = getSettingsForHttpResponse(accessToken, xeroTenantId);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getSettings -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<Settings> errorTypeRef = new TypeReference<Settings>() {};
        Settings object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "Settings", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves settings
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getSettingsForHttpResponse(String accessToken, String xeroTenantId)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getSettings");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getSettings");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Settings");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific statutory deduction by using a unique statutory deductions id
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param id Identifier for the statutory deduction
   * @param accessToken Authorization token for user set in header of each request
   * @return StatutoryDeductionObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public StatutoryDeductionObject getStatutoryDeduction(
      String accessToken, String xeroTenantId, UUID id) throws IOException {
    try {
      TypeReference<StatutoryDeductionObject> typeRef =
          new TypeReference<StatutoryDeductionObject>() {};
      HttpResponse response = getStatutoryDeductionForHttpResponse(accessToken, xeroTenantId, id);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getStatutoryDeduction -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific statutory deduction by using a unique statutory deductions id
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param id Identifier for the statutory deduction
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getStatutoryDeductionForHttpResponse(
      String accessToken, String xeroTenantId, UUID id) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getStatutoryDeduction");
    } // verify the required parameter 'id' is set
    if (id == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'id' when calling getStatutoryDeduction");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getStatutoryDeduction");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("id", id);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/StatutoryDeductions/{id}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves statutory deductions
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return StatutoryDeductions
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public StatutoryDeductions getStatutoryDeductions(
      String accessToken, String xeroTenantId, Integer page) throws IOException {
    try {
      TypeReference<StatutoryDeductions> typeRef = new TypeReference<StatutoryDeductions>() {};
      HttpResponse response =
          getStatutoryDeductionsForHttpResponse(accessToken, xeroTenantId, page);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getStatutoryDeductions -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves statutory deductions
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getStatutoryDeductionsForHttpResponse(
      String accessToken, String xeroTenantId, Integer page) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getStatutoryDeductions");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getStatutoryDeductions");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/StatutoryDeductions");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific superannuation using a unique superannuation ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param superannuationID Identifier for the superannuation
   * @param accessToken Authorization token for user set in header of each request
   * @return SuperannuationObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public SuperannuationObject getSuperannuation(
      String accessToken, String xeroTenantId, UUID superannuationID) throws IOException {
    try {
      TypeReference<SuperannuationObject> typeRef = new TypeReference<SuperannuationObject>() {};
      HttpResponse response =
          getSuperannuationForHttpResponse(accessToken, xeroTenantId, superannuationID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getSuperannuation -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific superannuation using a unique superannuation ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param superannuationID Identifier for the superannuation
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getSuperannuationForHttpResponse(
      String accessToken, String xeroTenantId, UUID superannuationID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getSuperannuation");
    } // verify the required parameter 'superannuationID' is set
    if (superannuationID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'superannuationID' when calling getSuperannuation");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getSuperannuation");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("SuperannuationID", superannuationID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Superannuations/{SuperannuationID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves superannuations
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return Superannuations
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Superannuations getSuperannuations(String accessToken, String xeroTenantId, Integer page)
      throws IOException {
    try {
      TypeReference<Superannuations> typeRef = new TypeReference<Superannuations>() {};
      HttpResponse response = getSuperannuationsForHttpResponse(accessToken, xeroTenantId, page);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getSuperannuations -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      handler.execute(e);
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves superannuations
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getSuperannuationsForHttpResponse(
      String accessToken, String xeroTenantId, Integer page) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getSuperannuations");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getSuperannuations");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Superannuations");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves a specific timesheet by using a unique timesheet ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param accessToken Authorization token for user set in header of each request
   * @return TimesheetObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TimesheetObject getTimesheet(String accessToken, String xeroTenantId, UUID timesheetID)
      throws IOException {
    try {
      TypeReference<TimesheetObject> typeRef = new TypeReference<TimesheetObject>() {};
      HttpResponse response = getTimesheetForHttpResponse(accessToken, xeroTenantId, timesheetID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getTimesheet -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<TimesheetObject> errorTypeRef = new TypeReference<TimesheetObject>() {};
        TimesheetObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "TimesheetObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves a specific timesheet by using a unique timesheet ID
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getTimesheetForHttpResponse(
      String accessToken, String xeroTenantId, UUID timesheetID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getTimesheet");
    } // verify the required parameter 'timesheetID' is set
    if (timesheetID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetID' when calling getTimesheet");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getTimesheet");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("TimesheetID", timesheetID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Timesheets/{TimesheetID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves timesheets
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param filter Filter by employeeId and/or payrollCalendarId
   * @param status filter results by any timesheets with a matching timesheet status
   * @param startDate filter results by any timesheets with a startDate on or after the provided
   *     date
   * @param endDate filter results by any timesheets with a endDate on or before the provided date
   * @param sort sort the order of timesheets returned. The default is based on the timesheets
   *     createdDate, sorted oldest to newest. Currently, the only other option is to reverse the
   *     order based on the timesheets startDate, sorted newest to oldest.
   * @param accessToken Authorization token for user set in header of each request
   * @return Timesheets
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public Timesheets getTimesheets(
      String accessToken,
      String xeroTenantId,
      Integer page,
      String filter,
      String status,
      String startDate,
      String endDate,
      String sort)
      throws IOException {
    try {
      TypeReference<Timesheets> typeRef = new TypeReference<Timesheets>() {};
      HttpResponse response =
          getTimesheetsForHttpResponse(
              accessToken, xeroTenantId, page, filter, status, startDate, endDate, sort);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getTimesheets -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<Timesheets> errorTypeRef = new TypeReference<Timesheets>() {};
        Timesheets object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "Timesheets", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves timesheets
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param page Page number which specifies the set of records to retrieve. By default the number
   *     of the records per set is 100.
   * @param filter Filter by employeeId and/or payrollCalendarId
   * @param status filter results by any timesheets with a matching timesheet status
   * @param startDate filter results by any timesheets with a startDate on or after the provided
   *     date
   * @param endDate filter results by any timesheets with a endDate on or before the provided date
   * @param sort sort the order of timesheets returned. The default is based on the timesheets
   *     createdDate, sorted oldest to newest. Currently, the only other option is to reverse the
   *     order based on the timesheets startDate, sorted newest to oldest.
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getTimesheetsForHttpResponse(
      String accessToken,
      String xeroTenantId,
      Integer page,
      String filter,
      String status,
      String startDate,
      String endDate,
      String sort)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getTimesheets");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getTimesheets");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Timesheets");
    if (page != null) {
      String key = "page";
      Object value = page;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (filter != null) {
      String key = "filter";
      Object value = filter;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (status != null) {
      String key = "status";
      Object value = status;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (startDate != null) {
      String key = "startDate";
      Object value = startDate;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (endDate != null) {
      String key = "endDate";
      Object value = endDate;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    if (sort != null) {
      String key = "sort";
      Object value = sort;
      if (value instanceof Collection) {
        uriBuilder = uriBuilder.queryParam(key, ((Collection) value).toArray());
      } else if (value instanceof Object[]) {
        uriBuilder = uriBuilder.queryParam(key, (Object[]) value);
      } else {
        uriBuilder = uriBuilder.queryParam(key, value);
      }
    }
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Retrieves tracking categories
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return TrackingCategories
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TrackingCategories getTrackingCategories(String accessToken, String xeroTenantId)
      throws IOException {
    try {
      TypeReference<TrackingCategories> typeRef = new TypeReference<TrackingCategories>() {};
      HttpResponse response = getTrackingCategoriesForHttpResponse(accessToken, xeroTenantId);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : getTrackingCategories -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<TrackingCategories> errorTypeRef = new TypeReference<TrackingCategories>() {};
        TrackingCategories object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "TrackingCategories", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Retrieves tracking categories
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse getTrackingCategoriesForHttpResponse(String accessToken, String xeroTenantId)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling getTrackingCategories");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling getTrackingCategories");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Settings/TrackingCategories");
    String url = uriBuilder.build().toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("GET " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.GET, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Reverts a timesheet to draft
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param accessToken Authorization token for user set in header of each request
   * @return TimesheetObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TimesheetObject revertTimesheet(String accessToken, String xeroTenantId, UUID timesheetID)
      throws IOException {
    try {
      TypeReference<TimesheetObject> typeRef = new TypeReference<TimesheetObject>() {};
      HttpResponse response =
          revertTimesheetForHttpResponse(accessToken, xeroTenantId, timesheetID);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : revertTimesheet -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<TimesheetObject> errorTypeRef = new TypeReference<TimesheetObject>() {};
        TimesheetObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "TimesheetObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Reverts a timesheet to draft
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse revertTimesheetForHttpResponse(
      String accessToken, String xeroTenantId, UUID timesheetID) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling revertTimesheet");
    } // verify the required parameter 'timesheetID' is set
    if (timesheetID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetID' when calling revertTimesheet");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling revertTimesheet");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("TimesheetID", timesheetID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Timesheets/{TimesheetID}/RevertToDraft");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Updates an existing employee
   *
   * <p><b>200</b> - successful response
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employee The employee parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeObject updateEmployee(
      String accessToken, String xeroTenantId, UUID employeeID, Employee employee)
      throws IOException {
    try {
      TypeReference<EmployeeObject> typeRef = new TypeReference<EmployeeObject>() {};
      HttpResponse response =
          updateEmployeeForHttpResponse(accessToken, xeroTenantId, employeeID, employee);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : updateEmployee -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeObject> errorTypeRef = new TypeReference<EmployeeObject>() {};
        EmployeeObject object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Updates an existing employee
   *
   * <p><b>200</b> - successful response
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employee The employee parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse updateEmployeeForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, Employee employee)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling updateEmployee");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling updateEmployee");
    } // verify the required parameter 'employee' is set
    if (employee == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employee' when calling updateEmployee");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling updateEmployee");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(employee);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Updates an earnings template records for an employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param payTemplateEarningID Id for single pay template earnings object
   * @param earningsTemplate The earningsTemplate parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EarningsTemplateObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EarningsTemplateObject updateEmployeeEarningsTemplate(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      UUID payTemplateEarningID,
      EarningsTemplate earningsTemplate)
      throws IOException {
    try {
      TypeReference<EarningsTemplateObject> typeRef =
          new TypeReference<EarningsTemplateObject>() {};
      HttpResponse response =
          updateEmployeeEarningsTemplateForHttpResponse(
              accessToken, xeroTenantId, employeeID, payTemplateEarningID, earningsTemplate);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : updateEmployeeEarningsTemplate -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EarningsTemplateObject> errorTypeRef =
            new TypeReference<EarningsTemplateObject>() {};
        EarningsTemplateObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(
            e.getStatusCode(), "EarningsTemplateObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Updates an earnings template records for an employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param payTemplateEarningID Id for single pay template earnings object
   * @param earningsTemplate The earningsTemplate parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse updateEmployeeEarningsTemplateForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      UUID payTemplateEarningID,
      EarningsTemplate earningsTemplate)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling"
              + " updateEmployeeEarningsTemplate");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling"
              + " updateEmployeeEarningsTemplate");
    } // verify the required parameter 'payTemplateEarningID' is set
    if (payTemplateEarningID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payTemplateEarningID' when calling"
              + " updateEmployeeEarningsTemplate");
    } // verify the required parameter 'earningsTemplate' is set
    if (earningsTemplate == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'earningsTemplate' when calling"
              + " updateEmployeeEarningsTemplate");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling"
              + " updateEmployeeEarningsTemplate");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);
    uriVariables.put("PayTemplateEarningID", payTemplateEarningID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath()
                + "/Employees/{EmployeeID}/PayTemplates/earnings/{PayTemplateEarningID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(earningsTemplate);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Updates leave records for a specific employee
   *
   * <p><b>200</b> - successful response
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param leaveID Leave id for single object
   * @param employeeLeave The employeeLeave parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeLeaveObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeLeaveObject updateEmployeeLeave(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      UUID leaveID,
      EmployeeLeave employeeLeave)
      throws IOException {
    try {
      TypeReference<EmployeeLeaveObject> typeRef = new TypeReference<EmployeeLeaveObject>() {};
      HttpResponse response =
          updateEmployeeLeaveForHttpResponse(
              accessToken, xeroTenantId, employeeID, leaveID, employeeLeave);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : updateEmployeeLeave -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeLeaveObject> errorTypeRef =
            new TypeReference<EmployeeLeaveObject>() {};
        EmployeeLeaveObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeLeaveObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Updates leave records for a specific employee
   *
   * <p><b>200</b> - successful response
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param leaveID Leave id for single object
   * @param employeeLeave The employeeLeave parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse updateEmployeeLeaveForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      UUID leaveID,
      EmployeeLeave employeeLeave)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling updateEmployeeLeave");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling updateEmployeeLeave");
    } // verify the required parameter 'leaveID' is set
    if (leaveID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'leaveID' when calling updateEmployeeLeave");
    } // verify the required parameter 'employeeLeave' is set
    if (employeeLeave == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeLeave' when calling updateEmployeeLeave");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling updateEmployeeLeave");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);
    uriVariables.put("LeaveID", leaveID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/Leave/{LeaveID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(employeeLeave);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Updates an employee&#39;s salary and wages record
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param salaryAndWagesID Id for single pay template earnings object
   * @param salaryAndWage The salaryAndWage parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return SalaryAndWageObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public SalaryAndWageObject updateEmployeeSalaryAndWage(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      UUID salaryAndWagesID,
      SalaryAndWage salaryAndWage)
      throws IOException {
    try {
      TypeReference<SalaryAndWageObject> typeRef = new TypeReference<SalaryAndWageObject>() {};
      HttpResponse response =
          updateEmployeeSalaryAndWageForHttpResponse(
              accessToken, xeroTenantId, employeeID, salaryAndWagesID, salaryAndWage);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : updateEmployeeSalaryAndWage -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<SalaryAndWageObject> errorTypeRef =
            new TypeReference<SalaryAndWageObject>() {};
        SalaryAndWageObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "SalaryAndWageObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Updates an employee&#39;s salary and wages record
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param salaryAndWagesID Id for single pay template earnings object
   * @param salaryAndWage The salaryAndWage parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse updateEmployeeSalaryAndWageForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID employeeID,
      UUID salaryAndWagesID,
      SalaryAndWage salaryAndWage)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling updateEmployeeSalaryAndWage");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling updateEmployeeSalaryAndWage");
    } // verify the required parameter 'salaryAndWagesID' is set
    if (salaryAndWagesID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'salaryAndWagesID' when calling"
              + " updateEmployeeSalaryAndWage");
    } // verify the required parameter 'salaryAndWage' is set
    if (salaryAndWage == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'salaryAndWage' when calling"
              + " updateEmployeeSalaryAndWage");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling updateEmployeeSalaryAndWage");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);
    uriVariables.put("SalaryAndWagesID", salaryAndWagesID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(salaryAndWage);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Updates the tax records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employeeTax The employeeTax parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return EmployeeTaxObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public EmployeeTaxObject updateEmployeeTax(
      String accessToken, String xeroTenantId, UUID employeeID, EmployeeTax employeeTax)
      throws IOException {
    try {
      TypeReference<EmployeeTaxObject> typeRef = new TypeReference<EmployeeTaxObject>() {};
      HttpResponse response =
          updateEmployeeTaxForHttpResponse(accessToken, xeroTenantId, employeeID, employeeTax);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : updateEmployeeTax -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<EmployeeTaxObject> errorTypeRef = new TypeReference<EmployeeTaxObject>() {};
        EmployeeTaxObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "EmployeeTaxObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Updates the tax records for a specific employee
   *
   * <p><b>200</b> - search results matching criteria
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param employeeID Employee id for single object
   * @param employeeTax The employeeTax parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse updateEmployeeTaxForHttpResponse(
      String accessToken, String xeroTenantId, UUID employeeID, EmployeeTax employeeTax)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling updateEmployeeTax");
    } // verify the required parameter 'employeeID' is set
    if (employeeID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeID' when calling updateEmployeeTax");
    } // verify the required parameter 'employeeTax' is set
    if (employeeTax == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'employeeTax' when calling updateEmployeeTax");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling updateEmployeeTax");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("EmployeeID", employeeID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(apiClient.getBasePath() + "/Employees/{EmployeeID}/Tax");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("POST " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(employeeTax);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.POST, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Updates a pay run
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payRunID Identifier for the pay run
   * @param payRun The payRun parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return PayRunObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PayRunObject updatePayRun(
      String accessToken, String xeroTenantId, UUID payRunID, PayRun payRun) throws IOException {
    try {
      TypeReference<PayRunObject> typeRef = new TypeReference<PayRunObject>() {};
      HttpResponse response =
          updatePayRunForHttpResponse(accessToken, xeroTenantId, payRunID, payRun);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : updatePayRun -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PayRunObject> errorTypeRef = new TypeReference<PayRunObject>() {};
        PayRunObject object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PayRunObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Updates a pay run
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param payRunID Identifier for the pay run
   * @param payRun The payRun parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse updatePayRunForHttpResponse(
      String accessToken, String xeroTenantId, UUID payRunID, PayRun payRun) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling updatePayRun");
    } // verify the required parameter 'payRunID' is set
    if (payRunID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payRunID' when calling updatePayRun");
    } // verify the required parameter 'payRun' is set
    if (payRun == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'payRun' when calling updatePayRun");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling updatePayRun");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PayRunID", payRunID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PayRuns/{PayRunID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(payRun);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Creates an employee pay slip
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paySlipID Identifier for the payslip
   * @param paySlip The paySlip parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return PaySlipObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public PaySlipObject updatePaySlipLineItems(
      String accessToken, String xeroTenantId, UUID paySlipID, PaySlip paySlip) throws IOException {
    try {
      TypeReference<PaySlipObject> typeRef = new TypeReference<PaySlipObject>() {};
      HttpResponse response =
          updatePaySlipLineItemsForHttpResponse(accessToken, xeroTenantId, paySlipID, paySlip);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : updatePaySlipLineItems -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<PaySlipObject> errorTypeRef = new TypeReference<PaySlipObject>() {};
        PaySlipObject object = apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "PaySlipObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Creates an employee pay slip
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param paySlipID Identifier for the payslip
   * @param paySlip The paySlip parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse updatePaySlipLineItemsForHttpResponse(
      String accessToken, String xeroTenantId, UUID paySlipID, PaySlip paySlip) throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling updatePaySlipLineItems");
    } // verify the required parameter 'paySlipID' is set
    if (paySlipID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paySlipID' when calling updatePaySlipLineItems");
    } // verify the required parameter 'paySlip' is set
    if (paySlip == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'paySlip' when calling updatePaySlipLineItems");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling updatePaySlipLineItems");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("PaySlipID", paySlipID);

    UriBuilder uriBuilder = UriBuilder.fromUri(apiClient.getBasePath() + "/PaySlips/{PaySlipID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(paySlip);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * Updates a timesheet line for a specific timesheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param timesheetLineID Identifier for the timesheet line
   * @param timesheetLine The timesheetLine parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return TimesheetLineObject
   * @throws IOException if an error occurs while attempting to invoke the API *
   */
  public TimesheetLineObject updateTimesheetLine(
      String accessToken,
      String xeroTenantId,
      UUID timesheetID,
      UUID timesheetLineID,
      TimesheetLine timesheetLine)
      throws IOException {
    try {
      TypeReference<TimesheetLineObject> typeRef = new TypeReference<TimesheetLineObject>() {};
      HttpResponse response =
          updateTimesheetLineForHttpResponse(
              accessToken, xeroTenantId, timesheetID, timesheetLineID, timesheetLine);
      return apiClient.getObjectMapper().readValue(response.getContent(), typeRef);
    } catch (HttpResponseException e) {
      if (logger.isDebugEnabled()) {
        logger.debug(
            "------------------ HttpResponseException "
                + e.getStatusCode()
                + " : updateTimesheetLine -------------------");
        logger.debug(e.toString());
      }
      XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
      if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
        TypeReference<TimesheetLineObject> errorTypeRef =
            new TypeReference<TimesheetLineObject>() {};
        TimesheetLineObject object =
            apiClient.getObjectMapper().readValue(e.getContent(), errorTypeRef);
        handler.validationError(e.getStatusCode(), "TimesheetLineObject", object.getProblem(), e);
      } else {
        handler.execute(e);
      }
    } catch (IOException ioe) {
      throw ioe;
    }
    return null;
  }

  /**
   * Updates a timesheet line for a specific timesheet
   *
   * <p><b>200</b> - search results matching criteria
   *
   * <p><b>400</b> - validation error for a bad request
   *
   * @param xeroTenantId Xero identifier for Tenant
   * @param timesheetID Identifier for the timesheet
   * @param timesheetLineID Identifier for the timesheet line
   * @param timesheetLine The timesheetLine parameter
   * @param accessToken Authorization token for user set in header of each request
   * @return HttpResponse
   * @throws IOException if an error occurs while attempting to invoke the API
   */
  public HttpResponse updateTimesheetLineForHttpResponse(
      String accessToken,
      String xeroTenantId,
      UUID timesheetID,
      UUID timesheetLineID,
      TimesheetLine timesheetLine)
      throws IOException {
    // verify the required parameter 'xeroTenantId' is set
    if (xeroTenantId == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'xeroTenantId' when calling updateTimesheetLine");
    } // verify the required parameter 'timesheetID' is set
    if (timesheetID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetID' when calling updateTimesheetLine");
    } // verify the required parameter 'timesheetLineID' is set
    if (timesheetLineID == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetLineID' when calling updateTimesheetLine");
    } // verify the required parameter 'timesheetLine' is set
    if (timesheetLine == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'timesheetLine' when calling updateTimesheetLine");
    }
    if (accessToken == null) {
      throw new IllegalArgumentException(
          "Missing the required parameter 'accessToken' when calling updateTimesheetLine");
    }
    HttpHeaders headers = new HttpHeaders();
    headers.set("Xero-Tenant-Id", xeroTenantId);
    headers.setAccept("application/json");
    headers.setUserAgent(this.getUserAgent());
    // create a map of path variables
    final Map<String, Object> uriVariables = new HashMap<String, Object>();
    uriVariables.put("TimesheetID", timesheetID);
    uriVariables.put("TimesheetLineID", timesheetLineID);

    UriBuilder uriBuilder =
        UriBuilder.fromUri(
            apiClient.getBasePath() + "/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}");
    String url = uriBuilder.buildFromMap(uriVariables).toString();
    GenericUrl genericUrl = new GenericUrl(url);
    if (logger.isDebugEnabled()) {
      logger.debug("PUT " + genericUrl.toString());
    }

    HttpContent content = null;
    content = apiClient.new JacksonJsonHttpContent(timesheetLine);

    Credential credential =
        new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
    HttpTransport transport = apiClient.getHttpTransport();
    HttpRequestFactory requestFactory = transport.createRequestFactory(credential);
    return requestFactory
        .buildRequest(HttpMethods.PUT, genericUrl, content)
        .setHeaders(headers)
        .setConnectTimeout(apiClient.getConnectionTimeout())
        .setReadTimeout(apiClient.getReadTimeout())
        .execute();
  }

  /**
   * convert intput to byte array
   *
   * @param is InputStream the server status code returned
   * @return byteArrayInputStream a ByteArrayInputStream
   * @throws IOException for failed or interrupted I/O operations
   */
  public ByteArrayInputStream convertInputToByteArray(InputStream is) throws IOException {
    byte[] bytes = IOUtils.toByteArray(is);
    try {
      // Process the input stream..
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
      return byteArrayInputStream;
    } finally {
      is.close();
    }
  }
}
