/*
 * Xero Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

/** PurchaseOrder */
public class PurchaseOrder {
  StringUtil util = new StringUtil();

  @JsonProperty("Contact")
  private Contact contact;

  @JsonProperty("LineItems")
  private List<LineItem> lineItems = new ArrayList<LineItem>();

  @JsonProperty("Date")
  private String date;

  @JsonProperty("DeliveryDate")
  private String deliveryDate;

  @JsonProperty("LineAmountTypes")
  private LineAmountTypes lineAmountTypes;

  @JsonProperty("PurchaseOrderNumber")
  private String purchaseOrderNumber;

  @JsonProperty("Reference")
  private String reference;

  @JsonProperty("BrandingThemeID")
  private UUID brandingThemeID;

  @JsonProperty("CurrencyCode")
  private CurrencyCode currencyCode;
  /** See Purchase Order Status Codes */
  public enum StatusEnum {
    /** DRAFT */
    DRAFT("DRAFT"),

    /** SUBMITTED */
    SUBMITTED("SUBMITTED"),

    /** AUTHORISED */
    AUTHORISED("AUTHORISED"),

    /** BILLED */
    BILLED("BILLED"),

    /** DELETED */
    DELETED("DELETED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("Status")
  private StatusEnum status;

  @JsonProperty("SentToContact")
  private Boolean sentToContact;

  @JsonProperty("DeliveryAddress")
  private String deliveryAddress;

  @JsonProperty("AttentionTo")
  private String attentionTo;

  @JsonProperty("Telephone")
  private String telephone;

  @JsonProperty("DeliveryInstructions")
  private String deliveryInstructions;

  @JsonProperty("ExpectedArrivalDate")
  private String expectedArrivalDate;

  @JsonProperty("PurchaseOrderID")
  private UUID purchaseOrderID;

  @JsonProperty("CurrencyRate")
  private Double currencyRate;

  @JsonProperty("SubTotal")
  private Double subTotal;

  @JsonProperty("TotalTax")
  private Double totalTax;

  @JsonProperty("Total")
  private Double total;

  @JsonProperty("TotalDiscount")
  private Double totalDiscount;

  @JsonProperty("HasAttachments")
  private Boolean hasAttachments = false;

  @JsonProperty("UpdatedDateUTC")
  private String updatedDateUTC;

  @JsonProperty("StatusAttributeString")
  private String statusAttributeString;

  @JsonProperty("ValidationErrors")
  private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

  @JsonProperty("Warnings")
  private List<ValidationError> warnings = new ArrayList<ValidationError>();

  @JsonProperty("Attachments")
  private List<Attachment> attachments = new ArrayList<Attachment>();
  /**
   * contact
   *
   * @param contact Contact
   * @return PurchaseOrder
   */
  public PurchaseOrder contact(Contact contact) {
    this.contact = contact;
    return this;
  }

  /**
   * Get contact
   *
   * @return contact
   */
  @ApiModelProperty(value = "")
  /**
   * contact
   *
   * @return contact Contact
   */
  public Contact getContact() {
    return contact;
  }

  /**
   * contact
   *
   * @param contact Contact
   */
  public void setContact(Contact contact) {
    this.contact = contact;
  }

  /**
   * See LineItems
   *
   * @param lineItems List&lt;LineItem&gt;
   * @return PurchaseOrder
   */
  public PurchaseOrder lineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  /**
   * See LineItems
   *
   * @param lineItemsItem LineItem
   * @return PurchaseOrder
   */
  public PurchaseOrder addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<LineItem>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

  /**
   * See LineItems
   *
   * @return lineItems
   */
  @ApiModelProperty(value = "See LineItems")
  /**
   * See LineItems
   *
   * @return lineItems List<LineItem>
   */
  public List<LineItem> getLineItems() {
    return lineItems;
  }

  /**
   * See LineItems
   *
   * @param lineItems List&lt;LineItem&gt;
   */
  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }

  /**
   * Date purchase order was issued – YYYY-MM-DD. If the Date element is not specified then it will
   * default to the current date based on the timezone setting of the organisation
   *
   * @param date String
   * @return PurchaseOrder
   */
  public PurchaseOrder date(String date) {
    this.date = date;
    return this;
  }

  /**
   * Date purchase order was issued – YYYY-MM-DD. If the Date element is not specified then it will
   * default to the current date based on the timezone setting of the organisation
   *
   * @return date
   */
  @ApiModelProperty(
      value =
          "Date purchase order was issued – YYYY-MM-DD. If the Date element is not specified then"
              + " it will default to the current date based on the timezone setting of the"
              + " organisation")
  /**
   * Date purchase order was issued – YYYY-MM-DD. If the Date element is not specified then it will
   * default to the current date based on the timezone setting of the organisation
   *
   * @return date String
   */
  public String getDate() {
    return date;
  }
  /**
   * Date purchase order was issued – YYYY-MM-DD. If the Date element is not specified then it will
   * default to the current date based on the timezone setting of the organisation
   *
   * @return LocalDate
   */
  public LocalDate getDateAsDate() {
    if (this.date != null) {
      try {
        return util.convertStringToDate(this.date);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * Date purchase order was issued – YYYY-MM-DD. If the Date element is not specified then it will
   * default to the current date based on the timezone setting of the organisation
   *
   * @param date String
   */
  public void setDate(String date) {
    this.date = date;
  }

  /**
   * Date purchase order was issued – YYYY-MM-DD. If the Date element is not specified then it will
   * default to the current date based on the timezone setting of the organisation
   *
   * @param date LocalDateTime
   */
  public void setDate(LocalDate date) {
    // CONVERT LocalDate args into MS DateFromat String
    Instant instant = date.atStartOfDay(ZoneId.of("UTC").normalized()).toInstant();
    long timeInMillis = instant.toEpochMilli();

    this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
  }

  /**
   * Date the goods are to be delivered – YYYY-MM-DD
   *
   * @param deliveryDate String
   * @return PurchaseOrder
   */
  public PurchaseOrder deliveryDate(String deliveryDate) {
    this.deliveryDate = deliveryDate;
    return this;
  }

  /**
   * Date the goods are to be delivered – YYYY-MM-DD
   *
   * @return deliveryDate
   */
  @ApiModelProperty(value = "Date the goods are to be delivered – YYYY-MM-DD")
  /**
   * Date the goods are to be delivered – YYYY-MM-DD
   *
   * @return deliveryDate String
   */
  public String getDeliveryDate() {
    return deliveryDate;
  }
  /**
   * Date the goods are to be delivered – YYYY-MM-DD
   *
   * @return LocalDate
   */
  public LocalDate getDeliveryDateAsDate() {
    if (this.deliveryDate != null) {
      try {
        return util.convertStringToDate(this.deliveryDate);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * Date the goods are to be delivered – YYYY-MM-DD
   *
   * @param deliveryDate String
   */
  public void setDeliveryDate(String deliveryDate) {
    this.deliveryDate = deliveryDate;
  }

  /**
   * Date the goods are to be delivered – YYYY-MM-DD
   *
   * @param deliveryDate LocalDateTime
   */
  public void setDeliveryDate(LocalDate deliveryDate) {
    // CONVERT LocalDate args into MS DateFromat String
    Instant instant = deliveryDate.atStartOfDay(ZoneId.of("UTC").normalized()).toInstant();
    long timeInMillis = instant.toEpochMilli();

    this.deliveryDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
  }

  /**
   * lineAmountTypes
   *
   * @param lineAmountTypes LineAmountTypes
   * @return PurchaseOrder
   */
  public PurchaseOrder lineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
    return this;
  }

  /**
   * Get lineAmountTypes
   *
   * @return lineAmountTypes
   */
  @ApiModelProperty(value = "")
  /**
   * lineAmountTypes
   *
   * @return lineAmountTypes LineAmountTypes
   */
  public LineAmountTypes getLineAmountTypes() {
    return lineAmountTypes;
  }

  /**
   * lineAmountTypes
   *
   * @param lineAmountTypes LineAmountTypes
   */
  public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
  }

  /**
   * Unique alpha numeric code identifying purchase order (when missing will auto-generate from your
   * Organisation Invoice Settings)
   *
   * @param purchaseOrderNumber String
   * @return PurchaseOrder
   */
  public PurchaseOrder purchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
    return this;
  }

  /**
   * Unique alpha numeric code identifying purchase order (when missing will auto-generate from your
   * Organisation Invoice Settings)
   *
   * @return purchaseOrderNumber
   */
  @ApiModelProperty(
      value =
          "Unique alpha numeric code identifying purchase order (when missing will auto-generate"
              + " from your Organisation Invoice Settings)")
  /**
   * Unique alpha numeric code identifying purchase order (when missing will auto-generate from your
   * Organisation Invoice Settings)
   *
   * @return purchaseOrderNumber String
   */
  public String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  /**
   * Unique alpha numeric code identifying purchase order (when missing will auto-generate from your
   * Organisation Invoice Settings)
   *
   * @param purchaseOrderNumber String
   */
  public void setPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  /**
   * Additional reference number
   *
   * @param reference String
   * @return PurchaseOrder
   */
  public PurchaseOrder reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * Additional reference number
   *
   * @return reference
   */
  @ApiModelProperty(value = "Additional reference number")
  /**
   * Additional reference number
   *
   * @return reference String
   */
  public String getReference() {
    return reference;
  }

  /**
   * Additional reference number
   *
   * @param reference String
   */
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * See BrandingThemes
   *
   * @param brandingThemeID UUID
   * @return PurchaseOrder
   */
  public PurchaseOrder brandingThemeID(UUID brandingThemeID) {
    this.brandingThemeID = brandingThemeID;
    return this;
  }

  /**
   * See BrandingThemes
   *
   * @return brandingThemeID
   */
  @ApiModelProperty(value = "See BrandingThemes")
  /**
   * See BrandingThemes
   *
   * @return brandingThemeID UUID
   */
  public UUID getBrandingThemeID() {
    return brandingThemeID;
  }

  /**
   * See BrandingThemes
   *
   * @param brandingThemeID UUID
   */
  public void setBrandingThemeID(UUID brandingThemeID) {
    this.brandingThemeID = brandingThemeID;
  }

  /**
   * currencyCode
   *
   * @param currencyCode CurrencyCode
   * @return PurchaseOrder
   */
  public PurchaseOrder currencyCode(CurrencyCode currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Get currencyCode
   *
   * @return currencyCode
   */
  @ApiModelProperty(value = "")
  /**
   * currencyCode
   *
   * @return currencyCode CurrencyCode
   */
  public CurrencyCode getCurrencyCode() {
    return currencyCode;
  }

  /**
   * currencyCode
   *
   * @param currencyCode CurrencyCode
   */
  public void setCurrencyCode(CurrencyCode currencyCode) {
    this.currencyCode = currencyCode;
  }

  /**
   * See Purchase Order Status Codes
   *
   * @param status StatusEnum
   * @return PurchaseOrder
   */
  public PurchaseOrder status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * See Purchase Order Status Codes
   *
   * @return status
   */
  @ApiModelProperty(value = "See Purchase Order Status Codes")
  /**
   * See Purchase Order Status Codes
   *
   * @return status StatusEnum
   */
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * See Purchase Order Status Codes
   *
   * @param status StatusEnum
   */
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * Boolean to set whether the purchase order should be marked as “sent”. This can be set only on
   * purchase orders that have been approved or billed
   *
   * @param sentToContact Boolean
   * @return PurchaseOrder
   */
  public PurchaseOrder sentToContact(Boolean sentToContact) {
    this.sentToContact = sentToContact;
    return this;
  }

  /**
   * Boolean to set whether the purchase order should be marked as “sent”. This can be set only on
   * purchase orders that have been approved or billed
   *
   * @return sentToContact
   */
  @ApiModelProperty(
      value =
          "Boolean to set whether the purchase order should be marked as “sent”. This can be set"
              + " only on purchase orders that have been approved or billed")
  /**
   * Boolean to set whether the purchase order should be marked as “sent”. This can be set only on
   * purchase orders that have been approved or billed
   *
   * @return sentToContact Boolean
   */
  public Boolean getSentToContact() {
    return sentToContact;
  }

  /**
   * Boolean to set whether the purchase order should be marked as “sent”. This can be set only on
   * purchase orders that have been approved or billed
   *
   * @param sentToContact Boolean
   */
  public void setSentToContact(Boolean sentToContact) {
    this.sentToContact = sentToContact;
  }

  /**
   * The address the goods are to be delivered to
   *
   * @param deliveryAddress String
   * @return PurchaseOrder
   */
  public PurchaseOrder deliveryAddress(String deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
    return this;
  }

  /**
   * The address the goods are to be delivered to
   *
   * @return deliveryAddress
   */
  @ApiModelProperty(value = "The address the goods are to be delivered to")
  /**
   * The address the goods are to be delivered to
   *
   * @return deliveryAddress String
   */
  public String getDeliveryAddress() {
    return deliveryAddress;
  }

  /**
   * The address the goods are to be delivered to
   *
   * @param deliveryAddress String
   */
  public void setDeliveryAddress(String deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
  }

  /**
   * The person that the delivery is going to
   *
   * @param attentionTo String
   * @return PurchaseOrder
   */
  public PurchaseOrder attentionTo(String attentionTo) {
    this.attentionTo = attentionTo;
    return this;
  }

  /**
   * The person that the delivery is going to
   *
   * @return attentionTo
   */
  @ApiModelProperty(value = "The person that the delivery is going to")
  /**
   * The person that the delivery is going to
   *
   * @return attentionTo String
   */
  public String getAttentionTo() {
    return attentionTo;
  }

  /**
   * The person that the delivery is going to
   *
   * @param attentionTo String
   */
  public void setAttentionTo(String attentionTo) {
    this.attentionTo = attentionTo;
  }

  /**
   * The phone number for the person accepting the delivery
   *
   * @param telephone String
   * @return PurchaseOrder
   */
  public PurchaseOrder telephone(String telephone) {
    this.telephone = telephone;
    return this;
  }

  /**
   * The phone number for the person accepting the delivery
   *
   * @return telephone
   */
  @ApiModelProperty(value = "The phone number for the person accepting the delivery")
  /**
   * The phone number for the person accepting the delivery
   *
   * @return telephone String
   */
  public String getTelephone() {
    return telephone;
  }

  /**
   * The phone number for the person accepting the delivery
   *
   * @param telephone String
   */
  public void setTelephone(String telephone) {
    this.telephone = telephone;
  }

  /**
   * A free text feild for instructions (500 characters max)
   *
   * @param deliveryInstructions String
   * @return PurchaseOrder
   */
  public PurchaseOrder deliveryInstructions(String deliveryInstructions) {
    this.deliveryInstructions = deliveryInstructions;
    return this;
  }

  /**
   * A free text feild for instructions (500 characters max)
   *
   * @return deliveryInstructions
   */
  @ApiModelProperty(value = "A free text feild for instructions (500 characters max)")
  /**
   * A free text feild for instructions (500 characters max)
   *
   * @return deliveryInstructions String
   */
  public String getDeliveryInstructions() {
    return deliveryInstructions;
  }

  /**
   * A free text feild for instructions (500 characters max)
   *
   * @param deliveryInstructions String
   */
  public void setDeliveryInstructions(String deliveryInstructions) {
    this.deliveryInstructions = deliveryInstructions;
  }

  /**
   * The date the goods are expected to arrive.
   *
   * @param expectedArrivalDate String
   * @return PurchaseOrder
   */
  public PurchaseOrder expectedArrivalDate(String expectedArrivalDate) {
    this.expectedArrivalDate = expectedArrivalDate;
    return this;
  }

  /**
   * The date the goods are expected to arrive.
   *
   * @return expectedArrivalDate
   */
  @ApiModelProperty(value = "The date the goods are expected to arrive.")
  /**
   * The date the goods are expected to arrive.
   *
   * @return expectedArrivalDate String
   */
  public String getExpectedArrivalDate() {
    return expectedArrivalDate;
  }
  /**
   * The date the goods are expected to arrive.
   *
   * @return LocalDate
   */
  public LocalDate getExpectedArrivalDateAsDate() {
    if (this.expectedArrivalDate != null) {
      try {
        return util.convertStringToDate(this.expectedArrivalDate);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * The date the goods are expected to arrive.
   *
   * @param expectedArrivalDate String
   */
  public void setExpectedArrivalDate(String expectedArrivalDate) {
    this.expectedArrivalDate = expectedArrivalDate;
  }

  /**
   * The date the goods are expected to arrive.
   *
   * @param expectedArrivalDate LocalDateTime
   */
  public void setExpectedArrivalDate(LocalDate expectedArrivalDate) {
    // CONVERT LocalDate args into MS DateFromat String
    Instant instant = expectedArrivalDate.atStartOfDay(ZoneId.of("UTC").normalized()).toInstant();
    long timeInMillis = instant.toEpochMilli();

    this.expectedArrivalDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
  }

  /**
   * Xero generated unique identifier for purchase order
   *
   * @param purchaseOrderID UUID
   * @return PurchaseOrder
   */
  public PurchaseOrder purchaseOrderID(UUID purchaseOrderID) {
    this.purchaseOrderID = purchaseOrderID;
    return this;
  }

  /**
   * Xero generated unique identifier for purchase order
   *
   * @return purchaseOrderID
   */
  @ApiModelProperty(value = "Xero generated unique identifier for purchase order")
  /**
   * Xero generated unique identifier for purchase order
   *
   * @return purchaseOrderID UUID
   */
  public UUID getPurchaseOrderID() {
    return purchaseOrderID;
  }

  /**
   * Xero generated unique identifier for purchase order
   *
   * @param purchaseOrderID UUID
   */
  public void setPurchaseOrderID(UUID purchaseOrderID) {
    this.purchaseOrderID = purchaseOrderID;
  }

  /**
   * The currency rate for a multicurrency purchase order. If no rate is specified, the XE.com day
   * rate is used.
   *
   * @param currencyRate Double
   * @return PurchaseOrder
   */
  public PurchaseOrder currencyRate(Double currencyRate) {
    this.currencyRate = currencyRate;
    return this;
  }

  /**
   * The currency rate for a multicurrency purchase order. If no rate is specified, the XE.com day
   * rate is used.
   *
   * @return currencyRate
   */
  @ApiModelProperty(
      value =
          "The currency rate for a multicurrency purchase order. If no rate is specified, the"
              + " XE.com day rate is used.")
  /**
   * The currency rate for a multicurrency purchase order. If no rate is specified, the XE.com day
   * rate is used.
   *
   * @return currencyRate Double
   */
  public Double getCurrencyRate() {
    return currencyRate;
  }

  /**
   * The currency rate for a multicurrency purchase order. If no rate is specified, the XE.com day
   * rate is used.
   *
   * @param currencyRate Double
   */
  public void setCurrencyRate(Double currencyRate) {
    this.currencyRate = currencyRate;
  }

  /**
   * Total of purchase order excluding taxes
   *
   * @return subTotal
   */
  @ApiModelProperty(value = "Total of purchase order excluding taxes")
  /**
   * Total of purchase order excluding taxes
   *
   * @return subTotal Double
   */
  public Double getSubTotal() {
    return subTotal;
  }

  /**
   * Total tax on purchase order
   *
   * @return totalTax
   */
  @ApiModelProperty(value = "Total tax on purchase order")
  /**
   * Total tax on purchase order
   *
   * @return totalTax Double
   */
  public Double getTotalTax() {
    return totalTax;
  }

  /**
   * Total of Purchase Order tax inclusive (i.e. SubTotal + TotalTax)
   *
   * @return total
   */
  @ApiModelProperty(value = "Total of Purchase Order tax inclusive (i.e. SubTotal + TotalTax)")
  /**
   * Total of Purchase Order tax inclusive (i.e. SubTotal + TotalTax)
   *
   * @return total Double
   */
  public Double getTotal() {
    return total;
  }

  /**
   * Total of discounts applied on the purchase order line items
   *
   * @return totalDiscount
   */
  @ApiModelProperty(value = "Total of discounts applied on the purchase order line items")
  /**
   * Total of discounts applied on the purchase order line items
   *
   * @return totalDiscount Double
   */
  public Double getTotalDiscount() {
    return totalDiscount;
  }

  /**
   * boolean to indicate if a purchase order has an attachment
   *
   * @return hasAttachments
   */
  @ApiModelProperty(
      example = "false",
      value = "boolean to indicate if a purchase order has an attachment")
  /**
   * boolean to indicate if a purchase order has an attachment
   *
   * @return hasAttachments Boolean
   */
  public Boolean getHasAttachments() {
    return hasAttachments;
  }

  /**
   * Last modified date UTC format
   *
   * @return updatedDateUTC
   */
  @ApiModelProperty(example = "/Date(1573755038314)/", value = "Last modified date UTC format")
  /**
   * Last modified date UTC format
   *
   * @return updatedDateUTC String
   */
  public String getUpdatedDateUTC() {
    return updatedDateUTC;
  }
  /**
   * Last modified date UTC format
   *
   * @return OffsetDateTime
   */
  public OffsetDateTime getUpdatedDateUTCAsDate() {
    if (this.updatedDateUTC != null) {
      try {
        return util.convertStringToOffsetDateTime(this.updatedDateUTC);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * A string to indicate if a invoice status
   *
   * @param statusAttributeString String
   * @return PurchaseOrder
   */
  public PurchaseOrder statusAttributeString(String statusAttributeString) {
    this.statusAttributeString = statusAttributeString;
    return this;
  }

  /**
   * A string to indicate if a invoice status
   *
   * @return statusAttributeString
   */
  @ApiModelProperty(value = "A string to indicate if a invoice status")
  /**
   * A string to indicate if a invoice status
   *
   * @return statusAttributeString String
   */
  public String getStatusAttributeString() {
    return statusAttributeString;
  }

  /**
   * A string to indicate if a invoice status
   *
   * @param statusAttributeString String
   */
  public void setStatusAttributeString(String statusAttributeString) {
    this.statusAttributeString = statusAttributeString;
  }

  /**
   * Displays array of validation error messages from the API
   *
   * @param validationErrors List&lt;ValidationError&gt;
   * @return PurchaseOrder
   */
  public PurchaseOrder validationErrors(List<ValidationError> validationErrors) {
    this.validationErrors = validationErrors;
    return this;
  }

  /**
   * Displays array of validation error messages from the API
   *
   * @param validationErrorsItem ValidationError
   * @return PurchaseOrder
   */
  public PurchaseOrder addValidationErrorsItem(ValidationError validationErrorsItem) {
    if (this.validationErrors == null) {
      this.validationErrors = new ArrayList<ValidationError>();
    }
    this.validationErrors.add(validationErrorsItem);
    return this;
  }

  /**
   * Displays array of validation error messages from the API
   *
   * @return validationErrors
   */
  @ApiModelProperty(value = "Displays array of validation error messages from the API")
  /**
   * Displays array of validation error messages from the API
   *
   * @return validationErrors List<ValidationError>
   */
  public List<ValidationError> getValidationErrors() {
    return validationErrors;
  }

  /**
   * Displays array of validation error messages from the API
   *
   * @param validationErrors List&lt;ValidationError&gt;
   */
  public void setValidationErrors(List<ValidationError> validationErrors) {
    this.validationErrors = validationErrors;
  }

  /**
   * Displays array of warning messages from the API
   *
   * @param warnings List&lt;ValidationError&gt;
   * @return PurchaseOrder
   */
  public PurchaseOrder warnings(List<ValidationError> warnings) {
    this.warnings = warnings;
    return this;
  }

  /**
   * Displays array of warning messages from the API
   *
   * @param warningsItem ValidationError
   * @return PurchaseOrder
   */
  public PurchaseOrder addWarningsItem(ValidationError warningsItem) {
    if (this.warnings == null) {
      this.warnings = new ArrayList<ValidationError>();
    }
    this.warnings.add(warningsItem);
    return this;
  }

  /**
   * Displays array of warning messages from the API
   *
   * @return warnings
   */
  @ApiModelProperty(value = "Displays array of warning messages from the API")
  /**
   * Displays array of warning messages from the API
   *
   * @return warnings List<ValidationError>
   */
  public List<ValidationError> getWarnings() {
    return warnings;
  }

  /**
   * Displays array of warning messages from the API
   *
   * @param warnings List&lt;ValidationError&gt;
   */
  public void setWarnings(List<ValidationError> warnings) {
    this.warnings = warnings;
  }

  /**
   * Displays array of attachments from the API
   *
   * @param attachments List&lt;Attachment&gt;
   * @return PurchaseOrder
   */
  public PurchaseOrder attachments(List<Attachment> attachments) {
    this.attachments = attachments;
    return this;
  }

  /**
   * Displays array of attachments from the API
   *
   * @param attachmentsItem Attachment
   * @return PurchaseOrder
   */
  public PurchaseOrder addAttachmentsItem(Attachment attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<Attachment>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

  /**
   * Displays array of attachments from the API
   *
   * @return attachments
   */
  @ApiModelProperty(value = "Displays array of attachments from the API")
  /**
   * Displays array of attachments from the API
   *
   * @return attachments List<Attachment>
   */
  public List<Attachment> getAttachments() {
    return attachments;
  }

  /**
   * Displays array of attachments from the API
   *
   * @param attachments List&lt;Attachment&gt;
   */
  public void setAttachments(List<Attachment> attachments) {
    this.attachments = attachments;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PurchaseOrder purchaseOrder = (PurchaseOrder) o;
    return Objects.equals(this.contact, purchaseOrder.contact)
        && Objects.equals(this.lineItems, purchaseOrder.lineItems)
        && Objects.equals(this.date, purchaseOrder.date)
        && Objects.equals(this.deliveryDate, purchaseOrder.deliveryDate)
        && Objects.equals(this.lineAmountTypes, purchaseOrder.lineAmountTypes)
        && Objects.equals(this.purchaseOrderNumber, purchaseOrder.purchaseOrderNumber)
        && Objects.equals(this.reference, purchaseOrder.reference)
        && Objects.equals(this.brandingThemeID, purchaseOrder.brandingThemeID)
        && Objects.equals(this.currencyCode, purchaseOrder.currencyCode)
        && Objects.equals(this.status, purchaseOrder.status)
        && Objects.equals(this.sentToContact, purchaseOrder.sentToContact)
        && Objects.equals(this.deliveryAddress, purchaseOrder.deliveryAddress)
        && Objects.equals(this.attentionTo, purchaseOrder.attentionTo)
        && Objects.equals(this.telephone, purchaseOrder.telephone)
        && Objects.equals(this.deliveryInstructions, purchaseOrder.deliveryInstructions)
        && Objects.equals(this.expectedArrivalDate, purchaseOrder.expectedArrivalDate)
        && Objects.equals(this.purchaseOrderID, purchaseOrder.purchaseOrderID)
        && Objects.equals(this.currencyRate, purchaseOrder.currencyRate)
        && Objects.equals(this.subTotal, purchaseOrder.subTotal)
        && Objects.equals(this.totalTax, purchaseOrder.totalTax)
        && Objects.equals(this.total, purchaseOrder.total)
        && Objects.equals(this.totalDiscount, purchaseOrder.totalDiscount)
        && Objects.equals(this.hasAttachments, purchaseOrder.hasAttachments)
        && Objects.equals(this.updatedDateUTC, purchaseOrder.updatedDateUTC)
        && Objects.equals(this.statusAttributeString, purchaseOrder.statusAttributeString)
        && Objects.equals(this.validationErrors, purchaseOrder.validationErrors)
        && Objects.equals(this.warnings, purchaseOrder.warnings)
        && Objects.equals(this.attachments, purchaseOrder.attachments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        contact,
        lineItems,
        date,
        deliveryDate,
        lineAmountTypes,
        purchaseOrderNumber,
        reference,
        brandingThemeID,
        currencyCode,
        status,
        sentToContact,
        deliveryAddress,
        attentionTo,
        telephone,
        deliveryInstructions,
        expectedArrivalDate,
        purchaseOrderID,
        currencyRate,
        subTotal,
        totalTax,
        total,
        totalDiscount,
        hasAttachments,
        updatedDateUTC,
        statusAttributeString,
        validationErrors,
        warnings,
        attachments);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PurchaseOrder {\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    deliveryDate: ").append(toIndentedString(deliveryDate)).append("\n");
    sb.append("    lineAmountTypes: ").append(toIndentedString(lineAmountTypes)).append("\n");
    sb.append("    purchaseOrderNumber: ")
        .append(toIndentedString(purchaseOrderNumber))
        .append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    brandingThemeID: ").append(toIndentedString(brandingThemeID)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    sentToContact: ").append(toIndentedString(sentToContact)).append("\n");
    sb.append("    deliveryAddress: ").append(toIndentedString(deliveryAddress)).append("\n");
    sb.append("    attentionTo: ").append(toIndentedString(attentionTo)).append("\n");
    sb.append("    telephone: ").append(toIndentedString(telephone)).append("\n");
    sb.append("    deliveryInstructions: ")
        .append(toIndentedString(deliveryInstructions))
        .append("\n");
    sb.append("    expectedArrivalDate: ")
        .append(toIndentedString(expectedArrivalDate))
        .append("\n");
    sb.append("    purchaseOrderID: ").append(toIndentedString(purchaseOrderID)).append("\n");
    sb.append("    currencyRate: ").append(toIndentedString(currencyRate)).append("\n");
    sb.append("    subTotal: ").append(toIndentedString(subTotal)).append("\n");
    sb.append("    totalTax: ").append(toIndentedString(totalTax)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    totalDiscount: ").append(toIndentedString(totalDiscount)).append("\n");
    sb.append("    hasAttachments: ").append(toIndentedString(hasAttachments)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    statusAttributeString: ")
        .append(toIndentedString(statusAttributeString))
        .append("\n");
    sb.append("    validationErrors: ").append(toIndentedString(validationErrors)).append("\n");
    sb.append("    warnings: ").append(toIndentedString(warnings)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
