/*
 * Xero Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

/** RepeatingInvoice */
public class RepeatingInvoice {
  StringUtil util = new StringUtil();
  /** See Invoice Types */
  public enum TypeEnum {
    /** ACCPAY */
    ACCPAY("ACCPAY"),

    /** ACCREC */
    ACCREC("ACCREC");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("Type")
  private TypeEnum type;

  @JsonProperty("Contact")
  private Contact contact;

  @JsonProperty("Schedule")
  private Schedule schedule;

  @JsonProperty("LineItems")
  private List<LineItem> lineItems = new ArrayList<LineItem>();

  @JsonProperty("LineAmountTypes")
  private LineAmountTypes lineAmountTypes;

  @JsonProperty("Reference")
  private String reference;

  @JsonProperty("BrandingThemeID")
  private UUID brandingThemeID;

  @JsonProperty("CurrencyCode")
  private CurrencyCode currencyCode;
  /** One of the following - DRAFT or AUTHORISED – See Invoice Status Codes */
  public enum StatusEnum {
    /** DRAFT */
    DRAFT("DRAFT"),

    /** AUTHORISED */
    AUTHORISED("AUTHORISED"),

    /** DELETED */
    DELETED("DELETED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("Status")
  private StatusEnum status;

  @JsonProperty("SubTotal")
  private Double subTotal;

  @JsonProperty("TotalTax")
  private Double totalTax;

  @JsonProperty("Total")
  private Double total;

  @JsonProperty("RepeatingInvoiceID")
  private UUID repeatingInvoiceID;

  @JsonProperty("ID")
  private UUID ID;

  @JsonProperty("HasAttachments")
  private Boolean hasAttachments = false;

  @JsonProperty("Attachments")
  private List<Attachment> attachments = new ArrayList<Attachment>();

  @JsonProperty("ApprovedForSending")
  private Boolean approvedForSending = false;

  @JsonProperty("SendCopy")
  private Boolean sendCopy = false;

  @JsonProperty("MarkAsSent")
  private Boolean markAsSent = false;

  @JsonProperty("IncludePDF")
  private Boolean includePDF = false;
  /**
   * See Invoice Types
   *
   * @param type TypeEnum
   * @return RepeatingInvoice
   */
  public RepeatingInvoice type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * See Invoice Types
   *
   * @return type
   */
  @ApiModelProperty(value = "See Invoice Types")
  /**
   * See Invoice Types
   *
   * @return type TypeEnum
   */
  public TypeEnum getType() {
    return type;
  }

  /**
   * See Invoice Types
   *
   * @param type TypeEnum
   */
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * contact
   *
   * @param contact Contact
   * @return RepeatingInvoice
   */
  public RepeatingInvoice contact(Contact contact) {
    this.contact = contact;
    return this;
  }

  /**
   * Get contact
   *
   * @return contact
   */
  @ApiModelProperty(value = "")
  /**
   * contact
   *
   * @return contact Contact
   */
  public Contact getContact() {
    return contact;
  }

  /**
   * contact
   *
   * @param contact Contact
   */
  public void setContact(Contact contact) {
    this.contact = contact;
  }

  /**
   * schedule
   *
   * @param schedule Schedule
   * @return RepeatingInvoice
   */
  public RepeatingInvoice schedule(Schedule schedule) {
    this.schedule = schedule;
    return this;
  }

  /**
   * Get schedule
   *
   * @return schedule
   */
  @ApiModelProperty(value = "")
  /**
   * schedule
   *
   * @return schedule Schedule
   */
  public Schedule getSchedule() {
    return schedule;
  }

  /**
   * schedule
   *
   * @param schedule Schedule
   */
  public void setSchedule(Schedule schedule) {
    this.schedule = schedule;
  }

  /**
   * See LineItems
   *
   * @param lineItems List&lt;LineItem&gt;
   * @return RepeatingInvoice
   */
  public RepeatingInvoice lineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  /**
   * See LineItems
   *
   * @param lineItemsItem LineItem
   * @return RepeatingInvoice
   */
  public RepeatingInvoice addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<LineItem>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

  /**
   * See LineItems
   *
   * @return lineItems
   */
  @ApiModelProperty(value = "See LineItems")
  /**
   * See LineItems
   *
   * @return lineItems List<LineItem>
   */
  public List<LineItem> getLineItems() {
    return lineItems;
  }

  /**
   * See LineItems
   *
   * @param lineItems List&lt;LineItem&gt;
   */
  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }

  /**
   * lineAmountTypes
   *
   * @param lineAmountTypes LineAmountTypes
   * @return RepeatingInvoice
   */
  public RepeatingInvoice lineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
    return this;
  }

  /**
   * Get lineAmountTypes
   *
   * @return lineAmountTypes
   */
  @ApiModelProperty(value = "")
  /**
   * lineAmountTypes
   *
   * @return lineAmountTypes LineAmountTypes
   */
  public LineAmountTypes getLineAmountTypes() {
    return lineAmountTypes;
  }

  /**
   * lineAmountTypes
   *
   * @param lineAmountTypes LineAmountTypes
   */
  public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
  }

  /**
   * ACCREC only – additional reference number
   *
   * @param reference String
   * @return RepeatingInvoice
   */
  public RepeatingInvoice reference(String reference) {
    this.reference = reference;
    return this;
  }

  /**
   * ACCREC only – additional reference number
   *
   * @return reference
   */
  @ApiModelProperty(value = "ACCREC only – additional reference number")
  /**
   * ACCREC only – additional reference number
   *
   * @return reference String
   */
  public String getReference() {
    return reference;
  }

  /**
   * ACCREC only – additional reference number
   *
   * @param reference String
   */
  public void setReference(String reference) {
    this.reference = reference;
  }

  /**
   * See BrandingThemes
   *
   * @param brandingThemeID UUID
   * @return RepeatingInvoice
   */
  public RepeatingInvoice brandingThemeID(UUID brandingThemeID) {
    this.brandingThemeID = brandingThemeID;
    return this;
  }

  /**
   * See BrandingThemes
   *
   * @return brandingThemeID
   */
  @ApiModelProperty(value = "See BrandingThemes")
  /**
   * See BrandingThemes
   *
   * @return brandingThemeID UUID
   */
  public UUID getBrandingThemeID() {
    return brandingThemeID;
  }

  /**
   * See BrandingThemes
   *
   * @param brandingThemeID UUID
   */
  public void setBrandingThemeID(UUID brandingThemeID) {
    this.brandingThemeID = brandingThemeID;
  }

  /**
   * currencyCode
   *
   * @param currencyCode CurrencyCode
   * @return RepeatingInvoice
   */
  public RepeatingInvoice currencyCode(CurrencyCode currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Get currencyCode
   *
   * @return currencyCode
   */
  @ApiModelProperty(value = "")
  /**
   * currencyCode
   *
   * @return currencyCode CurrencyCode
   */
  public CurrencyCode getCurrencyCode() {
    return currencyCode;
  }

  /**
   * currencyCode
   *
   * @param currencyCode CurrencyCode
   */
  public void setCurrencyCode(CurrencyCode currencyCode) {
    this.currencyCode = currencyCode;
  }

  /**
   * One of the following - DRAFT or AUTHORISED – See Invoice Status Codes
   *
   * @param status StatusEnum
   * @return RepeatingInvoice
   */
  public RepeatingInvoice status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * One of the following - DRAFT or AUTHORISED – See Invoice Status Codes
   *
   * @return status
   */
  @ApiModelProperty(value = "One of the following - DRAFT or AUTHORISED – See Invoice Status Codes")
  /**
   * One of the following - DRAFT or AUTHORISED – See Invoice Status Codes
   *
   * @return status StatusEnum
   */
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * One of the following - DRAFT or AUTHORISED – See Invoice Status Codes
   *
   * @param status StatusEnum
   */
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * Total of invoice excluding taxes
   *
   * @param subTotal Double
   * @return RepeatingInvoice
   */
  public RepeatingInvoice subTotal(Double subTotal) {
    this.subTotal = subTotal;
    return this;
  }

  /**
   * Total of invoice excluding taxes
   *
   * @return subTotal
   */
  @ApiModelProperty(value = "Total of invoice excluding taxes")
  /**
   * Total of invoice excluding taxes
   *
   * @return subTotal Double
   */
  public Double getSubTotal() {
    return subTotal;
  }

  /**
   * Total of invoice excluding taxes
   *
   * @param subTotal Double
   */
  public void setSubTotal(Double subTotal) {
    this.subTotal = subTotal;
  }

  /**
   * Total tax on invoice
   *
   * @param totalTax Double
   * @return RepeatingInvoice
   */
  public RepeatingInvoice totalTax(Double totalTax) {
    this.totalTax = totalTax;
    return this;
  }

  /**
   * Total tax on invoice
   *
   * @return totalTax
   */
  @ApiModelProperty(value = "Total tax on invoice")
  /**
   * Total tax on invoice
   *
   * @return totalTax Double
   */
  public Double getTotalTax() {
    return totalTax;
  }

  /**
   * Total tax on invoice
   *
   * @param totalTax Double
   */
  public void setTotalTax(Double totalTax) {
    this.totalTax = totalTax;
  }

  /**
   * Total of Invoice tax inclusive (i.e. SubTotal + TotalTax)
   *
   * @param total Double
   * @return RepeatingInvoice
   */
  public RepeatingInvoice total(Double total) {
    this.total = total;
    return this;
  }

  /**
   * Total of Invoice tax inclusive (i.e. SubTotal + TotalTax)
   *
   * @return total
   */
  @ApiModelProperty(value = "Total of Invoice tax inclusive (i.e. SubTotal + TotalTax)")
  /**
   * Total of Invoice tax inclusive (i.e. SubTotal + TotalTax)
   *
   * @return total Double
   */
  public Double getTotal() {
    return total;
  }

  /**
   * Total of Invoice tax inclusive (i.e. SubTotal + TotalTax)
   *
   * @param total Double
   */
  public void setTotal(Double total) {
    this.total = total;
  }

  /**
   * Xero generated unique identifier for repeating invoice template
   *
   * @param repeatingInvoiceID UUID
   * @return RepeatingInvoice
   */
  public RepeatingInvoice repeatingInvoiceID(UUID repeatingInvoiceID) {
    this.repeatingInvoiceID = repeatingInvoiceID;
    return this;
  }

  /**
   * Xero generated unique identifier for repeating invoice template
   *
   * @return repeatingInvoiceID
   */
  @ApiModelProperty(value = "Xero generated unique identifier for repeating invoice template")
  /**
   * Xero generated unique identifier for repeating invoice template
   *
   * @return repeatingInvoiceID UUID
   */
  public UUID getRepeatingInvoiceID() {
    return repeatingInvoiceID;
  }

  /**
   * Xero generated unique identifier for repeating invoice template
   *
   * @param repeatingInvoiceID UUID
   */
  public void setRepeatingInvoiceID(UUID repeatingInvoiceID) {
    this.repeatingInvoiceID = repeatingInvoiceID;
  }

  /**
   * Xero generated unique identifier for repeating invoice template
   *
   * @param ID UUID
   * @return RepeatingInvoice
   */
  public RepeatingInvoice ID(UUID ID) {
    this.ID = ID;
    return this;
  }

  /**
   * Xero generated unique identifier for repeating invoice template
   *
   * @return ID
   */
  @ApiModelProperty(value = "Xero generated unique identifier for repeating invoice template")
  /**
   * Xero generated unique identifier for repeating invoice template
   *
   * @return ID UUID
   */
  public UUID getID() {
    return ID;
  }

  /**
   * Xero generated unique identifier for repeating invoice template
   *
   * @param ID UUID
   */
  public void setID(UUID ID) {
    this.ID = ID;
  }

  /**
   * Boolean to indicate if an invoice has an attachment
   *
   * @return hasAttachments
   */
  @ApiModelProperty(
      example = "false",
      value = "Boolean to indicate if an invoice has an attachment")
  /**
   * Boolean to indicate if an invoice has an attachment
   *
   * @return hasAttachments Boolean
   */
  public Boolean getHasAttachments() {
    return hasAttachments;
  }

  /**
   * Displays array of attachments from the API
   *
   * @param attachments List&lt;Attachment&gt;
   * @return RepeatingInvoice
   */
  public RepeatingInvoice attachments(List<Attachment> attachments) {
    this.attachments = attachments;
    return this;
  }

  /**
   * Displays array of attachments from the API
   *
   * @param attachmentsItem Attachment
   * @return RepeatingInvoice
   */
  public RepeatingInvoice addAttachmentsItem(Attachment attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<Attachment>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

  /**
   * Displays array of attachments from the API
   *
   * @return attachments
   */
  @ApiModelProperty(value = "Displays array of attachments from the API")
  /**
   * Displays array of attachments from the API
   *
   * @return attachments List<Attachment>
   */
  public List<Attachment> getAttachments() {
    return attachments;
  }

  /**
   * Displays array of attachments from the API
   *
   * @param attachments List&lt;Attachment&gt;
   */
  public void setAttachments(List<Attachment> attachments) {
    this.attachments = attachments;
  }

  /**
   * Boolean to indicate whether the invoice has been approved for sending
   *
   * @param approvedForSending Boolean
   * @return RepeatingInvoice
   */
  public RepeatingInvoice approvedForSending(Boolean approvedForSending) {
    this.approvedForSending = approvedForSending;
    return this;
  }

  /**
   * Boolean to indicate whether the invoice has been approved for sending
   *
   * @return approvedForSending
   */
  @ApiModelProperty(
      example = "false",
      value = "Boolean to indicate whether the invoice has been approved for sending")
  /**
   * Boolean to indicate whether the invoice has been approved for sending
   *
   * @return approvedForSending Boolean
   */
  public Boolean getApprovedForSending() {
    return approvedForSending;
  }

  /**
   * Boolean to indicate whether the invoice has been approved for sending
   *
   * @param approvedForSending Boolean
   */
  public void setApprovedForSending(Boolean approvedForSending) {
    this.approvedForSending = approvedForSending;
  }

  /**
   * Boolean to indicate whether a copy is sent to sender&#39;s email
   *
   * @param sendCopy Boolean
   * @return RepeatingInvoice
   */
  public RepeatingInvoice sendCopy(Boolean sendCopy) {
    this.sendCopy = sendCopy;
    return this;
  }

  /**
   * Boolean to indicate whether a copy is sent to sender&#39;s email
   *
   * @return sendCopy
   */
  @ApiModelProperty(
      example = "false",
      value = "Boolean to indicate whether a copy is sent to sender's email")
  /**
   * Boolean to indicate whether a copy is sent to sender&#39;s email
   *
   * @return sendCopy Boolean
   */
  public Boolean getSendCopy() {
    return sendCopy;
  }

  /**
   * Boolean to indicate whether a copy is sent to sender&#39;s email
   *
   * @param sendCopy Boolean
   */
  public void setSendCopy(Boolean sendCopy) {
    this.sendCopy = sendCopy;
  }

  /**
   * Boolean to indicate whether the invoice in the Xero app displays as \&quot;sent\&quot;
   *
   * @param markAsSent Boolean
   * @return RepeatingInvoice
   */
  public RepeatingInvoice markAsSent(Boolean markAsSent) {
    this.markAsSent = markAsSent;
    return this;
  }

  /**
   * Boolean to indicate whether the invoice in the Xero app displays as \&quot;sent\&quot;
   *
   * @return markAsSent
   */
  @ApiModelProperty(
      example = "false",
      value = "Boolean to indicate whether the invoice in the Xero app displays as \"sent\"")
  /**
   * Boolean to indicate whether the invoice in the Xero app displays as \&quot;sent\&quot;
   *
   * @return markAsSent Boolean
   */
  public Boolean getMarkAsSent() {
    return markAsSent;
  }

  /**
   * Boolean to indicate whether the invoice in the Xero app displays as \&quot;sent\&quot;
   *
   * @param markAsSent Boolean
   */
  public void setMarkAsSent(Boolean markAsSent) {
    this.markAsSent = markAsSent;
  }

  /**
   * Boolean to indicate whether to include PDF attachment
   *
   * @param includePDF Boolean
   * @return RepeatingInvoice
   */
  public RepeatingInvoice includePDF(Boolean includePDF) {
    this.includePDF = includePDF;
    return this;
  }

  /**
   * Boolean to indicate whether to include PDF attachment
   *
   * @return includePDF
   */
  @ApiModelProperty(
      example = "false",
      value = "Boolean to indicate whether to include PDF attachment")
  /**
   * Boolean to indicate whether to include PDF attachment
   *
   * @return includePDF Boolean
   */
  public Boolean getIncludePDF() {
    return includePDF;
  }

  /**
   * Boolean to indicate whether to include PDF attachment
   *
   * @param includePDF Boolean
   */
  public void setIncludePDF(Boolean includePDF) {
    this.includePDF = includePDF;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RepeatingInvoice repeatingInvoice = (RepeatingInvoice) o;
    return Objects.equals(this.type, repeatingInvoice.type)
        && Objects.equals(this.contact, repeatingInvoice.contact)
        && Objects.equals(this.schedule, repeatingInvoice.schedule)
        && Objects.equals(this.lineItems, repeatingInvoice.lineItems)
        && Objects.equals(this.lineAmountTypes, repeatingInvoice.lineAmountTypes)
        && Objects.equals(this.reference, repeatingInvoice.reference)
        && Objects.equals(this.brandingThemeID, repeatingInvoice.brandingThemeID)
        && Objects.equals(this.currencyCode, repeatingInvoice.currencyCode)
        && Objects.equals(this.status, repeatingInvoice.status)
        && Objects.equals(this.subTotal, repeatingInvoice.subTotal)
        && Objects.equals(this.totalTax, repeatingInvoice.totalTax)
        && Objects.equals(this.total, repeatingInvoice.total)
        && Objects.equals(this.repeatingInvoiceID, repeatingInvoice.repeatingInvoiceID)
        && Objects.equals(this.ID, repeatingInvoice.ID)
        && Objects.equals(this.hasAttachments, repeatingInvoice.hasAttachments)
        && Objects.equals(this.attachments, repeatingInvoice.attachments)
        && Objects.equals(this.approvedForSending, repeatingInvoice.approvedForSending)
        && Objects.equals(this.sendCopy, repeatingInvoice.sendCopy)
        && Objects.equals(this.markAsSent, repeatingInvoice.markAsSent)
        && Objects.equals(this.includePDF, repeatingInvoice.includePDF);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        type,
        contact,
        schedule,
        lineItems,
        lineAmountTypes,
        reference,
        brandingThemeID,
        currencyCode,
        status,
        subTotal,
        totalTax,
        total,
        repeatingInvoiceID,
        ID,
        hasAttachments,
        attachments,
        approvedForSending,
        sendCopy,
        markAsSent,
        includePDF);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RepeatingInvoice {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    schedule: ").append(toIndentedString(schedule)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    lineAmountTypes: ").append(toIndentedString(lineAmountTypes)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    brandingThemeID: ").append(toIndentedString(brandingThemeID)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    subTotal: ").append(toIndentedString(subTotal)).append("\n");
    sb.append("    totalTax: ").append(toIndentedString(totalTax)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    repeatingInvoiceID: ").append(toIndentedString(repeatingInvoiceID)).append("\n");
    sb.append("    ID: ").append(toIndentedString(ID)).append("\n");
    sb.append("    hasAttachments: ").append(toIndentedString(hasAttachments)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    approvedForSending: ").append(toIndentedString(approvedForSending)).append("\n");
    sb.append("    sendCopy: ").append(toIndentedString(sendCopy)).append("\n");
    sb.append("    markAsSent: ").append(toIndentedString(markAsSent)).append("\n");
    sb.append("    includePDF: ").append(toIndentedString(includePDF)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
