/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

/** BalanceSheetAccountDetail */
public class BalanceSheetAccountDetail {
  StringUtil util = new StringUtil();

  @JsonProperty("code")
  private String code;

  @JsonProperty("accountID")
  private UUID accountID;

  @JsonProperty("name")
  private String name;

  @JsonProperty("reportingCode")
  private String reportingCode;

  @JsonProperty("total")
  private Double total;
  /**
   * Accounting code
   *
   * @param code String
   * @return BalanceSheetAccountDetail
   */
  public BalanceSheetAccountDetail code(String code) {
    this.code = code;
    return this;
  }

  /**
   * Accounting code
   *
   * @return code
   */
  @ApiModelProperty(value = "Accounting code")
  /**
   * Accounting code
   *
   * @return code String
   */
  public String getCode() {
    return code;
  }

  /**
   * Accounting code
   *
   * @param code String
   */
  public void setCode(String code) {
    this.code = code;
  }

  /**
   * ID of the account
   *
   * @param accountID UUID
   * @return BalanceSheetAccountDetail
   */
  public BalanceSheetAccountDetail accountID(UUID accountID) {
    this.accountID = accountID;
    return this;
  }

  /**
   * ID of the account
   *
   * @return accountID
   */
  @ApiModelProperty(value = "ID of the account")
  /**
   * ID of the account
   *
   * @return accountID UUID
   */
  public UUID getAccountID() {
    return accountID;
  }

  /**
   * ID of the account
   *
   * @param accountID UUID
   */
  public void setAccountID(UUID accountID) {
    this.accountID = accountID;
  }

  /**
   * Account name
   *
   * @param name String
   * @return BalanceSheetAccountDetail
   */
  public BalanceSheetAccountDetail name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Account name
   *
   * @return name
   */
  @ApiModelProperty(value = "Account name")
  /**
   * Account name
   *
   * @return name String
   */
  public String getName() {
    return name;
  }

  /**
   * Account name
   *
   * @param name String
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Reporting code
   *
   * @param reportingCode String
   * @return BalanceSheetAccountDetail
   */
  public BalanceSheetAccountDetail reportingCode(String reportingCode) {
    this.reportingCode = reportingCode;
    return this;
  }

  /**
   * Reporting code
   *
   * @return reportingCode
   */
  @ApiModelProperty(value = "Reporting code")
  /**
   * Reporting code
   *
   * @return reportingCode String
   */
  public String getReportingCode() {
    return reportingCode;
  }

  /**
   * Reporting code
   *
   * @param reportingCode String
   */
  public void setReportingCode(String reportingCode) {
    this.reportingCode = reportingCode;
  }

  /**
   * Total movement on this account
   *
   * @param total Double
   * @return BalanceSheetAccountDetail
   */
  public BalanceSheetAccountDetail total(Double total) {
    this.total = total;
    return this;
  }

  /**
   * Total movement on this account
   *
   * @return total
   */
  @ApiModelProperty(value = "Total movement on this account")
  /**
   * Total movement on this account
   *
   * @return total Double
   */
  public Double getTotal() {
    return total;
  }

  /**
   * Total movement on this account
   *
   * @param total Double
   */
  public void setTotal(Double total) {
    this.total = total;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceSheetAccountDetail balanceSheetAccountDetail = (BalanceSheetAccountDetail) o;
    return Objects.equals(this.code, balanceSheetAccountDetail.code)
        && Objects.equals(this.accountID, balanceSheetAccountDetail.accountID)
        && Objects.equals(this.name, balanceSheetAccountDetail.name)
        && Objects.equals(this.reportingCode, balanceSheetAccountDetail.reportingCode)
        && Objects.equals(this.total, balanceSheetAccountDetail.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, accountID, name, reportingCode, total);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceSheetAccountDetail {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    accountID: ").append(toIndentedString(accountID)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    reportingCode: ").append(toIndentedString(reportingCode)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
