/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** PracticeResponse */
public class PracticeResponse {
  StringUtil util = new StringUtil();

  @JsonProperty("xeroPartnerSince")
  private Integer xeroPartnerSince;

  @JsonProperty("tier")
  private String tier;

  @JsonProperty("location")
  private String location;

  @JsonProperty("organisationCount")
  private Integer organisationCount;

  @JsonProperty("staffCertified")
  private Boolean staffCertified;
  /**
   * Year of becoming a partner.
   *
   * @param xeroPartnerSince Integer
   * @return PracticeResponse
   */
  public PracticeResponse xeroPartnerSince(Integer xeroPartnerSince) {
    this.xeroPartnerSince = xeroPartnerSince;
    return this;
  }

  /**
   * Year of becoming a partner.
   *
   * @return xeroPartnerSince
   */
  @ApiModelProperty(value = "Year of becoming a partner.")
  /**
   * Year of becoming a partner.
   *
   * @return xeroPartnerSince Integer
   */
  public Integer getXeroPartnerSince() {
    return xeroPartnerSince;
  }

  /**
   * Year of becoming a partner.
   *
   * @param xeroPartnerSince Integer
   */
  public void setXeroPartnerSince(Integer xeroPartnerSince) {
    this.xeroPartnerSince = xeroPartnerSince;
  }

  /**
   * Customer tier e.g. Silver
   *
   * @param tier String
   * @return PracticeResponse
   */
  public PracticeResponse tier(String tier) {
    this.tier = tier;
    return this;
  }

  /**
   * Customer tier e.g. Silver
   *
   * @return tier
   */
  @ApiModelProperty(value = "Customer tier e.g. Silver")
  /**
   * Customer tier e.g. Silver
   *
   * @return tier String
   */
  public String getTier() {
    return tier;
  }

  /**
   * Customer tier e.g. Silver
   *
   * @param tier String
   */
  public void setTier(String tier) {
    this.tier = tier;
  }

  /**
   * Country of location.
   *
   * @param location String
   * @return PracticeResponse
   */
  public PracticeResponse location(String location) {
    this.location = location;
    return this;
  }

  /**
   * Country of location.
   *
   * @return location
   */
  @ApiModelProperty(value = "Country of location.")
  /**
   * Country of location.
   *
   * @return location String
   */
  public String getLocation() {
    return location;
  }

  /**
   * Country of location.
   *
   * @param location String
   */
  public void setLocation(String location) {
    this.location = location;
  }

  /**
   * Organisation count.
   *
   * @param organisationCount Integer
   * @return PracticeResponse
   */
  public PracticeResponse organisationCount(Integer organisationCount) {
    this.organisationCount = organisationCount;
    return this;
  }

  /**
   * Organisation count.
   *
   * @return organisationCount
   */
  @ApiModelProperty(value = "Organisation count.")
  /**
   * Organisation count.
   *
   * @return organisationCount Integer
   */
  public Integer getOrganisationCount() {
    return organisationCount;
  }

  /**
   * Organisation count.
   *
   * @param organisationCount Integer
   */
  public void setOrganisationCount(Integer organisationCount) {
    this.organisationCount = organisationCount;
  }

  /**
   * Staff certified (true/false).
   *
   * @param staffCertified Boolean
   * @return PracticeResponse
   */
  public PracticeResponse staffCertified(Boolean staffCertified) {
    this.staffCertified = staffCertified;
    return this;
  }

  /**
   * Staff certified (true/false).
   *
   * @return staffCertified
   */
  @ApiModelProperty(value = "Staff certified (true/false).")
  /**
   * Staff certified (true/false).
   *
   * @return staffCertified Boolean
   */
  public Boolean getStaffCertified() {
    return staffCertified;
  }

  /**
   * Staff certified (true/false).
   *
   * @param staffCertified Boolean
   */
  public void setStaffCertified(Boolean staffCertified) {
    this.staffCertified = staffCertified;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PracticeResponse practiceResponse = (PracticeResponse) o;
    return Objects.equals(this.xeroPartnerSince, practiceResponse.xeroPartnerSince)
        && Objects.equals(this.tier, practiceResponse.tier)
        && Objects.equals(this.location, practiceResponse.location)
        && Objects.equals(this.organisationCount, practiceResponse.organisationCount)
        && Objects.equals(this.staffCertified, practiceResponse.staffCertified);
  }

  @Override
  public int hashCode() {
    return Objects.hash(xeroPartnerSince, tier, location, organisationCount, staffCertified);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PracticeResponse {\n");
    sb.append("    xeroPartnerSince: ").append(toIndentedString(xeroPartnerSince)).append("\n");
    sb.append("    tier: ").append(toIndentedString(tier)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    organisationCount: ").append(toIndentedString(organisationCount)).append("\n");
    sb.append("    staffCertified: ").append(toIndentedString(staffCertified)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
