/*
 * Xero Finance API
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/** TotalOther */
public class TotalOther {
  StringUtil util = new StringUtil();

  @JsonProperty("totalOutstandingAged")
  private Double totalOutstandingAged;

  @JsonProperty("totalVoided")
  private Double totalVoided;

  @JsonProperty("totalCredited")
  private Double totalCredited;
  /**
   * Total outstanding invoice value within the period where the invoices are more than 90 days old
   *
   * @param totalOutstandingAged Double
   * @return TotalOther
   */
  public TotalOther totalOutstandingAged(Double totalOutstandingAged) {
    this.totalOutstandingAged = totalOutstandingAged;
    return this;
  }

  /**
   * Total outstanding invoice value within the period where the invoices are more than 90 days old
   *
   * @return totalOutstandingAged
   */
  @ApiModelProperty(
      value =
          "Total outstanding invoice value within the period where the invoices are more than 90"
              + " days old")
  /**
   * Total outstanding invoice value within the period where the invoices are more than 90 days old
   *
   * @return totalOutstandingAged Double
   */
  public Double getTotalOutstandingAged() {
    return totalOutstandingAged;
  }

  /**
   * Total outstanding invoice value within the period where the invoices are more than 90 days old
   *
   * @param totalOutstandingAged Double
   */
  public void setTotalOutstandingAged(Double totalOutstandingAged) {
    this.totalOutstandingAged = totalOutstandingAged;
  }

  /**
   * Total voided value.
   *
   * @param totalVoided Double
   * @return TotalOther
   */
  public TotalOther totalVoided(Double totalVoided) {
    this.totalVoided = totalVoided;
    return this;
  }

  /**
   * Total voided value.
   *
   * @return totalVoided
   */
  @ApiModelProperty(value = "Total voided value.")
  /**
   * Total voided value.
   *
   * @return totalVoided Double
   */
  public Double getTotalVoided() {
    return totalVoided;
  }

  /**
   * Total voided value.
   *
   * @param totalVoided Double
   */
  public void setTotalVoided(Double totalVoided) {
    this.totalVoided = totalVoided;
  }

  /**
   * Total credited value.
   *
   * @param totalCredited Double
   * @return TotalOther
   */
  public TotalOther totalCredited(Double totalCredited) {
    this.totalCredited = totalCredited;
    return this;
  }

  /**
   * Total credited value.
   *
   * @return totalCredited
   */
  @ApiModelProperty(value = "Total credited value.")
  /**
   * Total credited value.
   *
   * @return totalCredited Double
   */
  public Double getTotalCredited() {
    return totalCredited;
  }

  /**
   * Total credited value.
   *
   * @param totalCredited Double
   */
  public void setTotalCredited(Double totalCredited) {
    this.totalCredited = totalCredited;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TotalOther totalOther = (TotalOther) o;
    return Objects.equals(this.totalOutstandingAged, totalOther.totalOutstandingAged)
        && Objects.equals(this.totalVoided, totalOther.totalVoided)
        && Objects.equals(this.totalCredited, totalOther.totalCredited);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalOutstandingAged, totalVoided, totalCredited);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TotalOther {\n");
    sb.append("    totalOutstandingAged: ")
        .append(toIndentedString(totalOutstandingAged))
        .append("\n");
    sb.append("    totalVoided: ").append(toIndentedString(totalVoided)).append("\n");
    sb.append("    totalCredited: ").append(toIndentedString(totalCredited)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
