/*
 * Xero Payroll AU API
 * This is the Xero Payroll API for orgs in Australia region.
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

/** Employee */
public class Employee {
  StringUtil util = new StringUtil();

  @JsonProperty("FirstName")
  private String firstName;

  @JsonProperty("LastName")
  private String lastName;

  @JsonProperty("DateOfBirth")
  private String dateOfBirth;

  @JsonProperty("HomeAddress")
  private HomeAddress homeAddress;

  @JsonProperty("StartDate")
  private String startDate;

  @JsonProperty("Title")
  private String title;

  @JsonProperty("MiddleNames")
  private String middleNames;

  @JsonProperty("Email")
  private String email;
  /** The employee’s gender. See Employee Gender */
  public enum GenderEnum {
    /** N */
    N("N"),

    /** M */
    M("M"),

    /** F */
    F("F"),

    /** I */
    I("I");

    private String value;

    GenderEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static GenderEnum fromValue(String value) {
      for (GenderEnum b : GenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("Gender")
  private GenderEnum gender;

  @JsonProperty("Phone")
  private String phone;

  @JsonProperty("Mobile")
  private String mobile;

  @JsonProperty("TwitterUserName")
  private String twitterUserName;

  @JsonProperty("IsAuthorisedToApproveLeave")
  private Boolean isAuthorisedToApproveLeave;

  @JsonProperty("IsAuthorisedToApproveTimesheets")
  private Boolean isAuthorisedToApproveTimesheets;

  @JsonProperty("JobTitle")
  private String jobTitle;

  @JsonProperty("Classification")
  private String classification;

  @JsonProperty("OrdinaryEarningsRateID")
  private UUID ordinaryEarningsRateID;

  @JsonProperty("PayrollCalendarID")
  private UUID payrollCalendarID;

  @JsonProperty("EmployeeGroupName")
  private String employeeGroupName;

  @JsonProperty("EmployeeID")
  private UUID employeeID;

  @JsonProperty("TerminationDate")
  private String terminationDate;
  /**
   * * &#x60;V&#x60; Voluntary cessation - An employee resignation, retirement, domestic or pressing
   * necessity or abandonment of employment * &#x60;I&#x60; Ill health - An employee resignation due
   * to medical condition that prevents the continuation of employment, such as for illness,
   * ill-health, medical unfitness or total permanent disability * &#x60;D&#x60; Deceased - The
   * death of an employee * &#x60;R&#x60; Redundancy - An employer-initiated termination of
   * employment due to a genuine redundancy or approved early retirement scheme * &#x60;F&#x60;
   * Dismissal - An employer-initiated termination of employment due to dismissal, inability to
   * perform the required work, misconduct or inefficiency * &#x60;C&#x60; Contract cessation - The
   * natural conclusion of a limited employment relationship due to contract/engagement duration or
   * task completion, seasonal work completion, or to cease casuals that are no longer required *
   * &#x60;T&#x60; Transfer - The administrative arrangements performed to transfer employees across
   * payroll systems, move them temporarily to another employer (machinery of government for public
   * servants), transfer of business, move them to outsourcing arrangements or other such technical
   * activities.
   */
  public enum TerminationReasonEnum {
    /** V */
    V("V"),

    /** I */
    I("I"),

    /** D */
    D("D"),

    /** R */
    R("R"),

    /** F */
    F("F"),

    /** C */
    C("C"),

    /** T */
    T("T");

    private String value;

    TerminationReasonEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static TerminationReasonEnum fromValue(String value) {
      for (TerminationReasonEnum b : TerminationReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("TerminationReason")
  private TerminationReasonEnum terminationReason;

  @JsonProperty("BankAccounts")
  private List<BankAccount> bankAccounts = new ArrayList<BankAccount>();

  @JsonProperty("PayTemplate")
  private PayTemplate payTemplate;

  @JsonProperty("OpeningBalances")
  private OpeningBalances openingBalances;

  @JsonProperty("TaxDeclaration")
  private TaxDeclaration taxDeclaration;

  @JsonProperty("LeaveBalances")
  private List<LeaveBalance> leaveBalances = new ArrayList<LeaveBalance>();

  @JsonProperty("LeaveLines")
  private List<LeaveLine> leaveLines = new ArrayList<LeaveLine>();

  @JsonProperty("SuperMemberships")
  private List<SuperMembership> superMemberships = new ArrayList<SuperMembership>();

  @JsonProperty("Status")
  private EmployeeStatus status;

  @JsonProperty("UpdatedDateUTC")
  private String updatedDateUTC;

  @JsonProperty("ValidationErrors")
  private List<ValidationError> validationErrors = new ArrayList<ValidationError>();
  /**
   * First name of employee
   *
   * @param firstName String
   * @return Employee
   */
  public Employee firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

  /**
   * First name of employee
   *
   * @return firstName
   */
  @ApiModelProperty(example = "Karen", required = true, value = "First name of employee")
  /**
   * First name of employee
   *
   * @return firstName String
   */
  public String getFirstName() {
    return firstName;
  }

  /**
   * First name of employee
   *
   * @param firstName String
   */
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  /**
   * Last name of employee
   *
   * @param lastName String
   * @return Employee
   */
  public Employee lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

  /**
   * Last name of employee
   *
   * @return lastName
   */
  @ApiModelProperty(example = "Jones", required = true, value = "Last name of employee")
  /**
   * Last name of employee
   *
   * @return lastName String
   */
  public String getLastName() {
    return lastName;
  }

  /**
   * Last name of employee
   *
   * @param lastName String
   */
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  /**
   * Date of birth of the employee (YYYY-MM-DD)
   *
   * @param dateOfBirth String
   * @return Employee
   */
  public Employee dateOfBirth(String dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

  /**
   * Date of birth of the employee (YYYY-MM-DD)
   *
   * @return dateOfBirth
   */
  @ApiModelProperty(
      example = "/Date(322560000000+0000)/",
      required = true,
      value = "Date of birth of the employee (YYYY-MM-DD)")
  /**
   * Date of birth of the employee (YYYY-MM-DD)
   *
   * @return dateOfBirth String
   */
  public String getDateOfBirth() {
    return dateOfBirth;
  }
  /**
   * Date of birth of the employee (YYYY-MM-DD)
   *
   * @return LocalDate
   */
  public LocalDate getDateOfBirthAsDate() {
    if (this.dateOfBirth != null) {
      try {
        return util.convertStringToDate(this.dateOfBirth);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * Date of birth of the employee (YYYY-MM-DD)
   *
   * @param dateOfBirth String
   */
  public void setDateOfBirth(String dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  /**
   * Date of birth of the employee (YYYY-MM-DD)
   *
   * @param dateOfBirth LocalDateTime
   */
  public void setDateOfBirth(LocalDate dateOfBirth) {
    // CONVERT LocalDate args into MS DateFromat String
    Instant instant = dateOfBirth.atStartOfDay(ZoneId.of("UTC").normalized()).toInstant();
    long timeInMillis = instant.toEpochMilli();

    this.dateOfBirth = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
  }

  /**
   * homeAddress
   *
   * @param homeAddress HomeAddress
   * @return Employee
   */
  public Employee homeAddress(HomeAddress homeAddress) {
    this.homeAddress = homeAddress;
    return this;
  }

  /**
   * Get homeAddress
   *
   * @return homeAddress
   */
  @ApiModelProperty(value = "")
  /**
   * homeAddress
   *
   * @return homeAddress HomeAddress
   */
  public HomeAddress getHomeAddress() {
    return homeAddress;
  }

  /**
   * homeAddress
   *
   * @param homeAddress HomeAddress
   */
  public void setHomeAddress(HomeAddress homeAddress) {
    this.homeAddress = homeAddress;
  }

  /**
   * Start date for an employee (YYYY-MM-DD)
   *
   * @param startDate String
   * @return Employee
   */
  public Employee startDate(String startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Start date for an employee (YYYY-MM-DD)
   *
   * @return startDate
   */
  @ApiModelProperty(
      example = "/Date(320284900000+0000)/",
      value = "Start date for an employee (YYYY-MM-DD)")
  /**
   * Start date for an employee (YYYY-MM-DD)
   *
   * @return startDate String
   */
  public String getStartDate() {
    return startDate;
  }
  /**
   * Start date for an employee (YYYY-MM-DD)
   *
   * @return LocalDate
   */
  public LocalDate getStartDateAsDate() {
    if (this.startDate != null) {
      try {
        return util.convertStringToDate(this.startDate);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * Start date for an employee (YYYY-MM-DD)
   *
   * @param startDate String
   */
  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }

  /**
   * Start date for an employee (YYYY-MM-DD)
   *
   * @param startDate LocalDateTime
   */
  public void setStartDate(LocalDate startDate) {
    // CONVERT LocalDate args into MS DateFromat String
    Instant instant = startDate.atStartOfDay(ZoneId.of("UTC").normalized()).toInstant();
    long timeInMillis = instant.toEpochMilli();

    this.startDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
  }

  /**
   * Title of the employee
   *
   * @param title String
   * @return Employee
   */
  public Employee title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Title of the employee
   *
   * @return title
   */
  @ApiModelProperty(example = "Mrs", value = "Title of the employee")
  /**
   * Title of the employee
   *
   * @return title String
   */
  public String getTitle() {
    return title;
  }

  /**
   * Title of the employee
   *
   * @param title String
   */
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Middle name(s) of the employee
   *
   * @param middleNames String
   * @return Employee
   */
  public Employee middleNames(String middleNames) {
    this.middleNames = middleNames;
    return this;
  }

  /**
   * Middle name(s) of the employee
   *
   * @return middleNames
   */
  @ApiModelProperty(example = "Adena", value = "Middle name(s) of the employee")
  /**
   * Middle name(s) of the employee
   *
   * @return middleNames String
   */
  public String getMiddleNames() {
    return middleNames;
  }

  /**
   * Middle name(s) of the employee
   *
   * @param middleNames String
   */
  public void setMiddleNames(String middleNames) {
    this.middleNames = middleNames;
  }

  /**
   * The email address for the employee
   *
   * @param email String
   * @return Employee
   */
  public Employee email(String email) {
    this.email = email;
    return this;
  }

  /**
   * The email address for the employee
   *
   * @return email
   */
  @ApiModelProperty(example = "developer@me.com", value = "The email address for the employee")
  /**
   * The email address for the employee
   *
   * @return email String
   */
  public String getEmail() {
    return email;
  }

  /**
   * The email address for the employee
   *
   * @param email String
   */
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * The employee’s gender. See Employee Gender
   *
   * @param gender GenderEnum
   * @return Employee
   */
  public Employee gender(GenderEnum gender) {
    this.gender = gender;
    return this;
  }

  /**
   * The employee’s gender. See Employee Gender
   *
   * @return gender
   */
  @ApiModelProperty(example = "F", value = "The employee’s gender. See Employee Gender")
  /**
   * The employee’s gender. See Employee Gender
   *
   * @return gender GenderEnum
   */
  public GenderEnum getGender() {
    return gender;
  }

  /**
   * The employee’s gender. See Employee Gender
   *
   * @param gender GenderEnum
   */
  public void setGender(GenderEnum gender) {
    this.gender = gender;
  }

  /**
   * Employee phone number
   *
   * @param phone String
   * @return Employee
   */
  public Employee phone(String phone) {
    this.phone = phone;
    return this;
  }

  /**
   * Employee phone number
   *
   * @return phone
   */
  @ApiModelProperty(example = "415-555-1212", value = "Employee phone number")
  /**
   * Employee phone number
   *
   * @return phone String
   */
  public String getPhone() {
    return phone;
  }

  /**
   * Employee phone number
   *
   * @param phone String
   */
  public void setPhone(String phone) {
    this.phone = phone;
  }

  /**
   * Employee mobile number
   *
   * @param mobile String
   * @return Employee
   */
  public Employee mobile(String mobile) {
    this.mobile = mobile;
    return this;
  }

  /**
   * Employee mobile number
   *
   * @return mobile
   */
  @ApiModelProperty(example = "415-234-5678", value = "Employee mobile number")
  /**
   * Employee mobile number
   *
   * @return mobile String
   */
  public String getMobile() {
    return mobile;
  }

  /**
   * Employee mobile number
   *
   * @param mobile String
   */
  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  /**
   * Employee’s twitter name
   *
   * @param twitterUserName String
   * @return Employee
   */
  public Employee twitterUserName(String twitterUserName) {
    this.twitterUserName = twitterUserName;
    return this;
  }

  /**
   * Employee’s twitter name
   *
   * @return twitterUserName
   */
  @ApiModelProperty(example = "xeroapi", value = "Employee’s twitter name")
  /**
   * Employee’s twitter name
   *
   * @return twitterUserName String
   */
  public String getTwitterUserName() {
    return twitterUserName;
  }

  /**
   * Employee’s twitter name
   *
   * @param twitterUserName String
   */
  public void setTwitterUserName(String twitterUserName) {
    this.twitterUserName = twitterUserName;
  }

  /**
   * Authorised to approve other employees&#39; leave requests
   *
   * @param isAuthorisedToApproveLeave Boolean
   * @return Employee
   */
  public Employee isAuthorisedToApproveLeave(Boolean isAuthorisedToApproveLeave) {
    this.isAuthorisedToApproveLeave = isAuthorisedToApproveLeave;
    return this;
  }

  /**
   * Authorised to approve other employees&#39; leave requests
   *
   * @return isAuthorisedToApproveLeave
   */
  @ApiModelProperty(
      example = "false",
      value = "Authorised to approve other employees' leave requests")
  /**
   * Authorised to approve other employees&#39; leave requests
   *
   * @return isAuthorisedToApproveLeave Boolean
   */
  public Boolean getIsAuthorisedToApproveLeave() {
    return isAuthorisedToApproveLeave;
  }

  /**
   * Authorised to approve other employees&#39; leave requests
   *
   * @param isAuthorisedToApproveLeave Boolean
   */
  public void setIsAuthorisedToApproveLeave(Boolean isAuthorisedToApproveLeave) {
    this.isAuthorisedToApproveLeave = isAuthorisedToApproveLeave;
  }

  /**
   * Authorised to approve timesheets
   *
   * @param isAuthorisedToApproveTimesheets Boolean
   * @return Employee
   */
  public Employee isAuthorisedToApproveTimesheets(Boolean isAuthorisedToApproveTimesheets) {
    this.isAuthorisedToApproveTimesheets = isAuthorisedToApproveTimesheets;
    return this;
  }

  /**
   * Authorised to approve timesheets
   *
   * @return isAuthorisedToApproveTimesheets
   */
  @ApiModelProperty(example = "true", value = "Authorised to approve timesheets")
  /**
   * Authorised to approve timesheets
   *
   * @return isAuthorisedToApproveTimesheets Boolean
   */
  public Boolean getIsAuthorisedToApproveTimesheets() {
    return isAuthorisedToApproveTimesheets;
  }

  /**
   * Authorised to approve timesheets
   *
   * @param isAuthorisedToApproveTimesheets Boolean
   */
  public void setIsAuthorisedToApproveTimesheets(Boolean isAuthorisedToApproveTimesheets) {
    this.isAuthorisedToApproveTimesheets = isAuthorisedToApproveTimesheets;
  }

  /**
   * JobTitle of the employee
   *
   * @param jobTitle String
   * @return Employee
   */
  public Employee jobTitle(String jobTitle) {
    this.jobTitle = jobTitle;
    return this;
  }

  /**
   * JobTitle of the employee
   *
   * @return jobTitle
   */
  @ApiModelProperty(example = "Manager", value = "JobTitle of the employee")
  /**
   * JobTitle of the employee
   *
   * @return jobTitle String
   */
  public String getJobTitle() {
    return jobTitle;
  }

  /**
   * JobTitle of the employee
   *
   * @param jobTitle String
   */
  public void setJobTitle(String jobTitle) {
    this.jobTitle = jobTitle;
  }

  /**
   * Employees classification
   *
   * @param classification String
   * @return Employee
   */
  public Employee classification(String classification) {
    this.classification = classification;
    return this;
  }

  /**
   * Employees classification
   *
   * @return classification
   */
  @ApiModelProperty(example = "99383", value = "Employees classification")
  /**
   * Employees classification
   *
   * @return classification String
   */
  public String getClassification() {
    return classification;
  }

  /**
   * Employees classification
   *
   * @param classification String
   */
  public void setClassification(String classification) {
    this.classification = classification;
  }

  /**
   * Xero unique identifier for earnings rate
   *
   * @param ordinaryEarningsRateID UUID
   * @return Employee
   */
  public Employee ordinaryEarningsRateID(UUID ordinaryEarningsRateID) {
    this.ordinaryEarningsRateID = ordinaryEarningsRateID;
    return this;
  }

  /**
   * Xero unique identifier for earnings rate
   *
   * @return ordinaryEarningsRateID
   */
  @ApiModelProperty(value = "Xero unique identifier for earnings rate")
  /**
   * Xero unique identifier for earnings rate
   *
   * @return ordinaryEarningsRateID UUID
   */
  public UUID getOrdinaryEarningsRateID() {
    return ordinaryEarningsRateID;
  }

  /**
   * Xero unique identifier for earnings rate
   *
   * @param ordinaryEarningsRateID UUID
   */
  public void setOrdinaryEarningsRateID(UUID ordinaryEarningsRateID) {
    this.ordinaryEarningsRateID = ordinaryEarningsRateID;
  }

  /**
   * Xero unique identifier for payroll calendar for the employee
   *
   * @param payrollCalendarID UUID
   * @return Employee
   */
  public Employee payrollCalendarID(UUID payrollCalendarID) {
    this.payrollCalendarID = payrollCalendarID;
    return this;
  }

  /**
   * Xero unique identifier for payroll calendar for the employee
   *
   * @return payrollCalendarID
   */
  @ApiModelProperty(
      example = "2ee8e5cc-9835-40d5-bb18-09fdb118db9c",
      value = "Xero unique identifier for payroll calendar for the employee")
  /**
   * Xero unique identifier for payroll calendar for the employee
   *
   * @return payrollCalendarID UUID
   */
  public UUID getPayrollCalendarID() {
    return payrollCalendarID;
  }

  /**
   * Xero unique identifier for payroll calendar for the employee
   *
   * @param payrollCalendarID UUID
   */
  public void setPayrollCalendarID(UUID payrollCalendarID) {
    this.payrollCalendarID = payrollCalendarID;
  }

  /**
   * The Employee Group allows you to report on payroll expenses and liabilities for each group of
   * employees
   *
   * @param employeeGroupName String
   * @return Employee
   */
  public Employee employeeGroupName(String employeeGroupName) {
    this.employeeGroupName = employeeGroupName;
    return this;
  }

  /**
   * The Employee Group allows you to report on payroll expenses and liabilities for each group of
   * employees
   *
   * @return employeeGroupName
   */
  @ApiModelProperty(
      example = "marketing",
      value =
          "The Employee Group allows you to report on payroll expenses and liabilities for each"
              + " group of employees")
  /**
   * The Employee Group allows you to report on payroll expenses and liabilities for each group of
   * employees
   *
   * @return employeeGroupName String
   */
  public String getEmployeeGroupName() {
    return employeeGroupName;
  }

  /**
   * The Employee Group allows you to report on payroll expenses and liabilities for each group of
   * employees
   *
   * @param employeeGroupName String
   */
  public void setEmployeeGroupName(String employeeGroupName) {
    this.employeeGroupName = employeeGroupName;
  }

  /**
   * Xero unique identifier for an Employee
   *
   * @param employeeID UUID
   * @return Employee
   */
  public Employee employeeID(UUID employeeID) {
    this.employeeID = employeeID;
    return this;
  }

  /**
   * Xero unique identifier for an Employee
   *
   * @return employeeID
   */
  @ApiModelProperty(
      example = "4ff1e5cc-9835-40d5-bb18-09fdb118db9c",
      value = "Xero unique identifier for an Employee")
  /**
   * Xero unique identifier for an Employee
   *
   * @return employeeID UUID
   */
  public UUID getEmployeeID() {
    return employeeID;
  }

  /**
   * Xero unique identifier for an Employee
   *
   * @param employeeID UUID
   */
  public void setEmployeeID(UUID employeeID) {
    this.employeeID = employeeID;
  }

  /**
   * Employee Termination Date (YYYY-MM-DD)
   *
   * @param terminationDate String
   * @return Employee
   */
  public Employee terminationDate(String terminationDate) {
    this.terminationDate = terminationDate;
    return this;
  }

  /**
   * Employee Termination Date (YYYY-MM-DD)
   *
   * @return terminationDate
   */
  @ApiModelProperty(
      example = "/Date(1584662400000+0000)/",
      value = "Employee Termination Date (YYYY-MM-DD)")
  /**
   * Employee Termination Date (YYYY-MM-DD)
   *
   * @return terminationDate String
   */
  public String getTerminationDate() {
    return terminationDate;
  }
  /**
   * Employee Termination Date (YYYY-MM-DD)
   *
   * @return LocalDate
   */
  public LocalDate getTerminationDateAsDate() {
    if (this.terminationDate != null) {
      try {
        return util.convertStringToDate(this.terminationDate);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * Employee Termination Date (YYYY-MM-DD)
   *
   * @param terminationDate String
   */
  public void setTerminationDate(String terminationDate) {
    this.terminationDate = terminationDate;
  }

  /**
   * Employee Termination Date (YYYY-MM-DD)
   *
   * @param terminationDate LocalDateTime
   */
  public void setTerminationDate(LocalDate terminationDate) {
    // CONVERT LocalDate args into MS DateFromat String
    Instant instant = terminationDate.atStartOfDay(ZoneId.of("UTC").normalized()).toInstant();
    long timeInMillis = instant.toEpochMilli();

    this.terminationDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
  }

  /**
   * * &#x60;V&#x60; Voluntary cessation - An employee resignation, retirement, domestic or pressing
   * necessity or abandonment of employment * &#x60;I&#x60; Ill health - An employee resignation due
   * to medical condition that prevents the continuation of employment, such as for illness,
   * ill-health, medical unfitness or total permanent disability * &#x60;D&#x60; Deceased - The
   * death of an employee * &#x60;R&#x60; Redundancy - An employer-initiated termination of
   * employment due to a genuine redundancy or approved early retirement scheme * &#x60;F&#x60;
   * Dismissal - An employer-initiated termination of employment due to dismissal, inability to
   * perform the required work, misconduct or inefficiency * &#x60;C&#x60; Contract cessation - The
   * natural conclusion of a limited employment relationship due to contract/engagement duration or
   * task completion, seasonal work completion, or to cease casuals that are no longer required *
   * &#x60;T&#x60; Transfer - The administrative arrangements performed to transfer employees across
   * payroll systems, move them temporarily to another employer (machinery of government for public
   * servants), transfer of business, move them to outsourcing arrangements or other such technical
   * activities.
   *
   * @param terminationReason TerminationReasonEnum
   * @return Employee
   */
  public Employee terminationReason(TerminationReasonEnum terminationReason) {
    this.terminationReason = terminationReason;
    return this;
  }

  /**
   * * &#x60;V&#x60; Voluntary cessation - An employee resignation, retirement, domestic or pressing
   * necessity or abandonment of employment * &#x60;I&#x60; Ill health - An employee resignation due
   * to medical condition that prevents the continuation of employment, such as for illness,
   * ill-health, medical unfitness or total permanent disability * &#x60;D&#x60; Deceased - The
   * death of an employee * &#x60;R&#x60; Redundancy - An employer-initiated termination of
   * employment due to a genuine redundancy or approved early retirement scheme * &#x60;F&#x60;
   * Dismissal - An employer-initiated termination of employment due to dismissal, inability to
   * perform the required work, misconduct or inefficiency * &#x60;C&#x60; Contract cessation - The
   * natural conclusion of a limited employment relationship due to contract/engagement duration or
   * task completion, seasonal work completion, or to cease casuals that are no longer required *
   * &#x60;T&#x60; Transfer - The administrative arrangements performed to transfer employees across
   * payroll systems, move them temporarily to another employer (machinery of government for public
   * servants), transfer of business, move them to outsourcing arrangements or other such technical
   * activities.
   *
   * @return terminationReason
   */
  @ApiModelProperty(
      example = "F",
      value =
          "* `V` Voluntary cessation - An employee resignation, retirement, domestic or pressing"
              + " necessity or abandonment of employment * `I` Ill health - An employee"
              + " resignation due to medical condition that prevents the continuation of"
              + " employment, such as for illness, ill-health, medical unfitness or total"
              + " permanent disability * `D` Deceased - The death of an employee * `R` Redundancy"
              + " - An employer-initiated termination of employment due to a genuine redundancy or"
              + " approved early retirement scheme * `F` Dismissal - An employer-initiated"
              + " termination of employment due to dismissal, inability to perform the required"
              + " work, misconduct or inefficiency * `C` Contract cessation - The natural"
              + " conclusion of a limited employment relationship due to contract/engagement"
              + " duration or task completion, seasonal work completion, or to cease casuals that"
              + " are no longer required * `T` Transfer - The administrative arrangements"
              + " performed to transfer employees across payroll systems, move them temporarily to"
              + " another employer (machinery of government for public servants), transfer of"
              + " business, move them to outsourcing arrangements or other such technical"
              + " activities. ")
  /**
   * * &#x60;V&#x60; Voluntary cessation - An employee resignation, retirement, domestic or pressing
   * necessity or abandonment of employment * &#x60;I&#x60; Ill health - An employee resignation due
   * to medical condition that prevents the continuation of employment, such as for illness,
   * ill-health, medical unfitness or total permanent disability * &#x60;D&#x60; Deceased - The
   * death of an employee * &#x60;R&#x60; Redundancy - An employer-initiated termination of
   * employment due to a genuine redundancy or approved early retirement scheme * &#x60;F&#x60;
   * Dismissal - An employer-initiated termination of employment due to dismissal, inability to
   * perform the required work, misconduct or inefficiency * &#x60;C&#x60; Contract cessation - The
   * natural conclusion of a limited employment relationship due to contract/engagement duration or
   * task completion, seasonal work completion, or to cease casuals that are no longer required *
   * &#x60;T&#x60; Transfer - The administrative arrangements performed to transfer employees across
   * payroll systems, move them temporarily to another employer (machinery of government for public
   * servants), transfer of business, move them to outsourcing arrangements or other such technical
   * activities.
   *
   * @return terminationReason TerminationReasonEnum
   */
  public TerminationReasonEnum getTerminationReason() {
    return terminationReason;
  }

  /**
   * * &#x60;V&#x60; Voluntary cessation - An employee resignation, retirement, domestic or pressing
   * necessity or abandonment of employment * &#x60;I&#x60; Ill health - An employee resignation due
   * to medical condition that prevents the continuation of employment, such as for illness,
   * ill-health, medical unfitness or total permanent disability * &#x60;D&#x60; Deceased - The
   * death of an employee * &#x60;R&#x60; Redundancy - An employer-initiated termination of
   * employment due to a genuine redundancy or approved early retirement scheme * &#x60;F&#x60;
   * Dismissal - An employer-initiated termination of employment due to dismissal, inability to
   * perform the required work, misconduct or inefficiency * &#x60;C&#x60; Contract cessation - The
   * natural conclusion of a limited employment relationship due to contract/engagement duration or
   * task completion, seasonal work completion, or to cease casuals that are no longer required *
   * &#x60;T&#x60; Transfer - The administrative arrangements performed to transfer employees across
   * payroll systems, move them temporarily to another employer (machinery of government for public
   * servants), transfer of business, move them to outsourcing arrangements or other such technical
   * activities.
   *
   * @param terminationReason TerminationReasonEnum
   */
  public void setTerminationReason(TerminationReasonEnum terminationReason) {
    this.terminationReason = terminationReason;
  }

  /**
   * bankAccounts
   *
   * @param bankAccounts List&lt;BankAccount&gt;
   * @return Employee
   */
  public Employee bankAccounts(List<BankAccount> bankAccounts) {
    this.bankAccounts = bankAccounts;
    return this;
  }

  /**
   * bankAccounts
   *
   * @param bankAccountsItem BankAccount
   * @return Employee
   */
  public Employee addBankAccountsItem(BankAccount bankAccountsItem) {
    if (this.bankAccounts == null) {
      this.bankAccounts = new ArrayList<BankAccount>();
    }
    this.bankAccounts.add(bankAccountsItem);
    return this;
  }

  /**
   * Get bankAccounts
   *
   * @return bankAccounts
   */
  @ApiModelProperty(value = "")
  /**
   * bankAccounts
   *
   * @return bankAccounts List<BankAccount>
   */
  public List<BankAccount> getBankAccounts() {
    return bankAccounts;
  }

  /**
   * bankAccounts
   *
   * @param bankAccounts List&lt;BankAccount&gt;
   */
  public void setBankAccounts(List<BankAccount> bankAccounts) {
    this.bankAccounts = bankAccounts;
  }

  /**
   * payTemplate
   *
   * @param payTemplate PayTemplate
   * @return Employee
   */
  public Employee payTemplate(PayTemplate payTemplate) {
    this.payTemplate = payTemplate;
    return this;
  }

  /**
   * Get payTemplate
   *
   * @return payTemplate
   */
  @ApiModelProperty(value = "")
  /**
   * payTemplate
   *
   * @return payTemplate PayTemplate
   */
  public PayTemplate getPayTemplate() {
    return payTemplate;
  }

  /**
   * payTemplate
   *
   * @param payTemplate PayTemplate
   */
  public void setPayTemplate(PayTemplate payTemplate) {
    this.payTemplate = payTemplate;
  }

  /**
   * openingBalances
   *
   * @param openingBalances OpeningBalances
   * @return Employee
   */
  public Employee openingBalances(OpeningBalances openingBalances) {
    this.openingBalances = openingBalances;
    return this;
  }

  /**
   * Get openingBalances
   *
   * @return openingBalances
   */
  @ApiModelProperty(value = "")
  /**
   * openingBalances
   *
   * @return openingBalances OpeningBalances
   */
  public OpeningBalances getOpeningBalances() {
    return openingBalances;
  }

  /**
   * openingBalances
   *
   * @param openingBalances OpeningBalances
   */
  public void setOpeningBalances(OpeningBalances openingBalances) {
    this.openingBalances = openingBalances;
  }

  /**
   * taxDeclaration
   *
   * @param taxDeclaration TaxDeclaration
   * @return Employee
   */
  public Employee taxDeclaration(TaxDeclaration taxDeclaration) {
    this.taxDeclaration = taxDeclaration;
    return this;
  }

  /**
   * Get taxDeclaration
   *
   * @return taxDeclaration
   */
  @ApiModelProperty(value = "")
  /**
   * taxDeclaration
   *
   * @return taxDeclaration TaxDeclaration
   */
  public TaxDeclaration getTaxDeclaration() {
    return taxDeclaration;
  }

  /**
   * taxDeclaration
   *
   * @param taxDeclaration TaxDeclaration
   */
  public void setTaxDeclaration(TaxDeclaration taxDeclaration) {
    this.taxDeclaration = taxDeclaration;
  }

  /**
   * leaveBalances
   *
   * @param leaveBalances List&lt;LeaveBalance&gt;
   * @return Employee
   */
  public Employee leaveBalances(List<LeaveBalance> leaveBalances) {
    this.leaveBalances = leaveBalances;
    return this;
  }

  /**
   * leaveBalances
   *
   * @param leaveBalancesItem LeaveBalance
   * @return Employee
   */
  public Employee addLeaveBalancesItem(LeaveBalance leaveBalancesItem) {
    if (this.leaveBalances == null) {
      this.leaveBalances = new ArrayList<LeaveBalance>();
    }
    this.leaveBalances.add(leaveBalancesItem);
    return this;
  }

  /**
   * Get leaveBalances
   *
   * @return leaveBalances
   */
  @ApiModelProperty(value = "")
  /**
   * leaveBalances
   *
   * @return leaveBalances List<LeaveBalance>
   */
  public List<LeaveBalance> getLeaveBalances() {
    return leaveBalances;
  }

  /**
   * leaveBalances
   *
   * @param leaveBalances List&lt;LeaveBalance&gt;
   */
  public void setLeaveBalances(List<LeaveBalance> leaveBalances) {
    this.leaveBalances = leaveBalances;
  }

  /**
   * leaveLines
   *
   * @param leaveLines List&lt;LeaveLine&gt;
   * @return Employee
   */
  public Employee leaveLines(List<LeaveLine> leaveLines) {
    this.leaveLines = leaveLines;
    return this;
  }

  /**
   * leaveLines
   *
   * @param leaveLinesItem LeaveLine
   * @return Employee
   */
  public Employee addLeaveLinesItem(LeaveLine leaveLinesItem) {
    if (this.leaveLines == null) {
      this.leaveLines = new ArrayList<LeaveLine>();
    }
    this.leaveLines.add(leaveLinesItem);
    return this;
  }

  /**
   * Get leaveLines
   *
   * @return leaveLines
   */
  @ApiModelProperty(value = "")
  /**
   * leaveLines
   *
   * @return leaveLines List<LeaveLine>
   */
  public List<LeaveLine> getLeaveLines() {
    return leaveLines;
  }

  /**
   * leaveLines
   *
   * @param leaveLines List&lt;LeaveLine&gt;
   */
  public void setLeaveLines(List<LeaveLine> leaveLines) {
    this.leaveLines = leaveLines;
  }

  /**
   * superMemberships
   *
   * @param superMemberships List&lt;SuperMembership&gt;
   * @return Employee
   */
  public Employee superMemberships(List<SuperMembership> superMemberships) {
    this.superMemberships = superMemberships;
    return this;
  }

  /**
   * superMemberships
   *
   * @param superMembershipsItem SuperMembership
   * @return Employee
   */
  public Employee addSuperMembershipsItem(SuperMembership superMembershipsItem) {
    if (this.superMemberships == null) {
      this.superMemberships = new ArrayList<SuperMembership>();
    }
    this.superMemberships.add(superMembershipsItem);
    return this;
  }

  /**
   * Get superMemberships
   *
   * @return superMemberships
   */
  @ApiModelProperty(value = "")
  /**
   * superMemberships
   *
   * @return superMemberships List<SuperMembership>
   */
  public List<SuperMembership> getSuperMemberships() {
    return superMemberships;
  }

  /**
   * superMemberships
   *
   * @param superMemberships List&lt;SuperMembership&gt;
   */
  public void setSuperMemberships(List<SuperMembership> superMemberships) {
    this.superMemberships = superMemberships;
  }

  /**
   * status
   *
   * @param status EmployeeStatus
   * @return Employee
   */
  public Employee status(EmployeeStatus status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   *
   * @return status
   */
  @ApiModelProperty(value = "")
  /**
   * status
   *
   * @return status EmployeeStatus
   */
  public EmployeeStatus getStatus() {
    return status;
  }

  /**
   * status
   *
   * @param status EmployeeStatus
   */
  public void setStatus(EmployeeStatus status) {
    this.status = status;
  }

  /**
   * Last modified timestamp
   *
   * @return updatedDateUTC
   */
  @ApiModelProperty(example = "/Date(1583967733054+0000)/", value = "Last modified timestamp")
  /**
   * Last modified timestamp
   *
   * @return updatedDateUTC String
   */
  public String getUpdatedDateUTC() {
    return updatedDateUTC;
  }
  /**
   * Last modified timestamp
   *
   * @return OffsetDateTime
   */
  public OffsetDateTime getUpdatedDateUTCAsDate() {
    if (this.updatedDateUTC != null) {
      try {
        return util.convertStringToOffsetDateTime(this.updatedDateUTC);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * Displays array of validation error messages from the API
   *
   * @param validationErrors List&lt;ValidationError&gt;
   * @return Employee
   */
  public Employee validationErrors(List<ValidationError> validationErrors) {
    this.validationErrors = validationErrors;
    return this;
  }

  /**
   * Displays array of validation error messages from the API
   *
   * @param validationErrorsItem ValidationError
   * @return Employee
   */
  public Employee addValidationErrorsItem(ValidationError validationErrorsItem) {
    if (this.validationErrors == null) {
      this.validationErrors = new ArrayList<ValidationError>();
    }
    this.validationErrors.add(validationErrorsItem);
    return this;
  }

  /**
   * Displays array of validation error messages from the API
   *
   * @return validationErrors
   */
  @ApiModelProperty(value = "Displays array of validation error messages from the API")
  /**
   * Displays array of validation error messages from the API
   *
   * @return validationErrors List<ValidationError>
   */
  public List<ValidationError> getValidationErrors() {
    return validationErrors;
  }

  /**
   * Displays array of validation error messages from the API
   *
   * @param validationErrors List&lt;ValidationError&gt;
   */
  public void setValidationErrors(List<ValidationError> validationErrors) {
    this.validationErrors = validationErrors;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Employee employee = (Employee) o;
    return Objects.equals(this.firstName, employee.firstName)
        && Objects.equals(this.lastName, employee.lastName)
        && Objects.equals(this.dateOfBirth, employee.dateOfBirth)
        && Objects.equals(this.homeAddress, employee.homeAddress)
        && Objects.equals(this.startDate, employee.startDate)
        && Objects.equals(this.title, employee.title)
        && Objects.equals(this.middleNames, employee.middleNames)
        && Objects.equals(this.email, employee.email)
        && Objects.equals(this.gender, employee.gender)
        && Objects.equals(this.phone, employee.phone)
        && Objects.equals(this.mobile, employee.mobile)
        && Objects.equals(this.twitterUserName, employee.twitterUserName)
        && Objects.equals(this.isAuthorisedToApproveLeave, employee.isAuthorisedToApproveLeave)
        && Objects.equals(
            this.isAuthorisedToApproveTimesheets, employee.isAuthorisedToApproveTimesheets)
        && Objects.equals(this.jobTitle, employee.jobTitle)
        && Objects.equals(this.classification, employee.classification)
        && Objects.equals(this.ordinaryEarningsRateID, employee.ordinaryEarningsRateID)
        && Objects.equals(this.payrollCalendarID, employee.payrollCalendarID)
        && Objects.equals(this.employeeGroupName, employee.employeeGroupName)
        && Objects.equals(this.employeeID, employee.employeeID)
        && Objects.equals(this.terminationDate, employee.terminationDate)
        && Objects.equals(this.terminationReason, employee.terminationReason)
        && Objects.equals(this.bankAccounts, employee.bankAccounts)
        && Objects.equals(this.payTemplate, employee.payTemplate)
        && Objects.equals(this.openingBalances, employee.openingBalances)
        && Objects.equals(this.taxDeclaration, employee.taxDeclaration)
        && Objects.equals(this.leaveBalances, employee.leaveBalances)
        && Objects.equals(this.leaveLines, employee.leaveLines)
        && Objects.equals(this.superMemberships, employee.superMemberships)
        && Objects.equals(this.status, employee.status)
        && Objects.equals(this.updatedDateUTC, employee.updatedDateUTC)
        && Objects.equals(this.validationErrors, employee.validationErrors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        firstName,
        lastName,
        dateOfBirth,
        homeAddress,
        startDate,
        title,
        middleNames,
        email,
        gender,
        phone,
        mobile,
        twitterUserName,
        isAuthorisedToApproveLeave,
        isAuthorisedToApproveTimesheets,
        jobTitle,
        classification,
        ordinaryEarningsRateID,
        payrollCalendarID,
        employeeGroupName,
        employeeID,
        terminationDate,
        terminationReason,
        bankAccounts,
        payTemplate,
        openingBalances,
        taxDeclaration,
        leaveBalances,
        leaveLines,
        superMemberships,
        status,
        updatedDateUTC,
        validationErrors);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Employee {\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    homeAddress: ").append(toIndentedString(homeAddress)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    middleNames: ").append(toIndentedString(middleNames)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    mobile: ").append(toIndentedString(mobile)).append("\n");
    sb.append("    twitterUserName: ").append(toIndentedString(twitterUserName)).append("\n");
    sb.append("    isAuthorisedToApproveLeave: ")
        .append(toIndentedString(isAuthorisedToApproveLeave))
        .append("\n");
    sb.append("    isAuthorisedToApproveTimesheets: ")
        .append(toIndentedString(isAuthorisedToApproveTimesheets))
        .append("\n");
    sb.append("    jobTitle: ").append(toIndentedString(jobTitle)).append("\n");
    sb.append("    classification: ").append(toIndentedString(classification)).append("\n");
    sb.append("    ordinaryEarningsRateID: ")
        .append(toIndentedString(ordinaryEarningsRateID))
        .append("\n");
    sb.append("    payrollCalendarID: ").append(toIndentedString(payrollCalendarID)).append("\n");
    sb.append("    employeeGroupName: ").append(toIndentedString(employeeGroupName)).append("\n");
    sb.append("    employeeID: ").append(toIndentedString(employeeID)).append("\n");
    sb.append("    terminationDate: ").append(toIndentedString(terminationDate)).append("\n");
    sb.append("    terminationReason: ").append(toIndentedString(terminationReason)).append("\n");
    sb.append("    bankAccounts: ").append(toIndentedString(bankAccounts)).append("\n");
    sb.append("    payTemplate: ").append(toIndentedString(payTemplate)).append("\n");
    sb.append("    openingBalances: ").append(toIndentedString(openingBalances)).append("\n");
    sb.append("    taxDeclaration: ").append(toIndentedString(taxDeclaration)).append("\n");
    sb.append("    leaveBalances: ").append(toIndentedString(leaveBalances)).append("\n");
    sb.append("    leaveLines: ").append(toIndentedString(leaveLines)).append("\n");
    sb.append("    superMemberships: ").append(toIndentedString(superMemberships)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    validationErrors: ").append(toIndentedString(validationErrors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
