/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sql2java;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sourceforge.sql2java.Column;
import net.sourceforge.sql2java.Table;

public class Database {
    private String[] tableTypes;
    private Connection pConnection;
    private DatabaseMetaData meta;
    private Vector tables;
    private Hashtable tableHash;
    private String driver;
    private String url;
    private String username;
    private String password;
    private String catalog;
    private String schema;
    private String tablenamepattern;
    private boolean retrieveRemarks = true;

    public void setOracleRetrieveRemarks(boolean retrieveRemarks) {
        this.retrieveRemarks = retrieveRemarks;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setTableNamePattern(String tablenamepattern) {
        this.tablenamepattern = tablenamepattern;
    }

    public void setTableTypes(String[] tt) {
        this.tableTypes = tt;
    }

    public boolean getOracleRetrieveRemarks() {
        return this.retrieveRemarks;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableNamePattern() {
        return this.tablenamepattern;
    }

    public String[] getTableTypes() {
        return this.tableTypes;
    }

    public void setSchema(String schema) {
        this.schema = "null".equalsIgnoreCase(schema) ? null : schema;
    }

    public void cleanup() {
        if (this.pConnection != null) {
            try {
                if (this.url.contains("jdbc:hsqldb:file")) {
                    Statement statement = this.pConnection.createStatement();
                    statement.executeUpdate("SHUTDOWN");
                    statement.close();
                }
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            try {
                this.pConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public Table[] getRelationTable(Table table) {
        Vector<Table> vector = new Vector<Table>();
        for (int iIndex = 0; iIndex < this.tables.size(); ++iIndex) {
            Table tempTable = (Table)this.tables.get(iIndex);
            if (table.equals(tempTable) || !tempTable.isRelationTable() || !tempTable.relationConnectsTo(table) || vector.contains(tempTable)) continue;
            vector.add(tempTable);
        }
        return vector.toArray(new Table[0]);
    }

    public void load() throws SQLException, ClassNotFoundException {
        Class.forName(this.driver);
        System.out.println("Connecting to " + this.username + " on " + this.url + " ...");
        this.pConnection = DriverManager.getConnection(this.url, this.username, this.password);
        System.out.println("    Connected.");
        this.meta = this.pConnection.getMetaData();
        System.out.println("    Database server :" + this.meta.getDatabaseProductName() + ".");
        this.tables = new Vector();
        this.tableHash = new Hashtable();
        this.loadTables();
        this.loadColumns();
        this.loadPrimaryKeys();
    }

    public Table[] getTables() {
        return this.tables.toArray(new Table[0]);
    }

    private void addTable(Table t) {
        this.tables.addElement(t);
        this.tableHash.put(t.getName(), t);
    }

    public Table getTable(String name) {
        return (Table)this.tableHash.get(name);
    }

    private void loadTables() throws SQLException {
        System.out.println("Loading table list according to pattern " + this.tablenamepattern + " ...");
        StringTokenizer st = new StringTokenizer(this.tablenamepattern, ",; \t");
        while (st.hasMoreTokens()) {
            String pattern = st.nextToken().trim();
            ResultSet resultSet = this.meta.getTables(this.catalog, this.schema, pattern, this.tableTypes);
            while (resultSet.next()) {
                Table table = new Table();
                table.setDatabase(this);
                table.setCatalog(resultSet.getString("TABLE_CAT"));
                String sch = resultSet.getString("TABLE_SCHEM");
                System.out.println(sch);
                table.setSchema(sch);
                table.setName(resultSet.getString("TABLE_NAME"));
                table.setType(resultSet.getString("TABLE_TYPE"));
                table.setRemarks(resultSet.getString("REMARKS"));
                this.addTable(table);
                System.out.println("    table " + table.getName() + " found");
            }
            resultSet.close();
        }
    }

    private void loadColumns() throws SQLException {
        Table[] tables = this.getTables();
        System.out.println("Loading columns ...");
        boolean b = false;
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            ResultSet resultSet = this.meta.getColumns(this.catalog, this.schema, table.getName(), "%");
            Column c = null;
            while (resultSet.next()) {
                c = new Column();
                c.setDatabase(this);
                c.setCatalog(resultSet.getString("TABLE_CAT"));
                c.setSchema(resultSet.getString("TABLE_SCHEM"));
                c.setTableName(resultSet.getString("TABLE_NAME"));
                c.setName(resultSet.getString("COLUMN_NAME"));
                c.setType(resultSet.getShort("DATA_TYPE"));
                c.setSize(resultSet.getInt("COLUMN_SIZE"));
                c.setDecimalDigits(resultSet.getInt("DECIMAL_DIGITS"));
                c.setRadix(resultSet.getInt("NUM_PREC_RADIX"));
                c.setNullable(resultSet.getInt("NULLABLE"));
                c.setRemarks(resultSet.getString("REMARKS"));
                c.setDefaultValue(resultSet.getString("COLUMN_DEF"));
                c.setOrdinalPosition(resultSet.getInt("ORDINAL_POSITION"));
                table.addColumn(c);
            }
            System.out.println("    " + table.getName() + " found " + table.countColumns() + " columns");
            resultSet.close();
        }
    }

    private void loadPrimaryKeys() throws SQLException {
        System.out.println("Loading primary keys ...");
        Table[] tables = this.getTables();
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            ResultSet resultSet = this.meta.getPrimaryKeys(this.catalog, this.schema, table.getName());
            while (resultSet.next()) {
                Column col = table.getColumn(resultSet.getString("COLUMN_NAME"));
                table.addPrimaryKey(col);
                System.out.println("    " + col.getFullName() + " found");
            }
            resultSet.close();
        }
    }

    private void loadImportedKeys() throws SQLException {
        System.out.println("Loading imported keys ...");
        Table[] tables = this.getTables();
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            ResultSet resultSet = this.meta.getImportedKeys(this.catalog, this.schema, table.getName());
            while (resultSet.next()) {
                String tabName = resultSet.getString("FKTABLE_NAME");
                String colName = resultSet.getString("FKCOLUMN_NAME");
                String foreignTabName = resultSet.getString("PKTABLE_NAME");
                String foreignColName = resultSet.getString("PKCOLUMN_NAME");
                Column col = this.getTable(tabName).getColumn(colName);
                Column foreignCol = this.getTable(foreignTabName).getColumn(foreignColName);
                col.addForeignKey(foreignCol);
                foreignCol.addImportedKey(col);
                System.out.println("    " + col.getFullName() + " -> " + foreignCol.getFullName() + " found ");
            }
            resultSet.close();
        }
    }

    private void loadManyToMany() throws SQLException {
        System.out.println("Loading many to many relationships...");
        Table[] tables = this.getTables();
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            ResultSet resultSet = this.meta.getImportedKeys(this.catalog, this.schema, table.getName());
            while (resultSet.next()) {
                Column pkCol;
                String tabName = resultSet.getString("PKTABLE_NAME");
                String colName = resultSet.getString("PKCOLUMN_NAME");
                System.out.println("    many to many " + tabName + " " + colName);
                Table pkTable = this.getTable(tabName);
                Column fkCol = table.getColumn(resultSet.getString("FKCOLUMN_NAME"));
                if (pkTable == null || (pkCol = pkTable.getColumn(colName)) == null || fkCol == null) continue;
                pkTable.addManyToManyKey(fkCol, pkCol);
            }
            resultSet.close();
        }
    }

    private void loadIndexes() throws SQLException {
        System.out.println("Loading indexes ...");
        Table[] tables = this.getTables();
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            ResultSet resultSet = this.meta.getIndexInfo(this.catalog, this.schema, table.getName(), true, true);
            while (resultSet.next()) {
                Column col;
                String colName = resultSet.getString("COLUMN_NAME");
                String indName = resultSet.getString("INDEX_NAME");
                if (colName == null || indName == null || (col = table.getColumn(colName)).isPrimaryKey()) continue;
                System.out.println("  Found interesting index " + indName + " on " + colName + " for table " + table.getName());
            }
            resultSet.close();
        }
    }

    public String[] getAllPackages() {
        Vector<String> vector = new Vector<String>();
        for (int iIndex = 0; iIndex < this.tables.size(); ++iIndex) {
            Table table = (Table)this.tables.get(iIndex);
            String[] packages = table.getLinkedPackages();
            for (int i = 0; i < packages.length; ++i) {
                if (vector.contains(packages[i])) continue;
                vector.add(packages[i]);
            }
        }
        return vector.toArray(new String[0]);
    }
}

