/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.dynamicdatasource;

import com.github.yeecode.dynamicdatasource.datasource.DynamicDataSourceConfig;
import com.github.yeecode.dynamicdatasource.model.DataSourceInfo;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final ThreadLocal<String> CURRENT_DATASOURCE_NAME = new ThreadLocal();
    private ConcurrentHashMap<Object, Object> dataSourcesMap = new ConcurrentHashMap();
    private DataSource defaultDataSource;

    public DynamicDataSource(DataSource defaultDataSource) {
        super.setDefaultTargetDataSource((Object)defaultDataSource);
        super.setTargetDataSources(this.dataSourcesMap);
    }

    public Object determineCurrentLookupKey() {
        return CURRENT_DATASOURCE_NAME.get();
    }

    public synchronized boolean addDataSource(DataSourceInfo dataSourceInfo) {
        if (this.dataSourcesMap.containsKey(dataSourceInfo.getName())) {
            return false;
        }
        DataSource dataSource = DynamicDataSourceConfig.createDataSource(dataSourceInfo);
        this.dataSourcesMap.put(dataSourceInfo.getName(), dataSource);
        super.afterPropertiesSet();
        return true;
    }

    public synchronized void delDataSource(String dataSourceName) {
        if (this.dataSourcesMap.containsKey(dataSourceName)) {
            this.dataSourcesMap.remove(dataSourceName);
        }
    }

    public boolean switchDataSource(String dataSourceName) {
        if (!this.dataSourcesMap.containsKey(dataSourceName)) {
            return false;
        }
        CURRENT_DATASOURCE_NAME.set(dataSourceName);
        return true;
    }

    public void setDefaultDataSource(DataSourceInfo dataSourceInfo) {
        this.addDataSource(dataSourceInfo);
        this.defaultDataSource = (DataSource)this.dataSourcesMap.get(dataSourceInfo.getName());
        super.setDefaultTargetDataSource((Object)this.defaultDataSource);
    }

    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }
}

