/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.bean;

import com.alibaba.fastjson.JSON;
import com.github.yeecode.objectLogger.client.bean.ObjectLoggerConfigBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpBean {
    private static final Log LOGGER = LogFactory.getLog(HttpBean.class);
    @Autowired(required=false)
    private ObjectLoggerConfigBean objectLoggerConfigBean;

    public void sendLog(String jsonString) {
        try {
            HashMap<String, String> logParamMap = new HashMap<String, String>();
            logParamMap.put("logJsonString", jsonString);
            String response = this.jsonPost(this.objectLoggerConfigBean.getAddLogApi(), logParamMap);
            System.out.println(response);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"sendLog error!", (Throwable)ex);
        }
    }

    private String jsonPost(String strURL, Map<String, String> params) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            out.append(JSON.toJSONString(params));
            out.flush();
            out.close();
            int code = connection.getResponseCode();
            InputStream is = null;
            is = code == 200 ? connection.getInputStream() : connection.getErrorStream();
            int length = connection.getContentLength();
            if (length != -1) {
                byte[] data = new byte[length];
                byte[] temp = new byte[512];
                int readLen = 0;
                int destPos = 0;
                while ((readLen = is.read(temp)) > 0) {
                    System.arraycopy(temp, 0, data, destPos, readLen);
                    destPos += readLen;
                }
                String result = new String(data, "UTF-8");
                return result;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception occur when send http post request!", (Throwable)e);
        }
        return "error";
    }
}

