/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.constant;

import com.alibaba.fastjson.JSON;
import com.github.yeecode.objectLogger.client.bean.Html2Text;
import com.github.yeecode.objectLogger.client.bean.LocalTypeHandler;
import com.github.yeecode.objectLogger.client.model.ActionItemModel;
import com.github.yeecode.objectLogger.client.service.LogClient;
import difflib.Delta;
import difflib.DiffRow;
import difflib.DiffRowGenerator;
import difflib.DiffUtils;
import difflib.Patch;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public enum AttributeTypeEnum {
    NORMAL{

        @Override
        public ActionItemModel handler(LocalTypeHandler localTypeHandler, String subLocalType, String oldValue, String newValue) {
            ActionItemModel actionItemModel = new ActionItemModel();
            actionItemModel.setOldValue((String)JSON.parseObject((String)oldValue, String.class));
            actionItemModel.setNewValue((String)JSON.parseObject((String)newValue, String.class));
            return actionItemModel;
        }
    }
    ,
    TEXT{

        @Override
        public ActionItemModel handler(LocalTypeHandler localTypeHandler, String subLocalType, String oldValue, String newValue) {
            String simpleOldValue = Html2Text.simpleHtml((String)JSON.parseObject((String)oldValue, String.class));
            String simpleNewValue = Html2Text.simpleHtml((String)JSON.parseObject((String)newValue, String.class));
            if (simpleOldValue == null || simpleNewValue == null || simpleOldValue.equals(simpleNewValue)) {
                return null;
            }
            ActionItemModel actionItemModel = new ActionItemModel();
            actionItemModel.setOldValue(oldValue);
            actionItemModel.setNewValue(newValue);
            actionItemModel.setDiffValue(this.diffText(oldValue, newValue));
            return actionItemModel;
        }
    }
    ,
    LOCALTYPE{

        @Override
        public ActionItemModel handler(LocalTypeHandler localTypeHandler, String subLocalType, String oldValue, String newValue) {
            if (subLocalType == null) {
                return null;
            }
            return localTypeHandler.handleLocalType(subLocalType, oldValue, newValue);
        }
    };

    private static LogClient LogClient;

    public abstract ActionItemModel handler(LocalTypeHandler var1, String var2, String var3, String var4);

    public String diffText(String oldText, String newText) {
        StringBuilder outputSb = new StringBuilder();
        List oldStringList = CollectionUtils.arrayToList((Object)Html2Text.simpleHtml(oldText).split("\n"));
        List newStringList = CollectionUtils.arrayToList((Object)Html2Text.simpleHtml(newText).split("\n"));
        Patch patch = DiffUtils.diff((List)oldStringList, (List)newStringList);
        DiffRowGenerator.Builder builder = new DiffRowGenerator.Builder();
        builder.showInlineDiffs(false).columnWidth(Integer.MAX_VALUE);
        DiffRowGenerator generator = builder.build();
        LinkedHashMap<Integer, ArrayList<DiffRow>> diffRowMap = new LinkedHashMap<Integer, ArrayList<DiffRow>>();
        for (Object delta : patch.getDeltas()) {
            List originalLines = ((Delta)delta).getOriginal().getLines();
            List revisedLines = ((Delta)delta).getRevised().getLines();
            List generateDiffRows = generator.generateDiffRows(originalLines, revisedLines);
            int leftPos = ((Delta)delta).getOriginal().getPosition();
            int rightPos = ((Delta)delta).getRevised().getPosition();
            for (DiffRow row : generateDiffRows) {
                ArrayList<DiffRow> diffRowList = (ArrayList<DiffRow>)diffRowMap.get(leftPos);
                if (diffRowList == null) {
                    diffRowList = new ArrayList<DiffRow>();
                }
                diffRowList.add(row);
                diffRowMap.put(leftPos, diffRowList);
            }
        }
        Set entrySet = diffRowMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Integer pos = (Integer)entry.getKey();
            List diffRowList = (List)entry.getValue();
            outputSb.append("Line ").append(pos + 1).append("<br/>");
            for (DiffRow row : diffRowList) {
                DiffRow.Tag tag = row.getTag();
                if (tag == DiffRow.Tag.INSERT) {
                    outputSb.append("&nbsp;&nbsp; +\uff1a <u> ").append(this.replaceImgTag(row.getNewLine())).append(" </u> <br/>");
                    continue;
                }
                if (tag == DiffRow.Tag.CHANGE) {
                    if (!row.getOldLine().trim().isEmpty()) {
                        outputSb.append("&nbsp;&nbsp;&nbsp; -\uff1a <del> ");
                        outputSb.append(this.replaceImgTag(row.getOldLine()));
                        outputSb.append(" </del> <br/>");
                    }
                    if (row.getNewLine().trim().isEmpty()) continue;
                    outputSb.append("&nbsp;&nbsp; +\uff1a <u> ");
                    outputSb.append(this.replaceImgTag(row.getNewLine()));
                    outputSb.append(" </u> <br/>");
                    continue;
                }
                if (tag != DiffRow.Tag.DELETE) continue;
                outputSb.append("&nbsp;&nbsp;&nbsp; -\uff1a <del> ").append(this.replaceImgTag(row.getOldLine())).append(" </del> <br/>");
            }
        }
        return outputSb.toString();
    }

    private String replaceImgTag(String s) {
        return s.replaceAll("\u3010\u3010-START_IMG-\u3011\u3011", "<img ").replaceAll("\u3010\u3010-END_IMG-\u3011\u3011", " >");
    }

    static {
        LogClient = new LogClient();
    }
}

