/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.richText;

import com.github.yeecode.objectLogger.client.richText.Html2Text;
import difflib.Delta;
import difflib.DiffRow;
import difflib.DiffRowGenerator;
import difflib.DiffUtils;
import difflib.Patch;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class RichTextHandler {
    private RichTextHandler() {
    }

    public static String diffText(String oldText, String newText) {
        StringBuilder outputSb = new StringBuilder();
        List oldStringList = CollectionUtils.arrayToList((Object)Html2Text.simpleHtml(oldText).split("\n"));
        List newStringList = CollectionUtils.arrayToList((Object)Html2Text.simpleHtml(newText).split("\n"));
        Patch patch = DiffUtils.diff((List)oldStringList, (List)newStringList);
        DiffRowGenerator.Builder builder = new DiffRowGenerator.Builder();
        builder.showInlineDiffs(false).columnWidth(Integer.MAX_VALUE);
        DiffRowGenerator generator = builder.build();
        LinkedHashMap<Integer, ArrayList<DiffRow>> diffRowMap = new LinkedHashMap<Integer, ArrayList<DiffRow>>();
        for (Object delta : patch.getDeltas()) {
            List originalLines = ((Delta)delta).getOriginal().getLines();
            List revisedLines = ((Delta)delta).getRevised().getLines();
            List generateDiffRows = generator.generateDiffRows(originalLines, revisedLines);
            int leftPos = ((Delta)delta).getOriginal().getPosition();
            int rightPos = ((Delta)delta).getRevised().getPosition();
            for (DiffRow row : generateDiffRows) {
                ArrayList<DiffRow> diffRowList = (ArrayList<DiffRow>)diffRowMap.get(leftPos);
                if (diffRowList == null) {
                    diffRowList = new ArrayList<DiffRow>();
                }
                diffRowList.add(row);
                diffRowMap.put(leftPos, diffRowList);
            }
        }
        Set entrySet = diffRowMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Integer pos = (Integer)entry.getKey();
            List diffRowList = (List)entry.getValue();
            outputSb.append("Line ").append(pos + 1).append("<br/>");
            for (DiffRow row : diffRowList) {
                DiffRow.Tag tag = row.getTag();
                if (tag == DiffRow.Tag.INSERT) {
                    outputSb.append("&nbsp;&nbsp; +\uff1a <u> ").append(RichTextHandler.replaceImgTag(row.getNewLine())).append(" </u> <br/>");
                    continue;
                }
                if (tag == DiffRow.Tag.CHANGE) {
                    if (!row.getOldLine().trim().isEmpty()) {
                        outputSb.append("&nbsp;&nbsp;&nbsp; -\uff1a <del> ");
                        outputSb.append(RichTextHandler.replaceImgTag(row.getOldLine()));
                        outputSb.append(" </del> <br/>");
                    }
                    if (row.getNewLine().trim().isEmpty()) continue;
                    outputSb.append("&nbsp;&nbsp; +\uff1a <u> ");
                    outputSb.append(RichTextHandler.replaceImgTag(row.getNewLine()));
                    outputSb.append(" </u> <br/>");
                    continue;
                }
                if (tag != DiffRow.Tag.DELETE) continue;
                outputSb.append("&nbsp;&nbsp;&nbsp; -\uff1a <del> ").append(RichTextHandler.replaceImgTag(row.getOldLine())).append(" </del> <br/>");
            }
        }
        return outputSb.toString();
    }

    private static String replaceImgTag(String s) {
        return s.replaceAll("\u3010\u3010-START_IMG-\u3011\u3011", "<img ").replaceAll("\u3010\u3010-END_IMG-\u3011\u3011", " >");
    }
}

