/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.service;

import com.github.yeecode.objectLogger.client.config.ObjectLoggerConfig;
import com.github.yeecode.objectLogger.client.handler.BaseExtendedTypeHandler;
import com.github.yeecode.objectLogger.client.http.HttpUtil;
import com.github.yeecode.objectLogger.client.model.BaseAttributeModel;
import com.github.yeecode.objectLogger.client.task.LogAttributesTask;
import com.github.yeecode.objectLogger.client.task.LogObjectTask;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogClient {
    @Autowired
    private ObjectLoggerConfig objectLoggerConfig;
    @Autowired
    private HttpUtil httpUtil;
    @Autowired(required=false)
    private BaseExtendedTypeHandler baseExtendedTypeHandler;
    private ExecutorService fixedThreadPool = Executors.newFixedThreadPool(10);

    public void logObject(Integer objectId, String operator, String operationName, String operationAlias, String extraWords, String comment, Object oldObject, Object newObject) {
        try {
            LogObjectTask logObjectTask = new LogObjectTask(objectId, operator, operationName, operationAlias, extraWords, comment, oldObject, newObject, this.objectLoggerConfig, this.httpUtil, this.baseExtendedTypeHandler);
            this.fixedThreadPool.execute(logObjectTask);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void logAttributes(String objectName, Integer objectId, String operator, String operationName, String operationAlias, String extraWords, String comment, List<BaseAttributeModel> baseAttributeModelList) {
        try {
            LogAttributesTask logAttributesTask = new LogAttributesTask(objectName, objectId, operator, operationName, operationAlias, extraWords, comment, baseAttributeModelList, this.objectLoggerConfig, this.httpUtil);
            this.fixedThreadPool.execute(logAttributesTask);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

