/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.task;

import com.alibaba.fastjson.JSON;
import com.github.yeecode.objectLogger.client.config.ObjectLoggerConfig;
import com.github.yeecode.objectLogger.client.handler.BaseExtendedTypeHandler;
import com.github.yeecode.objectLogger.client.handler.BuiltinTypeHandler;
import com.github.yeecode.objectLogger.client.http.HttpUtil;
import com.github.yeecode.objectLogger.client.model.BaseAttributeModel;
import com.github.yeecode.objectLogger.client.model.OperationModel;
import com.github.yeecode.objectLogger.client.wrapper.ClazzWrapper;
import com.github.yeecode.objectLogger.client.wrapper.FieldWrapper;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class LogObjectTask
implements Runnable {
    private BaseExtendedTypeHandler baseExtendedTypeHandler;
    private Integer objectId;
    private String operator;
    private String operationName;
    private String operationAlias;
    private String extraWords;
    private String comment;
    private Object oldObject;
    private Object newObject;
    private ObjectLoggerConfig objectLoggerConfig;
    private HttpUtil httpUtil;

    public LogObjectTask(Integer objectId, String operator, String operationName, String operationAlias, String extraWords, String comment, Object oldObject, Object newObject, ObjectLoggerConfig objectLoggerConfig, HttpUtil httpUtil, BaseExtendedTypeHandler baseExtendedTypeHandler) {
        this.objectId = objectId;
        this.operator = operator;
        this.operationName = operationName;
        this.operationAlias = operationAlias;
        this.extraWords = extraWords;
        this.comment = comment;
        this.oldObject = oldObject;
        this.newObject = newObject;
        this.objectLoggerConfig = objectLoggerConfig;
        this.httpUtil = httpUtil;
        this.baseExtendedTypeHandler = baseExtendedTypeHandler;
    }

    @Override
    public void run() {
        try {
            OperationModel operationModel = new OperationModel(this.objectLoggerConfig.getBusinessAppName(), this.oldObject.getClass().getSimpleName(), this.objectId, this.operator, this.operationName, this.operationAlias, this.extraWords, this.comment, new Date());
            Class<?> modelClazz = this.newObject.getClass();
            Class<?> oldModelClazz = this.oldObject.getClass();
            if (oldModelClazz.equals(modelClazz)) {
                ClazzWrapper clazzWrapper = new ClazzWrapper(modelClazz);
                List<Field> fieldList = clazzWrapper.getFieldList();
                for (Field field : fieldList) {
                    BaseAttributeModel baseAttributeModel;
                    field.setAccessible(true);
                    FieldWrapper fieldWrapper = new FieldWrapper(field, field.get(this.oldObject), field.get(this.newObject));
                    if (!fieldWrapper.isWithLogTag() && !"true".equals(this.objectLoggerConfig.getAutoLogAttributes()) || this.nullableEquals(fieldWrapper.getOldValue(), fieldWrapper.getNewValue()) || (baseAttributeModel = fieldWrapper.isWithExtendedType() ? this.handleExtendedTypeItem(fieldWrapper) : this.handleBuiltinTypeItem(fieldWrapper)) == null) continue;
                    operationModel.addBaseActionItemModel(baseAttributeModel);
                }
            }
            if (!CollectionUtils.isEmpty(operationModel.getAttributeModelList())) {
                this.httpUtil.sendLog(JSON.toJSONString((Object)operationModel));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private BaseAttributeModel handleBuiltinTypeItem(FieldWrapper fieldWrapper) {
        BaseAttributeModel handlerOutput;
        BuiltinTypeHandler builtinType = BuiltinTypeHandler.NORMAL;
        if (fieldWrapper.getLogTag() != null) {
            builtinType = fieldWrapper.getLogTag().builtinType();
        }
        if ((handlerOutput = builtinType.handlerAttributeChange(fieldWrapper)) != null) {
            handlerOutput.setAttributeName(fieldWrapper.getAttributeName());
            handlerOutput.setAttributeAlias(fieldWrapper.getAttributeAlias());
            handlerOutput.setAttributeType(builtinType.name());
            return handlerOutput;
        }
        return null;
    }

    private BaseAttributeModel handleExtendedTypeItem(FieldWrapper fieldWrapper) {
        BaseAttributeModel baseAttributeModel = this.baseExtendedTypeHandler.handleAttributeChange(fieldWrapper.getExtendedType(), fieldWrapper.getAttributeName(), fieldWrapper.getAttributeAlias(), fieldWrapper.getOldValue(), fieldWrapper.getNewValue());
        if (baseAttributeModel != null) {
            if (baseAttributeModel.getAttributeType() == null) {
                baseAttributeModel.setAttributeType(fieldWrapper.getExtendedType());
            }
            if (baseAttributeModel.getAttributeName() == null) {
                baseAttributeModel.setAttributeName(fieldWrapper.getAttributeName());
            }
            if (baseAttributeModel.getAttributeAlias() == null) {
                baseAttributeModel.setAttributeAlias(fieldWrapper.getAttributeAlias());
            }
        }
        return baseAttributeModel;
    }

    private boolean nullableEquals(Object a, Object b) {
        return a == null && b == null || a != null && a.equals(b);
    }
}

