/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectlogger.client.richText;

import com.github.yeecode.objectlogger.client.richText.Fragment;
import com.github.yeecode.objectlogger.client.richText.Html2Text;
import com.github.yeecode.objectlogger.client.richText.Part;
import com.github.yeecode.objectlogger.client.richText.PartType;
import com.google.gson.Gson;
import difflib.Delta;
import difflib.DiffRow;
import difflib.DiffRowGenerator;
import difflib.DiffUtils;
import difflib.Patch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RichTextHandler {
    private RichTextHandler() {
    }

    public static String diffText(String oldText, String newText) {
        List<String> oldStringList = Arrays.asList(Html2Text.simpleHtml(oldText).split("\n"));
        List<String> newStringList = Arrays.asList(Html2Text.simpleHtml(newText).split("\n"));
        Patch patch = DiffUtils.diff(oldStringList, newStringList);
        DiffRowGenerator.Builder builder = new DiffRowGenerator.Builder();
        builder.showInlineDiffs(false).columnWidth(Integer.MAX_VALUE);
        DiffRowGenerator generator = builder.build();
        LinkedHashMap<Integer, ArrayList<DiffRow>> diffRowMap = new LinkedHashMap<Integer, ArrayList<DiffRow>>();
        for (Object delta : patch.getDeltas()) {
            List originalLines = ((Delta)delta).getOriginal().getLines();
            List revisedLines = ((Delta)delta).getRevised().getLines();
            List generateDiffRows = generator.generateDiffRows(originalLines, revisedLines);
            int leftPos = ((Delta)delta).getOriginal().getPosition();
            int rightPos = ((Delta)delta).getRevised().getPosition();
            for (DiffRow row : generateDiffRows) {
                ArrayList<DiffRow> diffRowList = (ArrayList<DiffRow>)diffRowMap.get(leftPos);
                if (diffRowList == null) {
                    diffRowList = new ArrayList<DiffRow>();
                }
                diffRowList.add(row);
                diffRowMap.put(leftPos, diffRowList);
            }
        }
        HashMap<String, Object> textDiffMap = new HashMap<String, Object>();
        textDiffMap.put("version", "1.0.0");
        ArrayList<Fragment> diffFragmentList = new ArrayList<Fragment>();
        Set entrySet = diffRowMap.entrySet();
        for (Map.Entry entry : entrySet) {
            Integer pos = (Integer)entry.getKey();
            List diffRowList = (List)entry.getValue();
            Fragment fragment = new Fragment(pos + 1);
            ArrayList<Part> partList = new ArrayList<Part>();
            for (DiffRow row : diffRowList) {
                Part part;
                DiffRow.Tag tag = row.getTag();
                if (tag == DiffRow.Tag.INSERT) {
                    part = new Part(PartType.ADD, RichTextHandler.replaceImgTag(row.getNewLine()));
                    partList.add(part);
                    continue;
                }
                if (tag == DiffRow.Tag.CHANGE) {
                    if (!row.getOldLine().trim().isEmpty()) {
                        part = new Part(PartType.CHANGE_OLD, RichTextHandler.replaceImgTag(row.getOldLine()));
                        partList.add(part);
                    }
                    if (row.getNewLine().trim().isEmpty()) continue;
                    part = new Part(PartType.CHANGE_NEW, RichTextHandler.replaceImgTag(row.getNewLine()));
                    partList.add(part);
                    continue;
                }
                if (tag != DiffRow.Tag.DELETE) continue;
                part = new Part(PartType.DEL, RichTextHandler.replaceImgTag(row.getOldLine()));
                partList.add(part);
            }
            fragment.setPartList(partList);
            diffFragmentList.add(fragment);
        }
        textDiffMap.put("content", diffFragmentList);
        return new Gson().toJson(textDiffMap);
    }

    private static String replaceImgTag(String s) {
        return s.replaceAll("com.github.yeecode.objectlogger.client.IMG_LEFT", "<img ").replaceAll("com.github.yeecode.objectlogger.client.IMG_RIGHT", " >");
    }
}

