/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectlogger.client.service;

import com.github.yeecode.objectlogger.client.config.ObjectLoggerConfig;
import com.github.yeecode.objectlogger.client.handler.BaseExtendedTypeHandler;
import com.github.yeecode.objectlogger.client.http.HttpUtil;
import com.github.yeecode.objectlogger.client.model.BaseAttributeModel;
import com.github.yeecode.objectlogger.client.task.LogAttributesTask;
import com.github.yeecode.objectlogger.client.task.LogObjectTask;
import com.google.gson.Gson;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogClient {
    @Autowired
    private ObjectLoggerConfig objectLoggerConfig;
    @Autowired
    private HttpUtil httpUtil;
    @Autowired(required=false)
    private BaseExtendedTypeHandler baseExtendedTypeHandler;
    private ExecutorService fixedThreadPool = Executors.newFixedThreadPool(10);

    public <T> T deepCopy(T originalObject) {
        Gson gson = new Gson();
        return (T)gson.fromJson(gson.toJson(originalObject), originalObject.getClass());
    }

    public void logObject(String objectId, String operator, String operationName, String operationAlias, String extraWords, String comment, Object oldObject, Object newObject) {
        try {
            LogObjectTask logObjectTask = new LogObjectTask(objectId, operator, operationName, operationAlias, extraWords, comment, oldObject, newObject, this.objectLoggerConfig, this.httpUtil, this.baseExtendedTypeHandler);
            this.fixedThreadPool.execute(logObjectTask);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void logAttributes(String objectName, String objectId, String operator, String operationName, String operationAlias, String extraWords, String comment, List<BaseAttributeModel> baseAttributeModelList) {
        try {
            LogAttributesTask logAttributesTask = new LogAttributesTask(objectName, objectId, operator, operationName, operationAlias, extraWords, comment, baseAttributeModelList, this.objectLoggerConfig, this.httpUtil);
            this.fixedThreadPool.execute(logAttributesTask);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

