/*
 * Decompiled with CFR 0.152.
 */
package com.github.yin.cli.annotations;

import com.github.yin.cli.ClassMetadata;
import com.github.yin.cli.ClassMetadataIndex;
import com.github.yin.cli.FlagIndex;
import com.github.yin.cli.FlagMetadata;
import com.github.yin.cli.annotations.Usage;
import java.lang.reflect.Field;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassScanner {
    private static final Logger log = LoggerFactory.getLogger(ClassScanner.class);

    public void scanClass(String className, FlagIndex<FlagMetadata> index, ClassMetadataIndex classMetaIndex) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        this.scanClass(clazz, index, classMetaIndex);
    }

    public void scanClass(Class<?> clazz, FlagIndex<FlagMetadata> index, ClassMetadataIndex classMetadataIndex) {
        this.collectClassMetadata(clazz, classMetadataIndex);
        this.collectFlagInfo(clazz, index);
    }

    private void collectClassMetadata(Class<?> clazz, ClassMetadataIndex classMetadataIndex) {
        Usage[] flagDescs = (Usage[])clazz.getAnnotationsByType(Usage.class);
        if (flagDescs.length > 1) {
            log.error("Multiple @Usage occurrences on class: {}", clazz);
            return;
        }
        for (Usage desc : flagDescs) {
            ClassMetadata classInfo = ClassMetadata.create(clazz.getCanonicalName(), desc.value());
            classMetadataIndex.classes().put(clazz.getCanonicalName(), classInfo);
        }
    }

    public void collectFlagInfo(Class<?> clazz, FlagIndex<FlagMetadata> index) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            Usage[] flagDescs = (Usage[])field.getAnnotationsByType(Usage.class);
            if (flagDescs.length > 1) {
                log.error("Multiple @Usage occurrences on field: {}", (Object)field.toString());
                continue;
            }
            if ((field.getModifiers() & 8) == 0) {
                log.error("@Usage on non-static field: {}", (Object)field.toString());
                continue;
            }
            if ((field.getModifiers() & 0x10) == 0) {
                log.error("@Usage on non-final field: {}", (Object)field);
                continue;
            }
            if (field.isAccessible()) {
                log.error("@Usage on non-accessible filed: {}", (Object)field);
                continue;
            }
            for (Usage desc : flagDescs) {
                String name = desc.name() != null && !desc.name().isEmpty() ? desc.name() : field.getName();
                FlagMetadata meta = FlagMetadata.create(clazz.getCanonicalName(), name, desc.value(), field.getType());
                index.add(meta.flagID(), meta);
            }
        }
    }

    public void scanPackage(String packagePrefix, FlagIndex<FlagMetadata> index, ClassMetadataIndex classMetaIndex) {
        Reflections reflections = new Reflections(packagePrefix, new Scanner[0]);
        Set classDescs = reflections.getTypesAnnotatedWith(Usage.class);
        for (Class clazz : classDescs) {
            this.scanClass(clazz, index, classMetaIndex);
        }
    }
}

