/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs;

import cdc.graphs.EdgeDirection;
import cdc.graphs.EdgeDirectionMask;
import cdc.graphs.EdgeTip;
import cdc.graphs.GraphElementKind;
import cdc.graphs.NodeConnectivity;
import cdc.graphs.NodeRelativePosition;
import cdc.graphs.TraversalMethod;
import cdc.graphs.TraversalOrder;
import cdc.util.coverage.Coverage;
import cdc.util.function.Evaluation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EnumsTest {
    EnumsTest() {
    }

    @Test
    void testEdgeDirection() {
        Coverage.enumStandardCoverage(EdgeDirection.class);
        Assertions.assertEquals((Object)EdgeDirection.OUTGOING, (Object)EdgeDirection.INGOING.opposite());
        Assertions.assertEquals((Object)EdgeDirection.INGOING, (Object)EdgeDirection.OUTGOING.opposite());
    }

    @Test
    void testEdgeDirectionMask() {
        Coverage.enumStandardCoverage(EdgeDirectionMask.class);
        Assertions.assertEquals((Object)EdgeDirectionMask.NONE, (Object)EdgeDirectionMask.NONE.setEnabled(EdgeDirection.INGOING, false));
        Assertions.assertEquals((Object)EdgeDirectionMask.INGOING, (Object)EdgeDirectionMask.NONE.setEnabled(EdgeDirection.INGOING, true));
        Assertions.assertEquals((Object)EdgeDirectionMask.NONE, (Object)EdgeDirectionMask.NONE.setEnabled(EdgeDirection.OUTGOING, false));
        Assertions.assertEquals((Object)EdgeDirectionMask.OUTGOING, (Object)EdgeDirectionMask.NONE.setEnabled(EdgeDirection.OUTGOING, true));
        Assertions.assertEquals((Object)EdgeDirectionMask.NONE, (Object)EdgeDirectionMask.INGOING.setEnabled(EdgeDirection.INGOING, false));
        Assertions.assertEquals((Object)EdgeDirectionMask.INGOING, (Object)EdgeDirectionMask.INGOING.setEnabled(EdgeDirection.INGOING, true));
        Assertions.assertEquals((Object)EdgeDirectionMask.INGOING, (Object)EdgeDirectionMask.INGOING.setEnabled(EdgeDirection.OUTGOING, false));
        Assertions.assertEquals((Object)EdgeDirectionMask.BOTH, (Object)EdgeDirectionMask.INGOING.setEnabled(EdgeDirection.OUTGOING, true));
        Assertions.assertEquals((Object)EdgeDirectionMask.OUTGOING, (Object)EdgeDirectionMask.OUTGOING.setEnabled(EdgeDirection.INGOING, false));
        Assertions.assertEquals((Object)EdgeDirectionMask.BOTH, (Object)EdgeDirectionMask.OUTGOING.setEnabled(EdgeDirection.INGOING, true));
        Assertions.assertEquals((Object)EdgeDirectionMask.NONE, (Object)EdgeDirectionMask.OUTGOING.setEnabled(EdgeDirection.OUTGOING, false));
        Assertions.assertEquals((Object)EdgeDirectionMask.OUTGOING, (Object)EdgeDirectionMask.OUTGOING.setEnabled(EdgeDirection.OUTGOING, true));
        Assertions.assertEquals((Object)EdgeDirectionMask.OUTGOING, (Object)EdgeDirectionMask.BOTH.setEnabled(EdgeDirection.INGOING, false));
        Assertions.assertEquals((Object)EdgeDirectionMask.BOTH, (Object)EdgeDirectionMask.BOTH.setEnabled(EdgeDirection.INGOING, true));
        Assertions.assertEquals((Object)EdgeDirectionMask.INGOING, (Object)EdgeDirectionMask.BOTH.setEnabled(EdgeDirection.OUTGOING, false));
        Assertions.assertEquals((Object)EdgeDirectionMask.BOTH, (Object)EdgeDirectionMask.BOTH.setEnabled(EdgeDirection.OUTGOING, true));
        Assertions.assertFalse((boolean)EdgeDirectionMask.NONE.isEnabled(EdgeDirection.INGOING));
        Assertions.assertFalse((boolean)EdgeDirectionMask.NONE.isEnabled(EdgeDirection.OUTGOING));
        Assertions.assertTrue((boolean)EdgeDirectionMask.INGOING.isEnabled(EdgeDirection.INGOING));
        Assertions.assertFalse((boolean)EdgeDirectionMask.INGOING.isEnabled(EdgeDirection.OUTGOING));
        Assertions.assertFalse((boolean)EdgeDirectionMask.OUTGOING.isEnabled(EdgeDirection.INGOING));
        Assertions.assertTrue((boolean)EdgeDirectionMask.OUTGOING.isEnabled(EdgeDirection.OUTGOING));
        Assertions.assertTrue((boolean)EdgeDirectionMask.BOTH.isEnabled(EdgeDirection.INGOING));
        Assertions.assertTrue((boolean)EdgeDirectionMask.BOTH.isEnabled(EdgeDirection.OUTGOING));
    }

    @Test
    void testEdgeTip() {
        Coverage.enumStandardCoverage(EdgeTip.class);
        Assertions.assertEquals((Object)EdgeTip.TARGET, (Object)EdgeTip.SOURCE.opposite());
        Assertions.assertEquals((Object)EdgeTip.SOURCE, (Object)EdgeTip.TARGET.opposite());
    }

    @Test
    void testNodeConnectivity() {
        Coverage.enumStandardCoverage(NodeConnectivity.class);
        Assertions.assertTrue((boolean)NodeConnectivity.IN_OUT.hasOut());
        Assertions.assertFalse((boolean)NodeConnectivity.IN.hasOut());
        Assertions.assertTrue((boolean)NodeConnectivity.OUT.hasOut());
        Assertions.assertFalse((boolean)NodeConnectivity.ISOLATED.hasOut());
        Assertions.assertTrue((boolean)NodeConnectivity.IN_OUT.hasIn());
        Assertions.assertTrue((boolean)NodeConnectivity.IN.hasIn());
        Assertions.assertFalse((boolean)NodeConnectivity.OUT.hasIn());
        Assertions.assertFalse((boolean)NodeConnectivity.ISOLATED.hasIn());
    }

    @Test
    void testGraphElementKind() {
        Assertions.assertTrue((boolean)Coverage.enumStandardCoverage(GraphElementKind.class));
    }

    @Test
    void testTraversalOrder() {
        Assertions.assertTrue((boolean)Coverage.enumStandardCoverage(TraversalOrder.class));
    }

    @Test
    void testTraversalMethod() {
        Assertions.assertTrue((boolean)Coverage.enumStandardCoverage(TraversalMethod.class));
    }

    @Test
    void testNodeRelativePosition() {
        Assertions.assertTrue((boolean)Coverage.enumStandardCoverage(NodeRelativePosition.class));
    }

    @Test
    void testEvaluation() {
        Assertions.assertTrue((boolean)Coverage.enumStandardCoverage(Evaluation.class));
    }
}

