/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.api.EdgeDirection;
import cdc.graphs.api.EdgeTip;
import cdc.graphs.api.GraphEdge;
import cdc.graphs.impl.BasicGraphEdge;
import cdc.graphs.impl.BasicSuperLightGraph;
import cdc.util.function.IterableUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BasicSuperLightGraphTest {
    BasicSuperLightGraphTest() {
    }

    @Test
    void test1() {
        BasicSuperLightGraph g = new BasicSuperLightGraph();
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)g.getNodes()));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)g.getEdges()));
        g.addNode((Object)"Hello");
        g.addNode((Object)"World");
        Assertions.assertEquals((int)2, (int)IterableUtils.size((Iterable)g.getNodes()));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)g.getEdges()));
        BasicGraphEdge e1 = g.addEdge((Object)"Hello", (Object)"World");
        g.addEdge((Object)"Hello", (Object)"Hello");
        g.addEdge((Object)"World", (Object)"World");
        Assertions.assertEquals((Object)"Hello", (Object)g.getTip((GraphEdge)e1, EdgeTip.SOURCE));
        Assertions.assertEquals((Object)"World", (Object)g.getTip((GraphEdge)e1, EdgeTip.TARGET));
        Assertions.assertEquals((int)2, (int)IterableUtils.size((Iterable)g.getNodes()));
        Assertions.assertEquals((int)3, (int)IterableUtils.size((Iterable)g.getEdges()));
        Assertions.assertEquals((int)2, (int)IterableUtils.size((Iterable)g.getEdges((Object)"Hello")));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getEdges((Object)"Hello", EdgeDirection.INGOING)));
        Assertions.assertEquals((int)2, (int)IterableUtils.size((Iterable)g.getEdges((Object)"Hello", EdgeDirection.OUTGOING)));
        g.removeEdge((GraphEdge)e1);
        Assertions.assertEquals((int)2, (int)IterableUtils.size((Iterable)g.getNodes()));
        Assertions.assertEquals((int)2, (int)IterableUtils.size((Iterable)g.getEdges()));
        g.removeNode((Object)"Hello");
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getNodes()));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)g.getEdges()));
        Assertions.assertTrue((boolean)g.containsEdge((Object)"World", (Object)"World"));
        Assertions.assertFalse((boolean)g.containsEdge((Object)"Hello", (Object)"Hello"));
    }
}

