/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.api.EdgeDirection;
import cdc.graphs.api.EdgeTip;
import cdc.graphs.api.GraphAdapter;
import cdc.graphs.api.GraphEdge;
import cdc.util.function.IterableUtils;
import cdc.util.lang.Checks;
import cdc.util.lang.InvalidStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class BasicLightGraph<N, E extends GraphEdge<N>>
implements GraphAdapter<N, E> {
    private final Set<E> edges;
    private final Map<N, Collection<E>> nodeToEdges;
    private boolean locked = false;
    private boolean checks = true;
    private final Function<Object, Collection<E>> newEdgeCollection;

    public BasicLightGraph(boolean sorted, CollectionKind collectionKind) {
        if (sorted) {
            this.edges = new LinkedHashSet();
            this.nodeToEdges = new LinkedHashMap<N, Collection<E>>();
        } else {
            this.edges = new HashSet();
            this.nodeToEdges = new HashMap<N, Collection<E>>();
        }
        this.newEdgeCollection = collectionKind == CollectionKind.LIST ? o -> new ArrayList() : o -> new HashSet();
    }

    public BasicLightGraph(CollectionKind collectionKind) {
        this(false, collectionKind);
    }

    public BasicLightGraph() {
        this(CollectionKind.LIST);
    }

    public void setChecksEnabled(boolean enabled) {
        this.checks = enabled;
    }

    private Collection<E> getNodeEdges(N node) {
        Collection<E> tmp;
        if (this.checks) {
            Checks.isNotNull(node, (String)"node");
            Checks.isTrue((boolean)this.containsNode(node), (String)"Unknown node");
        }
        return (tmp = this.nodeToEdges.get(node)) == null ? Collections.emptySet() : tmp;
    }

    private void checkIsUnlocked() {
        if (this.locked) {
            throw new InvalidStateException("Locked");
        }
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void clear() {
        if (this.checks) {
            this.checkIsUnlocked();
        }
        this.edges.clear();
        this.nodeToEdges.clear();
    }

    public void clearEdges() {
        if (this.checks) {
            this.checkIsUnlocked();
        }
        this.edges.clear();
    }

    public <X extends N> X addNode(X node) {
        if (this.checks) {
            this.checkIsUnlocked();
            Checks.isNotNull(node, (String)"node");
            Checks.isTrue((!this.containsNode(node) ? 1 : 0) != 0, (String)"Node already declared: {}", node);
        }
        this.nodeToEdges.put(node, null);
        return node;
    }

    public void addNodes(Collection<? extends N> nodes) {
        for (N node : nodes) {
            this.addNode(node);
        }
    }

    public <X extends N> void addNodeIfMissing(X node) {
        if (!this.containsNode(node)) {
            this.addNode(node);
        }
    }

    public void addNodesIfMissing(Collection<? extends N> nodes) {
        for (N node : nodes) {
            this.addNodeIfMissing(node);
        }
    }

    public void removeNode(N node) {
        if (this.checks) {
            this.checkIsUnlocked();
            Checks.isNotNull(node, (String)"node");
            Checks.isTrue((boolean)this.containsNode(node), (String)"Node does not belong to graph: {}", node);
        }
        HashSet<GraphEdge> tmp = new HashSet<GraphEdge>();
        for (GraphEdge edge : this.getEdges(node)) {
            tmp.add(edge);
        }
        for (GraphEdge edge : tmp) {
            this.removeEdge(edge);
        }
        if (this.checks) {
            Checks.assertTrue((boolean)this.getNodeEdges(node).isEmpty(), (String)"Invalid state");
        }
        this.nodeToEdges.remove(node);
    }

    public void removeNodes(Collection<? extends N> nodes) {
        for (N node : nodes) {
            this.removeNode(node);
        }
    }

    public <X extends E> X addEdge(X edge) {
        if (this.checks) {
            this.checkIsUnlocked();
            Checks.isNotNull(edge, (String)"edge");
            Checks.isTrue((!this.containsEdge(edge) ? 1 : 0) != 0, (String)"Edge already declared: {}", edge);
            Checks.isTrue((boolean)this.containsNode(edge.getSource()), (String)"edge source {} does not belong to graph.", (Object)edge.getSource());
            Checks.isTrue((boolean)this.containsNode(edge.getTarget()), (String)"edge target {} does not belong to graph.", (Object)edge.getTarget());
        }
        this.edges.add(edge);
        Collection<X> sourceEdges = this.nodeToEdges.computeIfAbsent(edge.getSource(), this.newEdgeCollection);
        sourceEdges.add(edge);
        if (!edge.getSource().equals(edge.getTarget())) {
            Collection<X> targetEdges = this.nodeToEdges.computeIfAbsent(edge.getTarget(), this.newEdgeCollection);
            targetEdges.add(edge);
        }
        return edge;
    }

    public void addEdges(Collection<? extends E> edges) {
        for (GraphEdge edge : edges) {
            this.addEdge(edge);
        }
    }

    public <X extends E> void addEdgeIfMissing(X edge) {
        if (!this.containsEdge(edge)) {
            this.addEdge(edge);
        }
    }

    public void addEdgesIfMissing(Collection<? extends E> edges) {
        for (GraphEdge edge : edges) {
            this.addEdgeIfMissing(edge);
        }
    }

    public void removeEdge(E edge) {
        if (this.checks) {
            this.checkIsUnlocked();
        }
        boolean removed = this.edges.remove(edge);
        if (this.checks) {
            Checks.assertTrue((boolean)removed, (String)"Failed to remove {} from edges", edge);
        }
        Collection<E> sourceEdges = this.nodeToEdges.get(edge.getSource());
        if (this.checks) {
            Checks.assertTrue((sourceEdges != null ? 1 : 0) != 0, (String)"Invalid state");
        }
        sourceEdges.remove(edge);
        if (!edge.getSource().equals(edge.getTarget())) {
            Collection<E> targetEdges = this.nodeToEdges.get(edge.getTarget());
            if (this.checks) {
                Checks.assertTrue((targetEdges != null ? 1 : 0) != 0, (String)"Invalid state");
            }
            targetEdges.remove(edge);
        }
    }

    public void removeEdges(Collection<? extends E> edges) {
        for (GraphEdge edge : edges) {
            this.removeEdge(edge);
        }
    }

    public final Iterable<N> getNodes() {
        return this.nodeToEdges.keySet();
    }

    public final boolean containsNode(N node) {
        return this.nodeToEdges.containsKey(node);
    }

    public final Iterable<E> getEdges() {
        return this.edges;
    }

    public final boolean containsEdge(E edge) {
        return this.edges.contains(edge);
    }

    public boolean containsEdge(N source, N target) {
        Collection<E> sourceEdges = this.nodeToEdges.get(source);
        Collection<E> targetEdges = this.nodeToEdges.get(target);
        if (sourceEdges == null || targetEdges == null) {
            return false;
        }
        if (sourceEdges.size() <= targetEdges.size()) {
            for (GraphEdge edge : sourceEdges) {
                if (!edge.getTarget().equals(target) || !edge.getSource().equals(source)) continue;
                return true;
            }
            return false;
        }
        for (GraphEdge edge : targetEdges) {
            if (!edge.getSource().equals(source) || !edge.getTarget().equals(target)) continue;
            return true;
        }
        return false;
    }

    public final Iterable<? extends E> getEdges(N node, EdgeDirection direction) {
        Collection<E> nodeEdges = this.getNodeEdges(node);
        if (direction == null) {
            return nodeEdges;
        }
        if (direction == EdgeDirection.INGOING) {
            return IterableUtils.filter(nodeEdges, e -> e.getTarget().equals(node));
        }
        return IterableUtils.filter(nodeEdges, e -> e.getSource().equals(node));
    }

    public final N getTip(E edge, EdgeTip tip) {
        if (this.checks) {
            Checks.isNotNull(edge, (String)"edge");
            Checks.isNotNull((Object)tip, (String)"tip");
        }
        if (tip == EdgeTip.SOURCE) {
            return (N)edge.getSource();
        }
        return (N)edge.getTarget();
    }

    public static enum CollectionKind {
        LIST,
        SET;

    }
}

