/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.api.EdgeDirection;
import cdc.graphs.api.EdgeTip;
import cdc.graphs.api.GraphAdapter;
import cdc.graphs.impl.ExplicitSubGraph;
import cdc.util.function.IterableUtils;
import java.util.HashSet;
import java.util.function.Predicate;

public class ExtensionSubGraph<N, E>
extends ExplicitSubGraph<N, E> {
    private final HashSet<N> nodes = new HashSet();
    final HashSet<E> edges = new HashSet();
    private final Predicate<E> isOwnedEdge = this.edges::contains;

    public ExtensionSubGraph(GraphAdapter<N, E> delegate) {
        super(delegate);
    }

    @Override
    public final void clear() {
        this.edges.clear();
        this.nodes.clear();
    }

    @Override
    public final boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public final void addNode(N node) {
        this.checkNodeValidity(node);
        this.nodes.add(node);
    }

    @Override
    public final void removeNode(N node) {
        boolean removed = this.nodes.remove(node);
        if (removed) {
            for (Object edge : this.delegate.getEdges(node)) {
                this.removeEdge(edge);
            }
        }
    }

    @Override
    public final void addEdge(E edge) {
        this.checkEdgeValidity(edge);
        if (!this.edges.contains(edge)) {
            this.edges.add(edge);
            this.addNode(this.delegate.getTip(edge, EdgeTip.SOURCE));
            this.addNode(this.delegate.getTip(edge, EdgeTip.TARGET));
        }
    }

    @Override
    public final void removeEdge(E edge) {
        this.edges.remove(edge);
    }

    @Override
    public final void removeEdges(N source, N target) {
        for (Object edge : this.delegate.getEdges(source, EdgeDirection.OUTGOING)) {
            Object tgt = this.delegate.getTip(edge, EdgeTip.TARGET);
            if (target != tgt) continue;
            this.edges.remove(edge);
        }
    }

    public final Iterable<N> getNodes() {
        return this.nodes;
    }

    public final boolean containsNode(N node) {
        return this.nodes.contains(node);
    }

    public final Iterable<E> getEdges() {
        return this.edges;
    }

    public final boolean containsEdge(E edge) {
        return this.edges.contains(edge);
    }

    public final Iterable<? extends E> getEdges(N node, EdgeDirection direction) {
        return IterableUtils.filter((Iterable)this.delegate.getEdges(node, direction), this.isOwnedEdge);
    }

    public final N getTip(E edge, EdgeTip tip) {
        return (N)this.delegate.getTip(edge, tip);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getNodesCount() + " node(s) " + this.getEdgesCount() + " edge(s)";
    }
}

