/*
 * Decompiled with CFR 0.152.
 */
package cdc.graphs.impl;

import cdc.graphs.api.GraphAdapter;
import cdc.util.lang.Checks;

public abstract class GraphFilter<N, E>
implements GraphAdapter<N, E> {
    protected final GraphAdapter<N, E> delegate;

    protected GraphFilter(GraphAdapter<N, E> delegate) {
        Checks.isNotNull(delegate, (String)"delegate");
        this.delegate = delegate;
    }

    protected void checkNodeValidity(N node) {
        if (!this.delegate.containsNode(node)) {
            throw new IllegalArgumentException("Node (" + node + ") does not belong to delegate");
        }
    }

    protected void checkEdgeValidity(E edge) {
        if (!this.delegate.containsEdge(edge)) {
            throw new IllegalArgumentException("Edge does not belong to delegate");
        }
    }

    public final GraphAdapter<N, E> getDelegate() {
        return this.delegate;
    }
}

